/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.file;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.FreeingBufferRecycler;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageIdMappingUtils;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStoragePartitionId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageSubpartitionId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageTestUtils;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.file.PartitionFileReader;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.file.PartitionFileWriter;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.file.SegmentPartitionFileReader;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.file.SegmentPartitionFileWriter;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class SegmentPartitionFileReaderTest {
    private static final TieredStoragePartitionId DEFAULT_PARTITION_ID = TieredStorageIdMappingUtils.convertId((ResultPartitionID)new ResultPartitionID());
    private static final TieredStorageSubpartitionId DEFAULT_SUBPARTITION_ID = new TieredStorageSubpartitionId(0);
    private static final int DEFAULT_NUM_SUBPARTITION = 2;
    private static final int DEFAULT_SEGMENT_NUM = 2;
    private static final int DEFAULT_BUFFER_PER_SEGMENT = 3;
    private static final int DEFAULT_BUFFER_SIZE = 1;
    @TempDir
    private File tempFolder;
    private SegmentPartitionFileReader partitionFileReader;

    SegmentPartitionFileReaderTest() {
    }

    @BeforeEach
    void before() {
        Path tieredStorageDir = Path.fromLocalFile((File)this.tempFolder);
        SegmentPartitionFileWriter partitionFileWriter = new SegmentPartitionFileWriter(tieredStorageDir.getPath(), 2);
        List<PartitionFileWriter.SubpartitionBufferContext> subpartitionBuffers = TieredStorageTestUtils.generateBuffersToWrite(2, 2, 3, 1);
        partitionFileWriter.write(DEFAULT_PARTITION_ID, subpartitionBuffers);
        partitionFileWriter.release();
        this.partitionFileReader = new SegmentPartitionFileReader(tieredStorageDir.getPath());
    }

    @Test
    void testReadBuffer() throws IOException {
        for (int subpartitionId = 0; subpartitionId < 2; ++subpartitionId) {
            for (int segmentId = 0; segmentId < 2; ++segmentId) {
                for (int bufferIndex = 0; bufferIndex < 3; ++bufferIndex) {
                    Buffer buffer = this.readBuffer(bufferIndex, new TieredStorageSubpartitionId(subpartitionId), segmentId);
                    Assertions.assertThat((Object)buffer).isNotNull();
                    buffer.recycleBuffer();
                }
            }
        }
    }

    @Test
    void testGetPriority() throws IOException {
        Assertions.assertThat((long)this.partitionFileReader.getPriority(DEFAULT_PARTITION_ID, DEFAULT_SUBPARTITION_ID, 0, 0, null)).isEqualTo(-1L);
        Assertions.assertThat((Object)this.readBuffer(0, DEFAULT_SUBPARTITION_ID, 0)).isNotNull();
        Assertions.assertThat((long)this.partitionFileReader.getPriority(DEFAULT_PARTITION_ID, DEFAULT_SUBPARTITION_ID, 0, 1, null)).isEqualTo(-1L);
    }

    private Buffer readBuffer(int bufferIndex, TieredStorageSubpartitionId subpartitionId, int segmentId) throws IOException {
        MemorySegment memorySegment = MemorySegmentFactory.allocateUnpooledSegment((int)1);
        PartitionFileReader.ReadBufferResult readBufferResult = this.partitionFileReader.readBuffer(DEFAULT_PARTITION_ID, subpartitionId, segmentId, bufferIndex, memorySegment, FreeingBufferRecycler.INSTANCE, null, null);
        if (readBufferResult == null) {
            return null;
        }
        return (Buffer)readBufferResult.getReadBuffers().get(0);
    }
}

