/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.FreeingBufferRecycler;
import org.apache.flink.runtime.io.network.buffer.NetworkBuffer;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageSubpartitionId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.BufferAccumulator;
import org.apache.flink.util.function.TriConsumer;

public class TestingBufferAccumulator
implements BufferAccumulator {
    private TriConsumer<TieredStorageSubpartitionId, Buffer, Integer> bufferFlusher;

    public void setup(TriConsumer<TieredStorageSubpartitionId, Buffer, Integer> bufferFlusher) {
        this.bufferFlusher = bufferFlusher;
    }

    public void receive(ByteBuffer record, TieredStorageSubpartitionId subpartitionId, Buffer.DataType dataType, boolean isBroadcast) throws IOException {
        MemorySegment recordData = MemorySegmentFactory.wrap((byte[])record.array());
        this.bufferFlusher.accept((Object)subpartitionId, (Object)new NetworkBuffer(recordData, FreeingBufferRecycler.INSTANCE, dataType, recordData.size()), (Object)0);
    }

    public void close() {
    }
}

