/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.flink.runtime.io.network.NetworkSequenceViewReader;
import org.apache.flink.runtime.io.network.netty.NettyPartitionRequestListener;
import org.apache.flink.runtime.io.network.partition.BufferAvailabilityListener;
import org.apache.flink.runtime.io.network.partition.NoOpBufferAvailablityListener;
import org.apache.flink.runtime.io.network.partition.PartitionRequestListener;
import org.apache.flink.runtime.io.network.partition.PartitionRequestListenerManager;
import org.apache.flink.runtime.io.network.partition.PartitionTestUtils;
import org.apache.flink.runtime.io.network.partition.ResultPartition;
import org.apache.flink.runtime.io.network.partition.ResultPartitionManager;
import org.apache.flink.runtime.io.network.partition.ResultPartitionProvider;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionIndexSet;
import org.apache.flink.runtime.io.network.partition.TestingPartitionRequestListener;
import org.apache.flink.runtime.io.network.partition.TestingResultPartitionProvider;
import org.apache.flink.runtime.io.network.partition.TestingSubpartitionCreatedViewReader;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannelID;
import org.apache.flink.util.concurrent.ManuallyTriggeredScheduledExecutor;
import org.apache.flink.util.concurrent.ScheduledExecutor;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ResultPartitionManagerTest {
    ResultPartitionManagerTest() {
    }

    @Test
    void testThrowPartitionNotFoundException() {
        ResultPartitionManager partitionManager = new ResultPartitionManager();
        ResultPartition partition = PartitionTestUtils.createPartition();
        PartitionTestUtils.verifyCreateSubpartitionViewThrowsException((ResultPartitionProvider)partitionManager, partition.getPartitionId());
    }

    @Test
    void testCreateViewForRegisteredPartition() throws Exception {
        ResultPartitionManager partitionManager = new ResultPartitionManager();
        ResultPartition partition = PartitionTestUtils.createPartition();
        partitionManager.registerResultPartition(partition);
        partitionManager.createSubpartitionView(partition.getPartitionId(), new ResultSubpartitionIndexSet(0), (BufferAvailabilityListener)new NoOpBufferAvailablityListener());
    }

    @Test
    void testCreateSubpartitionViewAfterRegisteredPartition() throws Exception {
        ResultPartitionManager partitionManager = new ResultPartitionManager();
        ResultPartition partition = PartitionTestUtils.createPartition();
        Assertions.assertThat((boolean)partitionManager.getListenerManagers().isEmpty()).isTrue();
        partitionManager.registerResultPartition(partition);
        TestingPartitionRequestListener partitionRequestListener = TestingPartitionRequestListener.newBuilder().build();
        Assertions.assertThat((Optional)partitionManager.createSubpartitionViewOrRegisterListener(partition.getPartitionId(), new ResultSubpartitionIndexSet(0), (BufferAvailabilityListener)new NoOpBufferAvailablityListener(), (PartitionRequestListener)partitionRequestListener)).isPresent();
        Assertions.assertThat((boolean)partitionManager.getListenerManagers().isEmpty()).isTrue();
    }

    @Test
    void testRegisterPartitionListenerBeforeRegisteredPartition() throws Exception {
        ResultPartitionManager partitionManager = new ResultPartitionManager();
        ResultPartition partition = PartitionTestUtils.createPartition();
        Assertions.assertThat((boolean)partitionManager.getListenerManagers().isEmpty()).isTrue();
        CompletableFuture notifySubpartitionCreatedFuture = new CompletableFuture();
        TestingPartitionRequestListener partitionRequestListener = TestingPartitionRequestListener.newBuilder().setResultPartitionId(partition.getPartitionId()).setNetworkSequenceViewReader(TestingSubpartitionCreatedViewReader.newBuilder().setNotifySubpartitionCreatedConsumer(tuple -> notifySubpartitionCreatedFuture.complete(tuple.f0)).build()).build();
        Assertions.assertThat((Optional)partitionManager.createSubpartitionViewOrRegisterListener(partition.getPartitionId(), new ResultSubpartitionIndexSet(0), (BufferAvailabilityListener)new NoOpBufferAvailablityListener(), (PartitionRequestListener)partitionRequestListener)).isNotPresent();
        Assertions.assertThat((Map)partitionManager.getListenerManagers()).hasSize(1);
        PartitionRequestListenerManager listenerManager = (PartitionRequestListenerManager)partitionManager.getListenerManagers().get(partition.getPartitionId());
        Assertions.assertThat((Object)listenerManager).isNotNull();
        Assertions.assertThat((boolean)listenerManager.isEmpty()).isFalse();
        Assertions.assertThat((Collection)listenerManager.getPartitionRequestListeners()).hasSize(1);
        PartitionRequestListener listener = (PartitionRequestListener)listenerManager.getPartitionRequestListeners().iterator().next();
        Assertions.assertThat((Object)listener.getResultPartitionId()).isEqualTo((Object)partition.getPartitionId());
        Assertions.assertThat(notifySubpartitionCreatedFuture).isNotDone();
        partitionManager.registerResultPartition(partition);
        ResultPartition notifyPartition = (ResultPartition)notifySubpartitionCreatedFuture.get(10L, TimeUnit.MILLISECONDS);
        Assertions.assertThat((Object)partition.getPartitionId()).isEqualTo((Object)notifyPartition.getPartitionId());
        Assertions.assertThat((boolean)partitionManager.getListenerManagers().isEmpty()).isTrue();
    }

    @Test
    void testCreateViewForReleasedPartition() throws Exception {
        ResultPartitionManager partitionManager = new ResultPartitionManager();
        ResultPartition partition = PartitionTestUtils.createPartition();
        partitionManager.registerResultPartition(partition);
        partitionManager.releasePartition(partition.getPartitionId(), null);
        PartitionTestUtils.verifyCreateSubpartitionViewThrowsException((ResultPartitionProvider)partitionManager, partition.getPartitionId());
    }

    @Test
    void testGetMetricsOfPartition() throws Exception {
        ResultPartitionManager partitionManager = new ResultPartitionManager();
        ResultPartition partition = PartitionTestUtils.createPartition();
        partition.resultPartitionBytes.incAll(100L);
        partitionManager.registerResultPartition(partition);
        Optional metricsOfPartition = partitionManager.getMetricsOfPartition(partition.partitionId);
        Assertions.assertThat((Optional)metricsOfPartition).hasValueSatisfying(metrics -> Arrays.equals(metrics.getPartitionBytes().getSubpartitionBytes(), new long[]{100L}));
    }

    @Test
    void testCreateViewReaderForNotifierTimeout() throws Exception {
        ManuallyTriggeredScheduledExecutor scheduledExecutor = new ManuallyTriggeredScheduledExecutor();
        ResultPartitionManager partitionManager = new ResultPartitionManager(1000000, (ScheduledExecutor)scheduledExecutor);
        ResultPartition partition1 = PartitionTestUtils.createPartition();
        ResultPartition partition2 = PartitionTestUtils.createPartition();
        CompletableFuture timeoutFuture1 = new CompletableFuture();
        CompletableFuture timeoutFuture2 = new CompletableFuture();
        partitionManager.createSubpartitionViewOrRegisterListener(partition1.getPartitionId(), new ResultSubpartitionIndexSet(0), (BufferAvailabilityListener)new NoOpBufferAvailablityListener(), (PartitionRequestListener)new NettyPartitionRequestListener((ResultPartitionProvider)TestingResultPartitionProvider.newBuilder().build(), (NetworkSequenceViewReader)TestingSubpartitionCreatedViewReader.newBuilder().setReceiverId(new InputChannelID()).setPartitionRequestListenerTimeoutConsumer(timeoutFuture1::complete).build(), new ResultSubpartitionIndexSet(0), partition1.getPartitionId(), 0L));
        partitionManager.createSubpartitionViewOrRegisterListener(partition2.getPartitionId(), new ResultSubpartitionIndexSet(0), (BufferAvailabilityListener)new NoOpBufferAvailablityListener(), (PartitionRequestListener)new NettyPartitionRequestListener((ResultPartitionProvider)TestingResultPartitionProvider.newBuilder().build(), (NetworkSequenceViewReader)TestingSubpartitionCreatedViewReader.newBuilder().setReceiverId(new InputChannelID()).setPartitionRequestListenerTimeoutConsumer(timeoutFuture2::complete).build(), new ResultSubpartitionIndexSet(0), partition2.getPartitionId()));
        scheduledExecutor.triggerScheduledTasks();
        Assertions.assertThat((boolean)timeoutFuture1.isDone()).isTrue();
        Assertions.assertThat((Object)partition1.getPartitionId()).isEqualTo((Object)((PartitionRequestListener)timeoutFuture1.get()).getResultPartitionId());
        Assertions.assertThat((boolean)timeoutFuture2.isDone()).isFalse();
        Assertions.assertThat(partitionManager.getListenerManagers().get(partition1.getPartitionId())).isNull();
        Assertions.assertThat(partitionManager.getListenerManagers().get(partition2.getPartitionId())).isNotNull();
    }
}

