/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.buffer;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.io.network.api.EndOfPartitionEvent;
import org.apache.flink.runtime.io.network.api.serialization.EventSerializer;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.FreeingBufferRecycler;
import org.apache.flink.runtime.io.network.buffer.NetworkBuffer;
import org.apache.flink.runtime.io.network.buffer.NetworkBufferTest;
import org.apache.flink.runtime.io.network.buffer.ReadOnlySlicedNetworkBuffer;
import org.apache.flink.runtime.io.network.netty.NettyBufferPool;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBufAllocator;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ReadOnlySlicedBufferTest {
    private static final int BUFFER_SIZE = 1024;
    private static final int DATA_SIZE = 10;
    private NetworkBuffer buffer;

    ReadOnlySlicedBufferTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        MemorySegment segment = MemorySegmentFactory.allocateUnpooledSegment((int)1024);
        this.buffer = new NetworkBuffer(segment, FreeingBufferRecycler.INSTANCE, Buffer.DataType.DATA_BUFFER, 0);
        for (int i = 0; i < 10; ++i) {
            this.buffer.writeByte(i);
        }
    }

    @Test
    void testForwardsIsBuffer() throws IOException {
        Assertions.assertThat((boolean)this.buffer.readOnlySlice().isBuffer()).isEqualTo(this.buffer.isBuffer());
        Assertions.assertThat((boolean)this.buffer.readOnlySlice(1, 2).isBuffer()).isEqualTo(this.buffer.isBuffer());
        Buffer eventBuffer = EventSerializer.toBuffer((AbstractEvent)EndOfPartitionEvent.INSTANCE, (boolean)false);
        Assertions.assertThat((boolean)eventBuffer.readOnlySlice().isBuffer()).isEqualTo(eventBuffer.isBuffer());
        Assertions.assertThat((boolean)eventBuffer.readOnlySlice(1, 2).isBuffer()).isEqualTo(eventBuffer.isBuffer());
    }

    @Test
    void testSetDataType1() {
        ReadOnlySlicedNetworkBuffer readOnlyBuffer = this.buffer.readOnlySlice();
        readOnlyBuffer.setDataType(Buffer.DataType.EVENT_BUFFER);
        Assertions.assertThat((Comparable)readOnlyBuffer.getDataType()).isEqualTo((Object)Buffer.DataType.EVENT_BUFFER);
    }

    @Test
    void testSetDataType2() {
        ReadOnlySlicedNetworkBuffer readOnlyBuffer = this.buffer.readOnlySlice(1, 2);
        readOnlyBuffer.setDataType(Buffer.DataType.EVENT_BUFFER);
        Assertions.assertThat((Comparable)readOnlyBuffer.getDataType()).isEqualTo((Object)Buffer.DataType.EVENT_BUFFER);
        Assertions.assertThat((Comparable)this.buffer.readOnlySlice(1, 2).getDataType()).isNotEqualTo((Object)Buffer.DataType.EVENT_BUFFER);
    }

    @Test
    void testForwardsGetMemorySegment() {
        Assertions.assertThat((Object)this.buffer.readOnlySlice().getMemorySegment()).isSameAs((Object)this.buffer.getMemorySegment());
        Assertions.assertThat((Object)this.buffer.readOnlySlice(1, 2).getMemorySegment()).isSameAs((Object)this.buffer.getMemorySegment());
    }

    @Test
    void testForwardsGetRecycler() {
        Assertions.assertThat((Object)this.buffer.readOnlySlice().getRecycler()).isSameAs((Object)this.buffer.getRecycler());
        Assertions.assertThat((Object)this.buffer.readOnlySlice(1, 2).getRecycler()).isSameAs((Object)this.buffer.getRecycler());
    }

    @Test
    void testForwardsRecycleBuffer1() {
        ReadOnlySlicedNetworkBuffer slice = this.buffer.readOnlySlice();
        Assertions.assertThat((boolean)slice.isRecycled()).isFalse();
        slice.recycleBuffer();
        Assertions.assertThat((boolean)slice.isRecycled()).isTrue();
        Assertions.assertThat((boolean)this.buffer.isRecycled()).isTrue();
    }

    @Test
    void testForwardsRecycleBuffer2() {
        ReadOnlySlicedNetworkBuffer slice = this.buffer.readOnlySlice(1, 2);
        Assertions.assertThat((boolean)slice.isRecycled()).isFalse();
        slice.recycleBuffer();
        Assertions.assertThat((boolean)slice.isRecycled()).isTrue();
        Assertions.assertThat((boolean)this.buffer.isRecycled()).isTrue();
    }

    @Test
    void testForwardsRetainBuffer1() {
        ReadOnlySlicedNetworkBuffer slice = this.buffer.readOnlySlice();
        Assertions.assertThat((int)slice.refCnt()).isEqualTo(this.buffer.refCnt());
        slice.retainBuffer();
        Assertions.assertThat((int)slice.refCnt()).isEqualTo(this.buffer.refCnt());
    }

    @Test
    void testForwardsRetainBuffer2() {
        ReadOnlySlicedNetworkBuffer slice = this.buffer.readOnlySlice(1, 2);
        Assertions.assertThat((int)slice.refCnt()).isEqualTo(this.buffer.refCnt());
        slice.retainBuffer();
        Assertions.assertThat((int)slice.refCnt()).isEqualTo(this.buffer.refCnt());
    }

    @Test
    void testCreateSlice1() {
        this.buffer.readByte();
        ReadOnlySlicedNetworkBuffer slice1 = this.buffer.readOnlySlice();
        this.buffer.readByte();
        ReadOnlySlicedNetworkBuffer slice2 = slice1.readOnlySlice();
        Assertions.assertThat((Comparable)slice2.unwrap().unwrap()).isSameAs((Object)this.buffer);
        Assertions.assertThat((Object)slice2.getMemorySegment()).isEqualTo((Object)slice1.getMemorySegment());
        Assertions.assertThat((int)slice2.getMemorySegmentOffset()).isEqualTo(slice1.getMemorySegmentOffset()).isOne();
        ReadOnlySlicedBufferTest.assertReadableBytes((Buffer)slice1, 1, 2, 3, 4, 5, 6, 7, 8, 9);
        ReadOnlySlicedBufferTest.assertReadableBytes((Buffer)slice2, 1, 2, 3, 4, 5, 6, 7, 8, 9);
    }

    @Test
    void testCreateSlice2() {
        this.buffer.readByte();
        ReadOnlySlicedNetworkBuffer slice1 = this.buffer.readOnlySlice();
        this.buffer.readByte();
        ReadOnlySlicedNetworkBuffer slice2 = slice1.readOnlySlice(1, 2);
        Assertions.assertThat((Comparable)slice2.unwrap().unwrap()).isSameAs((Object)this.buffer);
        Assertions.assertThat((Object)slice2.getMemorySegment()).isEqualTo((Object)slice1.getMemorySegment());
        Assertions.assertThat((int)slice1.getMemorySegmentOffset()).isOne();
        Assertions.assertThat((int)slice2.getMemorySegmentOffset()).isEqualTo(2);
        ReadOnlySlicedBufferTest.assertReadableBytes((Buffer)slice1, 1, 2, 3, 4, 5, 6, 7, 8, 9);
        ReadOnlySlicedBufferTest.assertReadableBytes((Buffer)slice2, 2, 3);
    }

    @Test
    void testCreateSlice3() {
        ReadOnlySlicedNetworkBuffer slice1 = this.buffer.readOnlySlice(1, 2);
        this.buffer.readByte();
        ReadOnlySlicedNetworkBuffer slice2 = slice1.readOnlySlice();
        Assertions.assertThat((Comparable)slice2.unwrap().unwrap()).isSameAs((Object)this.buffer);
        Assertions.assertThat((Object)slice2.getMemorySegment()).isSameAs((Object)slice1.getMemorySegment());
        Assertions.assertThat((int)slice1.getMemorySegmentOffset()).isOne();
        Assertions.assertThat((int)slice2.getMemorySegmentOffset()).isOne();
        ReadOnlySlicedBufferTest.assertReadableBytes((Buffer)slice1, 1, 2);
        ReadOnlySlicedBufferTest.assertReadableBytes((Buffer)slice2, 1, 2);
    }

    @Test
    void testCreateSlice4() {
        ReadOnlySlicedNetworkBuffer slice1 = this.buffer.readOnlySlice(1, 5);
        this.buffer.readByte();
        ReadOnlySlicedNetworkBuffer slice2 = slice1.readOnlySlice(1, 2);
        Assertions.assertThat((Comparable)slice2.unwrap().unwrap()).isSameAs((Object)this.buffer);
        Assertions.assertThat((Object)slice2.getMemorySegment()).isSameAs((Object)slice1.getMemorySegment());
        Assertions.assertThat((int)slice1.getMemorySegmentOffset()).isOne();
        Assertions.assertThat((int)slice2.getMemorySegmentOffset()).isEqualTo(2);
        ReadOnlySlicedBufferTest.assertReadableBytes((Buffer)slice1, 1, 2, 3, 4, 5);
        ReadOnlySlicedBufferTest.assertReadableBytes((Buffer)slice2, 2, 3);
    }

    @Test
    void testGetMaxCapacity() {
        Assertions.assertThat((int)this.buffer.readOnlySlice().getMaxCapacity()).isEqualTo(10);
        Assertions.assertThat((int)this.buffer.readOnlySlice(1, 2).getMaxCapacity()).isEqualTo(2);
    }

    @Test
    void testGetSetReaderIndex1() {
        this.testGetSetReaderIndex(this.buffer.readOnlySlice());
    }

    @Test
    void testGetSetReaderIndex2() {
        this.testGetSetReaderIndex(this.buffer.readOnlySlice(1, 2));
    }

    private void testGetSetReaderIndex(ReadOnlySlicedNetworkBuffer slice) {
        Assertions.assertThat((int)this.buffer.getReaderIndex()).isZero();
        Assertions.assertThat((int)slice.getReaderIndex()).isZero();
        slice.setReaderIndex(1);
        Assertions.assertThat((int)this.buffer.getReaderIndex()).isZero();
        Assertions.assertThat((int)slice.getReaderIndex()).isOne();
    }

    @Test
    void testGetSetSize1() {
        this.testGetSetSize(this.buffer.readOnlySlice(), 10);
    }

    @Test
    void testGetSetSize2() {
        this.testGetSetSize(this.buffer.readOnlySlice(1, 2), 2);
    }

    private void testGetSetSize(ReadOnlySlicedNetworkBuffer slice, int sliceSize) {
        Assertions.assertThat((int)this.buffer.getSize()).isEqualTo(10);
        Assertions.assertThat((int)slice.getSize()).isEqualTo(sliceSize);
        this.buffer.setSize(11);
        Assertions.assertThat((int)this.buffer.getSize()).isEqualTo(11);
        Assertions.assertThat((int)slice.getSize()).isEqualTo(sliceSize);
    }

    @Test
    void testReadableBytes() {
        Assertions.assertThat((int)this.buffer.readOnlySlice().readableBytes()).isEqualTo(this.buffer.readableBytes());
        Assertions.assertThat((int)this.buffer.readOnlySlice(1, 2).readableBytes()).isEqualTo(2);
    }

    @Test
    void testGetNioBufferReadable1() {
        this.testGetNioBufferReadable(this.buffer.readOnlySlice(), 10);
    }

    @Test
    void testGetNioBufferReadable2() {
        this.testGetNioBufferReadable(this.buffer.readOnlySlice(1, 2), 2);
    }

    private void testGetNioBufferReadable(ReadOnlySlicedNetworkBuffer slice, int sliceSize) {
        ByteBuffer sliceByteBuffer = slice.getNioBufferReadable();
        Assertions.assertThat((boolean)sliceByteBuffer.isReadOnly()).isTrue();
        Assertions.assertThat((int)sliceByteBuffer.remaining()).isEqualTo(sliceSize);
        Assertions.assertThat((int)sliceByteBuffer.limit()).isEqualTo(sliceSize);
        Assertions.assertThat((int)sliceByteBuffer.capacity()).isEqualTo(sliceSize);
        sliceByteBuffer.position(1);
        Assertions.assertThat((int)this.buffer.getReaderIndex()).isZero();
        Assertions.assertThat((int)slice.getReaderIndex()).isZero();
        Assertions.assertThat((int)this.buffer.getSize()).isEqualTo(10);
        Assertions.assertThat((int)slice.getSize()).isEqualTo(sliceSize);
    }

    @Test
    void testGetNioBuffer1() {
        this.testGetNioBuffer(this.buffer.readOnlySlice(), 10);
    }

    @Test
    void testGetNioBuffer2() {
        this.testGetNioBuffer(this.buffer.readOnlySlice(1, 2), 2);
    }

    private void testGetNioBuffer(ReadOnlySlicedNetworkBuffer slice, int sliceSize) {
        ByteBuffer sliceByteBuffer = slice.getNioBuffer(1, 1);
        Assertions.assertThat((boolean)sliceByteBuffer.isReadOnly()).isTrue();
        Assertions.assertThat((int)sliceByteBuffer.remaining()).isOne();
        Assertions.assertThat((int)sliceByteBuffer.limit()).isOne();
        Assertions.assertThat((int)sliceByteBuffer.capacity()).isOne();
        sliceByteBuffer.position(1);
        Assertions.assertThat((int)this.buffer.getReaderIndex()).isZero();
        Assertions.assertThat((int)slice.getReaderIndex()).isZero();
        Assertions.assertThat((int)this.buffer.getSize()).isEqualTo(10);
        Assertions.assertThat((int)slice.getSize()).isEqualTo(sliceSize);
    }

    @Test
    void testGetNioBufferReadableThreadSafe1() {
        NetworkBufferTest.testGetNioBufferReadableThreadSafe((Buffer)this.buffer.readOnlySlice());
    }

    @Test
    void testGetNioBufferReadableThreadSafe2() {
        NetworkBufferTest.testGetNioBufferReadableThreadSafe((Buffer)this.buffer.readOnlySlice(1, 2));
    }

    @Test
    void testGetNioBufferThreadSafe1() {
        NetworkBufferTest.testGetNioBufferThreadSafe((Buffer)this.buffer.readOnlySlice(), 10);
    }

    @Test
    void testGetNioBufferThreadSafe2() {
        NetworkBufferTest.testGetNioBufferThreadSafe((Buffer)this.buffer.readOnlySlice(1, 2), 2);
    }

    @Test
    void testForwardsSetAllocator() {
        this.testForwardsSetAllocator(this.buffer.readOnlySlice());
        this.testForwardsSetAllocator(this.buffer.readOnlySlice(1, 2));
    }

    private void testForwardsSetAllocator(ReadOnlySlicedNetworkBuffer slice) {
        NettyBufferPool allocator = new NettyBufferPool(1);
        slice.setAllocator((ByteBufAllocator)allocator);
        Assertions.assertThat((Object)slice.alloc()).isSameAs((Object)this.buffer.alloc());
        Assertions.assertThat((Object)slice.alloc()).isSameAs((Object)allocator);
    }

    private static void assertReadableBytes(Buffer actualBuffer, int ... expectedBytes) {
        int i;
        ByteBuffer actualBytesBuffer = actualBuffer.getNioBufferReadable();
        int[] actual = new int[actualBytesBuffer.limit()];
        for (int i2 = 0; i2 < actual.length; ++i2) {
            actual[i2] = actualBytesBuffer.get();
        }
        Assertions.assertThat((int[])actual).isEqualTo((Object)expectedBytes);
        ByteBuf buffer = (ByteBuf)actualBuffer;
        for (i = 0; i < buffer.readableBytes(); ++i) {
            actual[i] = buffer.getByte(buffer.readerIndex() + i);
        }
        Assertions.assertThat((int[])actual).isEqualTo((Object)expectedBytes);
        for (i = 0; i < buffer.readableBytes(); ++i) {
            actual[i] = buffer.readByte();
        }
        Assertions.assertThat((int[])actual).isEqualTo((Object)expectedBytes);
    }
}

