/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.hooks;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.runtime.checkpoint.MasterTriggerRestoreHook;
import org.apache.flink.runtime.checkpoint.hooks.MasterHooks;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.CompletableFutureAssert;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;

class MasterHooksTest {
    MasterHooksTest() {
    }

    @Test
    void wrapHook() throws Exception {
        String id = "id";
        Thread thread = Thread.currentThread();
        ClassLoader originalClassLoader = thread.getContextClassLoader();
        final URLClassLoader userClassLoader = new URLClassLoader(new URL[0]);
        CompletableFuture onceRunnableFuture = new CompletableFuture();
        final Runnable onceRunnable = () -> {
            Assertions.assertThat((Object)Thread.currentThread().getContextClassLoader()).isEqualTo((Object)userClassLoader);
            ((CompletableFutureAssert)Assertions.assertThat((CompletableFuture)onceRunnableFuture).withFailMessage("The runnable shouldn't be called multiple times.", new Object[0])).isNotDone();
            onceRunnableFuture.complete(null);
        };
        final CompletableFuture getIdentifierFuture = new CompletableFuture();
        final CompletableFuture closeFuture = new CompletableFuture();
        final CompletableFuture restoreCheckpointFuture = new CompletableFuture();
        final CompletableFuture createCheckpointDataSerializerFuture = new CompletableFuture();
        MasterTriggerRestoreHook<String> hook = new MasterTriggerRestoreHook<String>(){

            public String getIdentifier() {
                Assertions.assertThat((Object)Thread.currentThread().getContextClassLoader()).isEqualTo((Object)userClassLoader);
                ((CompletableFutureAssert)Assertions.assertThat((CompletableFuture)getIdentifierFuture).withFailMessage("The method shouldn't be called multiple times.", new Object[0])).isNotDone();
                getIdentifierFuture.complete(null);
                return "id";
            }

            public void reset() {
                Assertions.assertThat((Object)Thread.currentThread().getContextClassLoader()).isEqualTo((Object)userClassLoader);
            }

            public void close() {
                Assertions.assertThat((Object)Thread.currentThread().getContextClassLoader()).isEqualTo((Object)userClassLoader);
                ((CompletableFutureAssert)Assertions.assertThat((CompletableFuture)closeFuture).withFailMessage("The method shouldn't be called multiple times.", new Object[0])).isNotDone();
                closeFuture.complete(null);
            }

            @Nullable
            public CompletableFuture<String> triggerCheckpoint(long checkpointId, long timestamp, Executor executor) {
                Assertions.assertThat((Object)Thread.currentThread().getContextClassLoader()).isEqualTo((Object)userClassLoader);
                executor.execute(onceRunnable);
                return null;
            }

            public void restoreCheckpoint(long checkpointId, @Nullable String checkpointData) {
                Assertions.assertThat((Object)Thread.currentThread().getContextClassLoader()).isEqualTo((Object)userClassLoader);
                Assertions.assertThat((long)checkpointId).isZero();
                Assertions.assertThat((String)checkpointData).isEmpty();
                ((CompletableFutureAssert)Assertions.assertThat((CompletableFuture)restoreCheckpointFuture).withFailMessage("The method shouldn't be called multiple times.", new Object[0])).isNotDone();
                restoreCheckpointFuture.complete(null);
            }

            @Nullable
            public SimpleVersionedSerializer<String> createCheckpointDataSerializer() {
                Assertions.assertThat((Object)Thread.currentThread().getContextClassLoader()).isEqualTo((Object)userClassLoader);
                ((CompletableFutureAssert)Assertions.assertThat((CompletableFuture)createCheckpointDataSerializerFuture).withFailMessage("The method shouldn't be called multiple times.", new Object[0])).isNotDone();
                createCheckpointDataSerializerFuture.complete(null);
                return null;
            }
        };
        MasterTriggerRestoreHook wrapped = MasterHooks.wrapHook((MasterTriggerRestoreHook)hook, (ClassLoader)userClassLoader);
        wrapped.getIdentifier();
        Assertions.assertThat(getIdentifierFuture).isCompleted();
        Assertions.assertThat((Object)thread.getContextClassLoader()).isEqualTo((Object)originalClassLoader);
        TestExecutor testExecutor = new TestExecutor();
        wrapped.triggerCheckpoint(0L, 0L, (Executor)testExecutor);
        Assertions.assertThat((Object)thread.getContextClassLoader()).isEqualTo((Object)originalClassLoader);
        Assertions.assertThat((Object)testExecutor.command).isNotNull();
        testExecutor.command.run();
        Assertions.assertThat(onceRunnableFuture).isCompleted();
        Assertions.assertThat((Object)thread.getContextClassLoader()).isEqualTo((Object)originalClassLoader);
        wrapped.restoreCheckpoint(0L, (Object)"");
        Assertions.assertThat(restoreCheckpointFuture).isCompleted();
        Assertions.assertThat((Object)thread.getContextClassLoader()).isEqualTo((Object)originalClassLoader);
        wrapped.createCheckpointDataSerializer();
        Assertions.assertThat(createCheckpointDataSerializerFuture).isCompleted();
        Assertions.assertThat((Object)thread.getContextClassLoader()).isEqualTo((Object)originalClassLoader);
        wrapped.close();
        Assertions.assertThat(closeFuture).isCompleted();
        Assertions.assertThat((Object)thread.getContextClassLoader()).isEqualTo((Object)originalClassLoader);
    }

    private static class TestExecutor
    implements Executor {
        Runnable command;

        private TestExecutor() {
        }

        @Override
        public void execute(@NotNull Runnable command) {
            this.command = command;
        }
    }
}

