/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.Serializable;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.runtime.checkpoint.SubtaskStateStats;
import org.apache.flink.runtime.checkpoint.TaskStateStats;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TaskStateStatsTest {
    private final ThreadLocalRandom rand = ThreadLocalRandom.current();

    TaskStateStatsTest() {
    }

    @Test
    void testHandInSubtasks() throws Exception {
        this.test(false);
    }

    @Test
    void testIsJavaSerializable() throws Exception {
        this.test(true);
    }

    private void test(boolean serialize) throws Exception {
        JobVertexID jobVertexId = new JobVertexID();
        SubtaskStateStats[] subtasks = new SubtaskStateStats[7];
        TaskStateStats taskStats = new TaskStateStats(jobVertexId, subtasks.length);
        Assertions.assertThat((Comparable)taskStats.getJobVertexId()).isEqualTo((Object)jobVertexId);
        Assertions.assertThat((int)taskStats.getNumberOfSubtasks()).isEqualTo(subtasks.length);
        Assertions.assertThat((int)taskStats.getNumberOfAcknowledgedSubtasks()).isZero();
        Assertions.assertThat((Object)taskStats.getLatestAcknowledgedSubtaskStats()).isNull();
        Assertions.assertThat((long)taskStats.getLatestAckTimestamp()).isEqualTo(-1L);
        Assertions.assertThat((Object[])taskStats.getSubtaskStats()).isEqualTo((Object)subtasks);
        long stateSize = 0L;
        long processedData = 0L;
        long persistedData = 0L;
        for (int i = 0; i < subtasks.length; ++i) {
            subtasks[i] = new SubtaskStateStats(i, (long)this.rand.nextInt(128), (long)this.rand.nextInt(128), (long)this.rand.nextInt(128), (long)this.rand.nextInt(128), (long)this.rand.nextInt(128), (long)this.rand.nextInt(128), (long)this.rand.nextInt(128), (long)this.rand.nextInt(128), (long)this.rand.nextInt(128), false, true);
            stateSize += subtasks[i].getStateSize();
            processedData += subtasks[i].getProcessedData();
            persistedData += subtasks[i].getPersistedData();
            Assertions.assertThat((boolean)taskStats.reportSubtaskStats(subtasks[i])).isTrue();
            Assertions.assertThat((int)taskStats.getNumberOfAcknowledgedSubtasks()).isEqualTo(i + 1);
            Assertions.assertThat((Object)taskStats.getLatestAcknowledgedSubtaskStats()).isEqualTo((Object)subtasks[i]);
            Assertions.assertThat((long)taskStats.getLatestAckTimestamp()).isEqualTo(subtasks[i].getAckTimestamp());
            int duration = this.rand.nextInt(128);
            Assertions.assertThat((long)taskStats.getEndToEndDuration(subtasks[i].getAckTimestamp() - (long)duration)).isEqualTo((long)duration);
            Assertions.assertThat((long)taskStats.getStateSize()).isEqualTo(stateSize);
            Assertions.assertThat((long)taskStats.getProcessedDataStats()).isEqualTo(processedData);
            Assertions.assertThat((long)taskStats.getPersistedDataStats()).isEqualTo(persistedData);
        }
        Assertions.assertThat((boolean)taskStats.reportSubtaskStats(new SubtaskStateStats(0, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, false, true))).isFalse();
        taskStats = serialize ? (TaskStateStats)CommonTestUtils.createCopySerializable((Serializable)taskStats) : taskStats;
        Assertions.assertThat((long)taskStats.getStateSize()).isEqualTo(stateSize);
        TaskStateStats.TaskStateStatsSummary summary = taskStats.getSummaryStats();
        Assertions.assertThat((long)summary.getStateSizeStats().getCount()).isEqualTo((long)subtasks.length);
        Assertions.assertThat((long)summary.getAckTimestampStats().getCount()).isEqualTo((long)subtasks.length);
        Assertions.assertThat((long)summary.getSyncCheckpointDurationStats().getCount()).isEqualTo((long)subtasks.length);
        Assertions.assertThat((long)summary.getAsyncCheckpointDurationStats().getCount()).isEqualTo((long)subtasks.length);
        Assertions.assertThat((long)summary.getAlignmentDurationStats().getCount()).isEqualTo((long)subtasks.length);
        Assertions.assertThat((long)summary.getProcessedDataStats().getCount()).isEqualTo((long)subtasks.length);
        Assertions.assertThat((long)summary.getPersistedDataStats().getCount()).isEqualTo((long)subtasks.length);
    }
}

