/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.flink.api.common.JobID;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.runtime.checkpoint.CheckpointRetentionPolicy;
import org.apache.flink.runtime.checkpoint.MasterTriggerRestoreHook;
import org.apache.flink.runtime.executiongraph.DefaultExecutionGraph;
import org.apache.flink.runtime.executiongraph.TestingDefaultExecutionGraphBuilder;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobGraphBuilder;
import org.apache.flink.runtime.jobgraph.tasks.CheckpointCoordinatorConfiguration;
import org.apache.flink.runtime.jobgraph.tasks.JobCheckpointingSettings;
import org.apache.flink.runtime.state.AbstractKeyedStateBackend;
import org.apache.flink.runtime.state.CheckpointStorage;
import org.apache.flink.runtime.state.CheckpointStorageAccess;
import org.apache.flink.runtime.state.CompletedCheckpointStorageLocation;
import org.apache.flink.runtime.state.OperatorStateBackend;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.testutils.ClassLoaderUtils;
import org.apache.flink.testutils.TestingUtils;
import org.apache.flink.testutils.executor.TestExecutorExtension;
import org.apache.flink.util.SerializedValue;
import org.apache.flink.util.TernaryBoolean;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.mockito.Mockito;

class CheckpointSettingsSerializableTest {
    @RegisterExtension
    private static final TestExecutorExtension<ScheduledExecutorService> EXECUTOR_EXTENSION = TestingUtils.defaultExecutorExtension();

    CheckpointSettingsSerializableTest() {
    }

    @Test
    void testDeserializationOfUserCodeWithUserClassLoader() throws Exception {
        ClassLoaderUtils.ObjectAndClassLoader outsideClassLoading = ClassLoaderUtils.createSerializableObjectFromNewClassLoader();
        ClassLoader classLoader = outsideClassLoading.getClassLoader();
        Serializable outOfClassPath = (Serializable)outsideClassLoading.getObject();
        MasterTriggerRestoreHook.Factory[] hooks = new MasterTriggerRestoreHook.Factory[]{new TestFactory(outOfClassPath)};
        SerializedValue serHooks = new SerializedValue((Object)hooks);
        JobCheckpointingSettings checkpointingSettings = new JobCheckpointingSettings(new CheckpointCoordinatorConfiguration(1000L, 10000L, 0L, 1, CheckpointRetentionPolicy.NEVER_RETAIN_AFTER_TERMINATION, true, false, 0, 0L), new SerializedValue((Object)new CustomStateBackend(outOfClassPath)), TernaryBoolean.UNDEFINED, new SerializedValue((Object)new CustomCheckpointStorage(outOfClassPath)), serHooks);
        JobGraph jobGraph = JobGraphBuilder.newStreamingJobGraphBuilder().setJobCheckpointingSettings(checkpointingSettings).build();
        JobGraph copy = (JobGraph)CommonTestUtils.createCopySerializable((Serializable)jobGraph);
        DefaultExecutionGraph eg = TestingDefaultExecutionGraphBuilder.newBuilder().setJobGraph(copy).setUserClassLoader(classLoader).build((ScheduledExecutorService)EXECUTOR_EXTENSION.getExecutor());
        Assertions.assertThat((int)eg.getCheckpointCoordinator().getNumberOfRegisteredMasterHooks()).isOne();
        Assertions.assertThat((Object)jobGraph.getCheckpointingSettings().getDefaultStateBackend().deserializeValue(classLoader)).isInstanceOf(CustomStateBackend.class);
    }

    private static final class CustomCheckpointStorage
    implements CheckpointStorage {
        private static final long serialVersionUID = -6107964383429395816L;
        private Serializable customOption;

        public CustomCheckpointStorage(Serializable customOption) {
            this.customOption = customOption;
        }

        public CompletedCheckpointStorageLocation resolveCheckpoint(String pointer) {
            throw new UnsupportedOperationException();
        }

        public CheckpointStorageAccess createCheckpointStorage(JobID jobId) throws IOException {
            return (CheckpointStorageAccess)Mockito.mock(CheckpointStorageAccess.class);
        }
    }

    private static final class CustomStateBackend
    implements StateBackend {
        private static final long serialVersionUID = -6107964383429395816L;
        private Serializable customOption;

        public CustomStateBackend(Serializable customOption) {
            this.customOption = customOption;
        }

        public <K> AbstractKeyedStateBackend<K> createKeyedStateBackend(StateBackend.KeyedStateBackendParameters<K> parameters) {
            throw new UnsupportedOperationException();
        }

        public OperatorStateBackend createOperatorStateBackend(StateBackend.OperatorStateBackendParameters parameters) {
            throw new UnsupportedOperationException();
        }
    }

    private static final class TestFactory
    implements MasterTriggerRestoreHook.Factory {
        private static final long serialVersionUID = -612969579110202607L;
        private final Serializable payload;

        TestFactory(Serializable payload) {
            this.payload = payload;
        }

        public <V> MasterTriggerRestoreHook<V> create() {
            MasterTriggerRestoreHook hook = (MasterTriggerRestoreHook)Mockito.mock(MasterTriggerRestoreHook.class);
            Mockito.when((Object)hook.getIdentifier()).thenReturn((Object)"id");
            return hook;
        }
    }
}

