/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor;

import java.net.InetAddress;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.NettyShuffleEnvironmentOptions;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.configuration.description.HtmlFormatter;
import org.apache.flink.runtime.taskmanager.NettyShuffleEnvironmentConfiguration;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class NettyShuffleEnvironmentConfigurationTest {
    private static final MemorySize MEM_SIZE_PARAM = new MemorySize(0x8000000L);

    NettyShuffleEnvironmentConfigurationTest() {
    }

    @Test
    void testNetworkBufferNumberCalculation() {
        Configuration config = new Configuration();
        config.set(TaskManagerOptions.MEMORY_SEGMENT_SIZE, (Object)MemorySize.parse((String)"1m"));
        int numNetworkBuffers = NettyShuffleEnvironmentConfiguration.fromConfiguration((Configuration)config, (MemorySize)MEM_SIZE_PARAM, (boolean)false, (InetAddress)InetAddress.getLoopbackAddress()).numNetworkBuffers();
        Assertions.assertThat((int)numNetworkBuffers).isEqualTo(128);
    }

    @Test
    void testNetworkRequestBackoffAndBuffers() {
        Configuration config = new Configuration();
        config.set(NettyShuffleEnvironmentOptions.NETWORK_REQUEST_BACKOFF_INITIAL, (Object)100);
        config.set(NettyShuffleEnvironmentOptions.NETWORK_REQUEST_BACKOFF_MAX, (Object)200);
        config.set(NettyShuffleEnvironmentOptions.NETWORK_BUFFERS_PER_CHANNEL, (Object)10);
        config.set(NettyShuffleEnvironmentOptions.NETWORK_EXTRA_BUFFERS_PER_GATE, (Object)100);
        NettyShuffleEnvironmentConfiguration networkConfig = NettyShuffleEnvironmentConfiguration.fromConfiguration((Configuration)config, (MemorySize)MEM_SIZE_PARAM, (boolean)true, (InetAddress)InetAddress.getLoopbackAddress());
        Assertions.assertThat((int)networkConfig.partitionRequestInitialBackoff()).isEqualTo(100);
        Assertions.assertThat((int)networkConfig.partitionRequestMaxBackoff()).isEqualTo(200);
        Assertions.assertThat((int)networkConfig.networkBuffersPerChannel()).isEqualTo(10);
        Assertions.assertThat((int)networkConfig.floatingNetworkBuffersPerGate()).isEqualTo(100);
    }

    @Test
    void testSortMergeShuffleConfigOptionsCorrelation() {
        HtmlFormatter formatter = new HtmlFormatter();
        ConfigOption configOption = NettyShuffleEnvironmentOptions.NETWORK_SORT_SHUFFLE_MIN_PARALLELISM;
        String description = formatter.format(configOption.description());
        String configKey = NettyShuffleEnvironmentConfigurationTest.getConfigKey(NettyShuffleEnvironmentOptions.NETWORK_SORT_SHUFFLE_MIN_BUFFERS);
        Assertions.assertThat((String)description).contains(new CharSequence[]{configKey});
        configKey = NettyShuffleEnvironmentConfigurationTest.getConfigKey(TaskManagerOptions.NETWORK_BATCH_SHUFFLE_READ_MEMORY);
        Assertions.assertThat((String)description).contains(new CharSequence[]{configKey});
        Assertions.assertThat((Boolean)((Boolean)NettyShuffleEnvironmentOptions.BATCH_SHUFFLE_COMPRESSION_ENABLED.defaultValue())).isTrue();
    }

    private static String getConfigKey(ConfigOption<?> configOption) {
        return "'" + configOption.key() + "'";
    }
}

