/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.cluster;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.io.FileUtils;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.HandlerRequestException;
import org.apache.flink.runtime.rest.handler.cluster.JobManagerCustomLogHandler;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.runtime.rest.messages.UntypedResponseMessageHeaders;
import org.apache.flink.runtime.rest.messages.cluster.FileMessageParameters;
import org.apache.flink.runtime.rest.messages.cluster.JobManagerCustomLogHeaders;
import org.apache.flink.runtime.webmonitor.TestingDispatcherGateway;
import org.apache.flink.testutils.TestingUtils;
import org.assertj.core.api.AbstractFileAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class JobManagerCustomLogHandlerTest {
    private static final String FORBIDDEN_FILENAME = "forbidden";
    private static final String VALID_LOG_FILENAME = "valid.log";
    private static final String VALID_LOG_CONTENT = "logged content";
    @TempDir
    private Path temporaryFolder;
    private File logRoot;
    private JobManagerCustomLogHandler testInstance;

    JobManagerCustomLogHandlerTest() {
    }

    @BeforeEach
    void setUp() throws IOException {
        this.initializeFolderStructure();
        TestingDispatcherGateway dispatcherGateway = TestingDispatcherGateway.newBuilder().build();
        this.testInstance = new JobManagerCustomLogHandler(() -> CompletableFuture.completedFuture(dispatcherGateway), TestingUtils.TIMEOUT, Collections.emptyMap(), (UntypedResponseMessageHeaders)JobManagerCustomLogHeaders.getInstance(), this.logRoot);
    }

    private void initializeFolderStructure() throws IOException {
        File root = this.temporaryFolder.toFile();
        this.logRoot = new File(root, "logs");
        Assertions.assertThat((boolean)this.logRoot.mkdir()).isTrue();
        JobManagerCustomLogHandlerTest.createFile(new File(root, FORBIDDEN_FILENAME), "forbidden content");
        JobManagerCustomLogHandlerTest.createFile(new File(this.logRoot, VALID_LOG_FILENAME), VALID_LOG_CONTENT);
    }

    private static void createFile(File file, String content) throws IOException {
        FileUtils.writeStringToFile((File)file, (String)content, (Charset)StandardCharsets.UTF_8);
    }

    private static HandlerRequest<EmptyRequestBody> createHandlerRequest(String path) throws HandlerRequestException {
        FileMessageParameters messageParameters = new FileMessageParameters();
        HashMap<String, String> pathParameters = new HashMap<String, String>();
        pathParameters.put(messageParameters.logFileNamePathParameter.getKey(), path);
        return HandlerRequest.resolveParametersAndCreate((RequestBody)EmptyRequestBody.getInstance(), (MessageParameters)messageParameters, pathParameters, Collections.emptyMap(), Collections.emptyList());
    }

    @Test
    void testGetJobManagerCustomLogsValidFilename() throws Exception {
        File actualFile = this.testInstance.getFile(JobManagerCustomLogHandlerTest.createHandlerRequest(VALID_LOG_FILENAME));
        Assertions.assertThat((File)actualFile).isNotNull();
        String actualContent = String.join((CharSequence)"", Files.readAllLines(actualFile.toPath()));
        Assertions.assertThat((String)actualContent).isEqualTo(VALID_LOG_CONTENT);
    }

    @Test
    void testGetJobManagerCustomLogsValidFilenameWithPath() throws Exception {
        File actualFile = this.testInstance.getFile(JobManagerCustomLogHandlerTest.createHandlerRequest(String.format("foobar/%s", VALID_LOG_FILENAME)));
        Assertions.assertThat((File)actualFile).isNotNull();
        String actualContent = String.join((CharSequence)"", Files.readAllLines(actualFile.toPath()));
        Assertions.assertThat((String)actualContent).isEqualTo(VALID_LOG_CONTENT);
    }

    @Test
    void testGetJobManagerCustomLogsValidFilenameWithInvalidPath() throws Exception {
        File actualFile = this.testInstance.getFile(JobManagerCustomLogHandlerTest.createHandlerRequest(String.format("../%s", VALID_LOG_FILENAME)));
        Assertions.assertThat((File)actualFile).isNotNull();
        String actualContent = String.join((CharSequence)"", Files.readAllLines(actualFile.toPath()));
        Assertions.assertThat((String)actualContent).isEqualTo(VALID_LOG_CONTENT);
    }

    @Test
    void testGetJobManagerCustomLogsNotExistingFile() throws Exception {
        File actualFile = this.testInstance.getFile(JobManagerCustomLogHandlerTest.createHandlerRequest("not-existing"));
        ((AbstractFileAssert)Assertions.assertThat((File)actualFile).isNotNull()).doesNotExist();
    }

    @Test
    void testGetJobManagerCustomLogsExistingButForbiddenFile() throws Exception {
        File actualFile = this.testInstance.getFile(JobManagerCustomLogHandlerTest.createHandlerRequest(String.format("../%s", FORBIDDEN_FILENAME)));
        ((AbstractFileAssert)Assertions.assertThat((File)actualFile).isNotNull()).doesNotExist();
    }

    @Test
    void testGetJobManagerCustomLogsValidFilenameWithLongInvalidPath() throws Exception {
        File actualFile = this.testInstance.getFile(JobManagerCustomLogHandlerTest.createHandlerRequest(String.format("foobar/../../%s", VALID_LOG_FILENAME)));
        Assertions.assertThat((File)actualFile).isNotNull();
        String actualContent = String.join((CharSequence)"", Files.readAllLines(actualFile.toPath()));
        Assertions.assertThat((String)actualContent).isEqualTo(VALID_LOG_CONTENT);
    }
}

