/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest;

import java.time.Duration;
import javax.annotation.Nullable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.configuration.SecurityOptions;
import org.apache.flink.runtime.io.network.netty.SSLHandlerFactory;
import org.apache.flink.runtime.net.SSLUtils;
import org.apache.flink.util.ConfigurationException;
import org.apache.flink.util.Preconditions;

public final class RestClientConfiguration {
    @Nullable
    private final SSLHandlerFactory sslHandlerFactory;
    private final long connectionTimeout;
    private final long idlenessTimeout;
    private final int maxContentLength;

    private RestClientConfiguration(@Nullable SSLHandlerFactory sslHandlerFactory, long connectionTimeout, long idlenessTimeout, int maxContentLength) {
        Preconditions.checkArgument((maxContentLength > 0 ? 1 : 0) != 0, (String)"maxContentLength must be positive, was: %s", (Object[])new Object[]{maxContentLength});
        this.sslHandlerFactory = sslHandlerFactory;
        this.connectionTimeout = connectionTimeout;
        this.idlenessTimeout = idlenessTimeout;
        this.maxContentLength = maxContentLength;
    }

    @Nullable
    public SSLHandlerFactory getSslHandlerFactory() {
        return this.sslHandlerFactory;
    }

    public long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public long getIdlenessTimeout() {
        return this.idlenessTimeout;
    }

    public int getMaxContentLength() {
        return this.maxContentLength;
    }

    public static RestClientConfiguration fromConfiguration(Configuration config) throws ConfigurationException {
        SSLHandlerFactory sslHandlerFactory;
        Preconditions.checkNotNull((Object)config);
        if (SecurityOptions.isRestSSLEnabled((Configuration)config)) {
            try {
                sslHandlerFactory = SSLUtils.createRestClientSSLEngineFactory(config);
            }
            catch (Exception e) {
                throw new ConfigurationException("Failed to initialize SSLContext for the REST client", (Throwable)e);
            }
        } else {
            sslHandlerFactory = null;
        }
        long connectionTimeout = ((Duration)config.get(RestOptions.CONNECTION_TIMEOUT)).toMillis();
        long idlenessTimeout = ((Duration)config.get(RestOptions.IDLENESS_TIMEOUT)).toMillis();
        int maxContentLength = (Integer)config.get(RestOptions.CLIENT_MAX_CONTENT_LENGTH);
        return new RestClientConfiguration(sslHandlerFactory, connectionTimeout, idlenessTimeout, maxContentLength);
    }
}

