/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestingFatalErrorHandler
implements FatalErrorHandler {
    private static final Logger LOG = LoggerFactory.getLogger(TestingFatalErrorHandler.class);
    private CompletableFuture<Throwable> errorFuture = new CompletableFuture();

    public synchronized void rethrowError() throws TestingException {
        Throwable throwable = this.getException();
        if (throwable != null) {
            throw new TestingException(throwable);
        }
    }

    public synchronized boolean hasExceptionOccurred() {
        return this.errorFuture.isDone();
    }

    @Nullable
    public synchronized Throwable getException() {
        if (this.errorFuture.isDone()) {
            Throwable throwable;
            try {
                throwable = this.errorFuture.get();
            }
            catch (InterruptedException ie) {
                ExceptionUtils.checkInterrupted((Throwable)ie);
                throw new FlinkRuntimeException("This should never happen since the future was completed.");
            }
            catch (ExecutionException e) {
                throwable = ExceptionUtils.stripExecutionException((Throwable)e);
            }
            return throwable;
        }
        return null;
    }

    public synchronized CompletableFuture<Throwable> getErrorFuture() {
        return this.errorFuture;
    }

    public synchronized void clearError() {
        this.errorFuture = new CompletableFuture();
    }

    public synchronized void onFatalError(@Nonnull Throwable exception) {
        LOG.error("OnFatalError:", exception);
        if (!this.errorFuture.complete(exception)) {
            Throwable throwable = this.getException();
            Preconditions.checkNotNull((Object)throwable);
            throwable.addSuppressed(exception);
        }
    }

    private static final class TestingException
    extends Exception {
        private static final long serialVersionUID = -4648195335470914498L;

        public TestingException(String message) {
            super(message);
        }

        public TestingException(String message, Throwable cause) {
            super(message, cause);
        }

        public TestingException(Throwable cause) {
            super(cause);
        }
    }
}

