/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.testutils;

import java.time.Duration;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.RpcOptions;
import org.apache.flink.configuration.UnmodifiableConfiguration;
import org.apache.flink.runtime.minicluster.MiniCluster;
import org.apache.flink.runtime.minicluster.RpcServiceSharing;
import org.apache.flink.util.Preconditions;

public class MiniClusterResourceConfiguration {
    private final UnmodifiableConfiguration configuration;
    private final int numberTaskManagers;
    private final int numberSlotsPerTaskManager;
    private final Time shutdownTimeout;
    private final RpcServiceSharing rpcServiceSharing;
    private final MiniCluster.HaServices haServices;

    protected MiniClusterResourceConfiguration(Configuration configuration, int numberTaskManagers, int numberSlotsPerTaskManager, Time shutdownTimeout, RpcServiceSharing rpcServiceSharing, MiniCluster.HaServices haServices) {
        this.configuration = new UnmodifiableConfiguration((Configuration)Preconditions.checkNotNull((Object)configuration));
        this.numberTaskManagers = numberTaskManagers;
        this.numberSlotsPerTaskManager = numberSlotsPerTaskManager;
        this.shutdownTimeout = (Time)Preconditions.checkNotNull((Object)shutdownTimeout);
        this.rpcServiceSharing = (RpcServiceSharing)Preconditions.checkNotNull((Object)rpcServiceSharing);
        this.haServices = haServices;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public int getNumberTaskManagers() {
        return this.numberTaskManagers;
    }

    public int getNumberSlotsPerTaskManager() {
        return this.numberSlotsPerTaskManager;
    }

    public Time getShutdownTimeout() {
        return this.shutdownTimeout;
    }

    public RpcServiceSharing getRpcServiceSharing() {
        return this.rpcServiceSharing;
    }

    public MiniCluster.HaServices getHaServices() {
        return this.haServices;
    }

    public static final class Builder {
        private Configuration configuration = new Configuration();
        private int numberTaskManagers = 1;
        private int numberSlotsPerTaskManager = 1;
        private Time shutdownTimeout = Time.fromDuration((Duration)((Duration)this.configuration.get(RpcOptions.ASK_TIMEOUT_DURATION)));
        private RpcServiceSharing rpcServiceSharing = RpcServiceSharing.SHARED;
        private MiniCluster.HaServices haServices = MiniCluster.HaServices.CONFIGURED;

        public Builder setConfiguration(Configuration configuration) {
            this.configuration = configuration;
            return this;
        }

        public Builder setNumberTaskManagers(int numberTaskManagers) {
            this.numberTaskManagers = numberTaskManagers;
            return this;
        }

        public Builder setNumberSlotsPerTaskManager(int numberSlotsPerTaskManager) {
            this.numberSlotsPerTaskManager = numberSlotsPerTaskManager;
            return this;
        }

        public Builder setShutdownTimeout(Time shutdownTimeout) {
            this.shutdownTimeout = shutdownTimeout;
            return this;
        }

        public Builder setRpcServiceSharing(RpcServiceSharing rpcServiceSharing) {
            this.rpcServiceSharing = rpcServiceSharing;
            return this;
        }

        public Builder withHaLeadershipControl() {
            this.haServices = MiniCluster.HaServices.WITH_LEADERSHIP_CONTROL;
            return this;
        }

        public MiniClusterResourceConfiguration build() {
            return new MiniClusterResourceConfiguration(this.configuration, this.numberTaskManagers, this.numberSlotsPerTaskManager, this.shutdownTimeout, this.rpcServiceSharing, this.haServices);
        }
    }
}

