/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.v2;

import java.time.Duration;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.serialization.SerializerConfigImpl;
import org.apache.flink.api.common.state.StateTtlConfig;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.runtime.state.v2.StateDescriptor;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class StateDescriptorTest {
    StateDescriptorTest() {
    }

    @Test
    void testSerializerDuplication() {
        TestStateDescriptor descr = new TestStateDescriptor("foobar", new GenericTypeInfo(String.class));
        TypeSerializer serializerA = descr.getSerializer();
        TypeSerializer serializerB = descr.getSerializer();
        Assertions.assertThat((Object)serializerB).isNotSameAs((Object)serializerA);
    }

    @Test
    void testHashCodeAndEquals() throws Exception {
        String name = "testName";
        TestStateDescriptor original = new TestStateDescriptor("testName", BasicTypeInfo.STRING_TYPE_INFO);
        TestStateDescriptor same = new TestStateDescriptor("testName", BasicTypeInfo.STRING_TYPE_INFO);
        TestStateDescriptor sameBySerializer = new TestStateDescriptor("testName", BasicTypeInfo.STRING_TYPE_INFO);
        Assertions.assertThat(same).hasSameHashCodeAs(original);
        Assertions.assertThat(sameBySerializer).hasSameHashCodeAs(original);
        Assertions.assertThat(same).isEqualTo(original);
        Assertions.assertThat(sameBySerializer).isEqualTo(original);
        TestStateDescriptor clone = (TestStateDescriptor)((Object)CommonTestUtils.createCopySerializable(original));
        Assertions.assertThat((Object)((Object)clone)).isEqualTo(original);
    }

    @Test
    void testEqualsSameNameAndTypeDifferentClass() {
        String name = "test name";
        TestStateDescriptor descr1 = new TestStateDescriptor("test name", BasicTypeInfo.STRING_TYPE_INFO);
        OtherTestStateDescriptor descr2 = new OtherTestStateDescriptor("test name", BasicTypeInfo.STRING_TYPE_INFO);
        Assertions.assertThat(descr2).isNotEqualTo(descr1);
    }

    @Test
    void testStateTTlConfig() {
        TestStateDescriptor stateDescriptor = new TestStateDescriptor("test-state", BasicTypeInfo.INT_TYPE_INFO);
        stateDescriptor.enableTimeToLive(StateTtlConfig.newBuilder((Duration)Duration.ofMinutes(60L)).build());
        Assertions.assertThat((boolean)stateDescriptor.getTtlConfig().isEnabled()).isTrue();
        stateDescriptor.enableTimeToLive(StateTtlConfig.DISABLED);
        Assertions.assertThat((boolean)stateDescriptor.getTtlConfig().isEnabled()).isFalse();
    }

    private static class OtherTestStateDescriptor<T>
    extends StateDescriptor<T> {
        private static final long serialVersionUID = 1L;

        OtherTestStateDescriptor(String name, TypeInformation<T> typeInfo) {
            super(name, typeInfo, (SerializerConfig)new SerializerConfigImpl());
        }

        public StateDescriptor.Type getType() {
            return StateDescriptor.Type.VALUE;
        }
    }

    private static class TestStateDescriptor<T>
    extends StateDescriptor<T> {
        private static final long serialVersionUID = 1L;

        TestStateDescriptor(String name, TypeInformation<T> typeInfo) {
            super(name, typeInfo, (SerializerConfig)new SerializerConfigImpl());
        }

        public StateDescriptor.Type getType() {
            return StateDescriptor.Type.VALUE;
        }
    }
}

