/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.clusterframework.types.SlotProfile;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.scheduler.ExecutionSlotSharingGroup;
import org.apache.flink.runtime.scheduler.MergingSharedSlotProfileRetrieverFactory;
import org.apache.flink.runtime.scheduler.SharedSlotProfileRetriever;
import org.apache.flink.runtime.scheduler.SyncPreferredLocationsRetriever;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.FlinkRuntimeException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class MergingSharedSlotProfileRetrieverTest {
    private static final SyncPreferredLocationsRetriever EMPTY_PREFERRED_LOCATIONS_RETRIEVER = (executionVertexId, producersToIgnore) -> Collections.emptyList();

    MergingSharedSlotProfileRetrieverTest() {
    }

    @Test
    void testGetEmptySlotProfile() {
        SharedSlotProfileRetriever sharedSlotProfileRetriever = new MergingSharedSlotProfileRetrieverFactory(EMPTY_PREFERRED_LOCATIONS_RETRIEVER, executionVertexID -> Optional.of(new AllocationID()), () -> Collections.emptySet()).createFromBulk(Collections.emptySet());
        SlotProfile slotProfile = sharedSlotProfileRetriever.getSlotProfile(new ExecutionSlotSharingGroup(), ResourceProfile.ZERO);
        Assertions.assertThat((Object)slotProfile.getTaskResourceProfile()).isEqualTo((Object)ResourceProfile.ZERO);
        Assertions.assertThat((Object)slotProfile.getPhysicalSlotResourceProfile()).isEqualTo((Object)ResourceProfile.ZERO);
        Assertions.assertThat((Collection)slotProfile.getPreferredLocations()).isEmpty();
        Assertions.assertThat((Collection)slotProfile.getPreferredAllocations()).isEmpty();
        Assertions.assertThat((Collection)slotProfile.getReservedAllocations()).isEmpty();
    }

    @Test
    void testResourceProfileOfSlotProfile() {
        ResourceProfile resourceProfile = ResourceProfile.newBuilder().setCpuCores(1.0).setTaskHeapMemory(MemorySize.ofMebiBytes((long)1L)).build();
        SlotProfile slotProfile = MergingSharedSlotProfileRetrieverTest.getSlotProfile(resourceProfile, Collections.nCopies(3, new AllocationID()), 2);
        Assertions.assertThat((Object)slotProfile.getTaskResourceProfile()).isEqualTo((Object)resourceProfile);
        Assertions.assertThat((Object)slotProfile.getPhysicalSlotResourceProfile()).isEqualTo((Object)resourceProfile);
    }

    @Test
    void testPreferredLocationsOfSlotProfile() {
        List<ExecutionVertexID> executions = IntStream.range(0, 3).mapToObj(i -> new ExecutionVertexID(new JobVertexID(), 0)).collect(Collectors.toList());
        List allLocations = executions.stream().map(e -> MergingSharedSlotProfileRetrieverTest.createTaskManagerLocation()).collect(Collectors.toList());
        HashMap locations = new HashMap();
        locations.put(executions.get(0), Arrays.asList((TaskManagerLocation)allLocations.get(0), (TaskManagerLocation)allLocations.get(1)));
        locations.put(executions.get(1), Arrays.asList((TaskManagerLocation)allLocations.get(1), (TaskManagerLocation)allLocations.get(2)));
        List<AllocationID> prevAllocationIds = Collections.nCopies(3, new AllocationID());
        SlotProfile slotProfile = MergingSharedSlotProfileRetrieverTest.getSlotProfile((executionVertexId, producersToIgnore) -> {
            Assertions.assertThat((Collection)producersToIgnore).containsAll((Iterable)executions);
            return (Collection)locations.get(executionVertexId);
        }, executions, ResourceProfile.ZERO, prevAllocationIds, prevAllocationIds, 2);
        Assertions.assertThat((long)slotProfile.getPreferredLocations().stream().filter(arg_0 -> ((TaskManagerLocation)((TaskManagerLocation)allLocations.get(0))).equals(arg_0)).count()).isOne();
        Assertions.assertThat((long)slotProfile.getPreferredLocations().stream().filter(arg_0 -> ((TaskManagerLocation)((TaskManagerLocation)allLocations.get(1))).equals(arg_0)).count()).isEqualTo(2L);
        Assertions.assertThat((long)slotProfile.getPreferredLocations().stream().filter(arg_0 -> ((TaskManagerLocation)((TaskManagerLocation)allLocations.get(2))).equals(arg_0)).count()).isOne();
    }

    @Test
    void testPreferredAllocationsOfSlotProfile() {
        AllocationID prevAllocationID1 = new AllocationID();
        AllocationID prevAllocationID2 = new AllocationID();
        List<AllocationID> prevAllocationIDs = Arrays.asList(prevAllocationID1, prevAllocationID2, new AllocationID());
        SlotProfile slotProfile = MergingSharedSlotProfileRetrieverTest.getSlotProfile(ResourceProfile.ZERO, prevAllocationIDs, 2);
        Assertions.assertThat((Collection)slotProfile.getPreferredAllocations()).contains((Object[])new AllocationID[]{prevAllocationID1, prevAllocationID2});
    }

    @Test
    void testReservedAllocationsOfSlotProfile() {
        List<AllocationID> reservedAllocationIds = Arrays.asList(new AllocationID(), new AllocationID(), new AllocationID());
        SlotProfile slotProfile = MergingSharedSlotProfileRetrieverTest.getSlotProfile(EMPTY_PREFERRED_LOCATIONS_RETRIEVER, Collections.emptyList(), ResourceProfile.ZERO, Collections.emptyList(), reservedAllocationIds, 0);
        Assertions.assertThat((Collection)slotProfile.getReservedAllocations()).containsAll(reservedAllocationIds);
    }

    private static SlotProfile getSlotProfile(ResourceProfile resourceProfile, List<AllocationID> prevAllocationIDs, int executionSlotSharingGroupSize) {
        List<ExecutionVertexID> executions = prevAllocationIDs.stream().map(stub -> new ExecutionVertexID(new JobVertexID(), 0)).collect(Collectors.toList());
        return MergingSharedSlotProfileRetrieverTest.getSlotProfile(EMPTY_PREFERRED_LOCATIONS_RETRIEVER, executions, resourceProfile, prevAllocationIDs, prevAllocationIDs, executionSlotSharingGroupSize);
    }

    private static SlotProfile getSlotProfile(SyncPreferredLocationsRetriever preferredLocationsRetriever, List<ExecutionVertexID> executions, ResourceProfile resourceProfile, List<AllocationID> prevAllocationIDs, Collection<AllocationID> reservedAllocationIds, int executionSlotSharingGroupSize) {
        SharedSlotProfileRetriever sharedSlotProfileRetriever = new MergingSharedSlotProfileRetrieverFactory(preferredLocationsRetriever, executionVertexID -> Optional.ofNullable(prevAllocationIDs.get(executions.indexOf(executionVertexID))), () -> new HashSet(reservedAllocationIds)).createFromBulk(new HashSet<ExecutionVertexID>(executions));
        ExecutionSlotSharingGroup executionSlotSharingGroup = new ExecutionSlotSharingGroup();
        executions.stream().limit(executionSlotSharingGroupSize).forEach(arg_0 -> ((ExecutionSlotSharingGroup)executionSlotSharingGroup).addVertex(arg_0));
        return sharedSlotProfileRetriever.getSlotProfile(executionSlotSharingGroup, resourceProfile);
    }

    private static TaskManagerLocation createTaskManagerLocation() {
        try {
            return new TaskManagerLocation(ResourceID.generate(), InetAddress.getByAddress(new byte[]{1, 2, 3, 4}), 8888);
        }
        catch (UnknownHostException e) {
            throw new FlinkRuntimeException("unexpected", (Throwable)e);
        }
    }
}

