/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.jobgraph.JobType;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPool;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPoolUtils;
import org.apache.flink.runtime.scheduler.DefaultSchedulerComponents;
import org.apache.flink.runtime.scheduler.SlotSharingExecutionSlotAllocatorFactory;
import org.apache.flink.runtime.scheduler.strategy.PipelinedRegionSchedulingStrategy;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class DefaultSchedulerComponentsFactoryTest {
    DefaultSchedulerComponentsFactoryTest() {
    }

    @Test
    void testCreatingPipelinedSchedulingStrategyFactory() {
        DefaultSchedulerComponents components = DefaultSchedulerComponentsFactoryTest.createSchedulerComponents(new Configuration());
        Assertions.assertThat((Object)components.getSchedulingStrategyFactory()).isInstanceOf(PipelinedRegionSchedulingStrategy.Factory.class);
        Assertions.assertThat((Object)components.getAllocatorFactory()).isInstanceOf(SlotSharingExecutionSlotAllocatorFactory.class);
    }

    @Test
    void testCreatingPipelinedRegionSchedulingStrategyFactoryByDefault() {
        DefaultSchedulerComponents components = DefaultSchedulerComponentsFactoryTest.createSchedulerComponents(new Configuration());
        Assertions.assertThat((Object)components.getSchedulingStrategyFactory()).isInstanceOf(PipelinedRegionSchedulingStrategy.Factory.class);
    }

    @Test
    void testCreatingPipelinedRegionSchedulingStrategyFactoryWithApproximateLocalRecovery() {
        Configuration configuration = new Configuration();
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> DefaultSchedulerComponentsFactoryTest.createSchedulerComponents(configuration, true, JobType.STREAMING)).withFailMessage("expected failure", new Object[0])).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Approximate local recovery can not be used together with PipelinedRegionScheduler for now");
    }

    private static DefaultSchedulerComponents createSchedulerComponents(Configuration configuration) {
        return DefaultSchedulerComponentsFactoryTest.createSchedulerComponents(configuration, false, JobType.BATCH);
    }

    private static DefaultSchedulerComponents createSchedulerComponents(Configuration configuration, boolean iApproximateLocalRecoveryEnabled, JobType jobType) {
        return DefaultSchedulerComponents.createSchedulerComponents((JobType)jobType, (boolean)iApproximateLocalRecoveryEnabled, (Configuration)configuration, (SlotPool)SlotPoolUtils.createDeclarativeSlotPoolBridge(), (Time)Time.milliseconds((long)10L));
    }
}

