/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptive.scalingpolicy;

import java.util.Collections;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.scheduler.adaptive.allocator.VertexParallelism;
import org.apache.flink.runtime.scheduler.adaptive.scalingpolicy.EnforceMinimalIncreaseRescalingController;
import org.apache.flink.util.TestLoggerExtension;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={TestLoggerExtension.class})
public class EnforceMinimalIncreaseRescalingControllerTest {
    private static final Configuration TEST_CONFIG = new Configuration().set(JobManagerOptions.MIN_PARALLELISM_INCREASE, (Object)2);
    private static final JobVertexID jobVertexId = new JobVertexID();

    @Test
    void testScaleUp() {
        EnforceMinimalIncreaseRescalingController rescalingController = new EnforceMinimalIncreaseRescalingController(TEST_CONFIG);
        Assertions.assertThat((boolean)rescalingController.shouldRescale(EnforceMinimalIncreaseRescalingControllerTest.forParallelism(1), EnforceMinimalIncreaseRescalingControllerTest.forParallelism(4))).isTrue();
    }

    @Test
    void testNoScaleUp() {
        EnforceMinimalIncreaseRescalingController rescalingController = new EnforceMinimalIncreaseRescalingController(TEST_CONFIG);
        Assertions.assertThat((boolean)rescalingController.shouldRescale(EnforceMinimalIncreaseRescalingControllerTest.forParallelism(2), EnforceMinimalIncreaseRescalingControllerTest.forParallelism(3))).isFalse();
    }

    @Test
    void testAlwaysScaleDown() {
        EnforceMinimalIncreaseRescalingController rescalingController = new EnforceMinimalIncreaseRescalingController(TEST_CONFIG);
        Assertions.assertThat((boolean)rescalingController.shouldRescale(EnforceMinimalIncreaseRescalingControllerTest.forParallelism(2), EnforceMinimalIncreaseRescalingControllerTest.forParallelism(1))).isTrue();
    }

    @Test
    void testNoScaleOnSameParallelism() {
        EnforceMinimalIncreaseRescalingController rescalingController = new EnforceMinimalIncreaseRescalingController(TEST_CONFIG);
        Assertions.assertThat((boolean)rescalingController.shouldRescale(EnforceMinimalIncreaseRescalingControllerTest.forParallelism(2), EnforceMinimalIncreaseRescalingControllerTest.forParallelism(2))).isFalse();
    }

    private static VertexParallelism forParallelism(int parallelism) {
        return new VertexParallelism(Collections.singletonMap(jobVertexId, parallelism));
    }
}

