/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptive;

import java.util.function.Consumer;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionGraph;
import org.apache.flink.runtime.executiongraph.ErrorInfo;
import org.apache.flink.runtime.rest.handler.legacy.utils.ArchivedExecutionGraphBuilder;
import org.apache.flink.runtime.scheduler.adaptive.StateValidator;
import org.apache.flink.runtime.scheduler.adaptive.StateWithoutExecutionGraph;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

class MockStateWithoutExecutionGraphContext
implements StateWithoutExecutionGraph.Context,
AfterEachCallback {
    private final StateValidator<ArchivedExecutionGraph> finishedStateValidator = new StateValidator("Finished");
    private boolean hasStateTransition = false;

    MockStateWithoutExecutionGraphContext() {
    }

    public void setExpectFinished(Consumer<ArchivedExecutionGraph> asserter) {
        this.finishedStateValidator.expectInput(asserter);
    }

    public void goToFinished(ArchivedExecutionGraph archivedExecutionGraph) {
        this.finishedStateValidator.validateInput(archivedExecutionGraph);
        this.registerStateTransition();
    }

    public ArchivedExecutionGraph getArchivedExecutionGraph(JobStatus jobStatus, @Nullable Throwable cause) {
        return new ArchivedExecutionGraphBuilder().setState(jobStatus).setFailureCause(cause == null ? null : new ErrorInfo(cause, 1337L)).build();
    }

    public void afterEach(ExtensionContext extensionContext) throws Exception {
        this.finishedStateValidator.close();
    }

    public boolean hasStateTransition() {
        return this.hasStateTransition;
    }

    public void registerStateTransition() {
        this.hasStateTransition = true;
    }
}

