/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.flink.core.testutils.CustomExtension;
import org.apache.flink.core.testutils.EachCallbackWrapper;
import org.apache.flink.runtime.io.network.netty.NettyLeakDetectionExtension;
import org.apache.flink.runtime.rest.MultipartUploadExtension;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.runtime.rest.util.RestMapperUtils;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.testutils.junit.utils.TempDirUtils;
import org.apache.flink.util.FileUtils;
import org.apache.flink.util.function.BiConsumerWithException;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.api.io.TempDir;

class FileUploadHandlerITCase {
    @TempDir
    public Path tempDir;
    @RegisterExtension
    public final EachCallbackWrapper<MultipartUploadExtension> multipartUpdateExtensionWrapper = new EachCallbackWrapper((CustomExtension)new MultipartUploadExtension(() -> this.tempDir));
    private static final ObjectMapper OBJECT_MAPPER = RestMapperUtils.getStrictObjectMapper();
    @RegisterExtension
    public static final NettyLeakDetectionExtension LEAK_DETECTION = new NettyLeakDetectionExtension();

    FileUploadHandlerITCase() {
    }

    private Request buildMalformedRequest(String headerUrl) {
        MultipartBody.Builder builder = new MultipartBody.Builder();
        builder = this.addFilePart(builder);
        builder = builder.addPart(okhttp3.RequestBody.create((MediaType)MediaType.parse((String)"text/plain"), (String)"crash"));
        return this.finalizeRequest(builder, headerUrl);
    }

    private Request buildMixedRequestWithUnknownAttribute(String headerUrl) throws IOException {
        MultipartBody.Builder builder = new MultipartBody.Builder();
        builder = FileUploadHandlerITCase.addJsonPart(builder, new MultipartUploadExtension.TestRequestBody(), "hello");
        builder = this.addFilePart(builder);
        return this.finalizeRequest(builder, headerUrl);
    }

    private Request buildRequestWithCustomFilenames(String headerUrl, String filename1, String filename2) {
        MultipartBody.Builder builder = new MultipartBody.Builder();
        builder = FileUploadHandlerITCase.addFilePart(builder, ((MultipartUploadExtension)this.multipartUpdateExtensionWrapper.getCustomExtension()).file1, filename1);
        builder = FileUploadHandlerITCase.addFilePart(builder, ((MultipartUploadExtension)this.multipartUpdateExtensionWrapper.getCustomExtension()).file2, filename2);
        return this.finalizeRequest(builder, headerUrl);
    }

    private Request buildFileRequest(String headerUrl) {
        MultipartBody.Builder builder = new MultipartBody.Builder();
        builder = this.addFilePart(builder);
        return this.finalizeRequest(builder, headerUrl);
    }

    private Request buildJsonRequest(String headerUrl, MultipartUploadExtension.TestRequestBody json) throws IOException {
        MultipartBody.Builder builder = new MultipartBody.Builder();
        builder = FileUploadHandlerITCase.addJsonPart(builder, json, "request");
        return this.finalizeRequest(builder, headerUrl);
    }

    private Request buildMixedRequest(String headerUrl, MultipartUploadExtension.TestRequestBody json, File file) throws IOException {
        MultipartBody.Builder builder = new MultipartBody.Builder();
        builder = FileUploadHandlerITCase.addJsonPart(builder, json, "request");
        builder = FileUploadHandlerITCase.addFilePart(builder, file, file.getName());
        return this.finalizeRequest(builder, headerUrl);
    }

    private Request buildMixedRequest(String headerUrl, MultipartUploadExtension.TestRequestBody json) throws IOException {
        MultipartBody.Builder builder = new MultipartBody.Builder();
        builder = FileUploadHandlerITCase.addJsonPart(builder, json, "request");
        builder = this.addFilePart(builder);
        return this.finalizeRequest(builder, headerUrl);
    }

    private Request finalizeRequest(MultipartBody.Builder builder, String headerUrl) {
        MultipartBody multipartBody = builder.setType(MultipartBody.FORM).build();
        return new Request.Builder().url(((MultipartUploadExtension)this.multipartUpdateExtensionWrapper.getCustomExtension()).serverAddress + headerUrl).post((okhttp3.RequestBody)multipartBody).build();
    }

    private MultipartBody.Builder addFilePart(MultipartBody.Builder builder) {
        ((MultipartUploadExtension)this.multipartUpdateExtensionWrapper.getCustomExtension()).getFilesToUpload().forEach(f -> FileUploadHandlerITCase.addFilePart(builder, f, f.getName()));
        return builder;
    }

    private static MultipartBody.Builder addFilePart(MultipartBody.Builder builder, File file, String filename) {
        okhttp3.RequestBody filePayload = okhttp3.RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (File)file);
        builder = builder.addFormDataPart(file.getName(), filename, filePayload);
        return builder;
    }

    private static MultipartBody.Builder addJsonPart(MultipartBody.Builder builder, MultipartUploadExtension.TestRequestBody jsonRequestBody, String attribute) throws IOException {
        StringWriter sw = new StringWriter();
        OBJECT_MAPPER.writeValue((Writer)sw, (Object)jsonRequestBody);
        String jsonPayload = sw.toString();
        return builder.addFormDataPart(attribute, jsonPayload);
    }

    @Test
    void testUploadDirectoryRegeneration() throws Exception {
        OkHttpClient client = this.createOkHttpClientWithNoTimeouts();
        MultipartUploadExtension.MultipartFileHandler fileHandler = ((MultipartUploadExtension)this.multipartUpdateExtensionWrapper.getCustomExtension()).getFileHandler();
        FileUtils.deleteDirectory((File)((MultipartUploadExtension)this.multipartUpdateExtensionWrapper.getCustomExtension()).getUploadDirectory().toFile());
        Request fileRequest = this.buildFileRequest(fileHandler.getMessageHeaders().getTargetRestEndpointURL());
        try (Response response = client.newCall(fileRequest).execute();){
            Assertions.assertThat((int)response.code()).isEqualTo(fileHandler.getMessageHeaders().getResponseStatusCode().code());
        }
        this.verifyNoFileIsRegisteredToDeleteOnExitHook();
    }

    @Test
    void testMixedMultipart() throws Exception {
        OkHttpClient client = this.createOkHttpClientWithNoTimeouts();
        MultipartUploadExtension.MultipartMixedHandler mixedHandler = ((MultipartUploadExtension)this.multipartUpdateExtensionWrapper.getCustomExtension()).getMixedHandler();
        Request jsonRequest = this.buildJsonRequest(mixedHandler.getMessageHeaders().getTargetRestEndpointURL(), new MultipartUploadExtension.TestRequestBody());
        try (Response response = client.newCall(jsonRequest).execute();){
            Assertions.assertThat((int)response.code()).isEqualTo(HttpResponseStatus.INTERNAL_SERVER_ERROR.code());
        }
        Request fileRequest = this.buildFileRequest(mixedHandler.getMessageHeaders().getTargetRestEndpointURL());
        try (Response response = client.newCall(fileRequest).execute();){
            Assertions.assertThat((int)response.code()).isEqualTo(HttpResponseStatus.BAD_REQUEST.code());
        }
        MultipartUploadExtension.TestRequestBody json = new MultipartUploadExtension.TestRequestBody();
        Request mixedRequest = this.buildMixedRequest(mixedHandler.getMessageHeaders().getTargetRestEndpointURL(), json);
        try (Response response = client.newCall(mixedRequest).execute();){
            Assertions.assertThat((int)response.code()).isEqualTo(mixedHandler.getMessageHeaders().getResponseStatusCode().code());
            Assertions.assertThat((Object)mixedHandler.lastReceivedRequest).isEqualTo((Object)json);
        }
        this.verifyNoFileIsRegisteredToDeleteOnExitHook();
    }

    @Test
    void testMixedMultipartEndOfDataDecoderExceptionHandling(@TempDir Path tmp) throws Exception {
        OkHttpClient client = this.createOkHttpClientWithNoTimeouts();
        MultipartUploadExtension.MultipartMixedHandler mixedHandler = ((MultipartUploadExtension)this.multipartUpdateExtensionWrapper.getCustomExtension()).getMixedHandler();
        MultipartUploadExtension.TestRequestBody json = new MultipartUploadExtension.TestRequestBody();
        File file = TempDirUtils.newFile((Path)tmp);
        try (RandomAccessFile rw = new RandomAccessFile(file, "rw");){
            rw.setLength(1424L);
        }
        ((MultipartUploadExtension)this.multipartUpdateExtensionWrapper.getCustomExtension()).setFileUploadVerifier((BiConsumerWithException<HandlerRequest<? extends RequestBody>, RestfulGateway, Exception>)((BiConsumerWithException)(handlerRequest, restfulGateway) -> MultipartUploadExtension.assertUploadedFilesEqual(handlerRequest, Collections.singleton(file))));
        Request singleFileMixedRequest = this.buildMixedRequest(mixedHandler.getMessageHeaders().getTargetRestEndpointURL(), json, file);
        try (Response response = client.newCall(singleFileMixedRequest).execute();){
            Assertions.assertThat((int)response.code()).isEqualTo(mixedHandler.getMessageHeaders().getResponseStatusCode().code());
            Assertions.assertThat((Object)mixedHandler.lastReceivedRequest).isEqualTo((Object)json);
        }
        this.verifyNoFileIsRegisteredToDeleteOnExitHook();
    }

    @Test
    void testJsonMultipart() throws Exception {
        OkHttpClient client = this.createOkHttpClientWithNoTimeouts();
        MultipartUploadExtension.MultipartJsonHandler jsonHandler = ((MultipartUploadExtension)this.multipartUpdateExtensionWrapper.getCustomExtension()).getJsonHandler();
        MultipartUploadExtension.TestRequestBody json = new MultipartUploadExtension.TestRequestBody();
        Request jsonRequest = this.buildJsonRequest(jsonHandler.getMessageHeaders().getTargetRestEndpointURL(), json);
        try (Response response = client.newCall(jsonRequest).execute();){
            Assertions.assertThat((int)response.code()).isEqualTo(jsonHandler.getMessageHeaders().getResponseStatusCode().code());
            Assertions.assertThat((Object)jsonHandler.lastReceivedRequest).isEqualTo((Object)json);
        }
        Request fileRequest = this.buildFileRequest(jsonHandler.getMessageHeaders().getTargetRestEndpointURL());
        try (Response response = client.newCall(fileRequest).execute();){
            Assertions.assertThat((int)response.code()).isEqualTo(HttpResponseStatus.BAD_REQUEST.code());
        }
        Request mixedRequest = this.buildMixedRequest(jsonHandler.getMessageHeaders().getTargetRestEndpointURL(), new MultipartUploadExtension.TestRequestBody());
        try (Response response = client.newCall(mixedRequest).execute();){
            Assertions.assertThat((int)response.code()).isEqualTo(HttpResponseStatus.BAD_REQUEST.code());
        }
        this.verifyNoFileIsRegisteredToDeleteOnExitHook();
    }

    @Test
    void testFileMultipart() throws Exception {
        OkHttpClient client = this.createOkHttpClientWithNoTimeouts();
        MultipartUploadExtension.MultipartFileHandler fileHandler = ((MultipartUploadExtension)this.multipartUpdateExtensionWrapper.getCustomExtension()).getFileHandler();
        Request jsonRequest = this.buildJsonRequest(fileHandler.getMessageHeaders().getTargetRestEndpointURL(), new MultipartUploadExtension.TestRequestBody());
        try (Response response = client.newCall(jsonRequest).execute();){
            Assertions.assertThat((int)response.code()).isEqualTo(HttpResponseStatus.BAD_REQUEST.code());
        }
        Request fileRequest = this.buildFileRequest(fileHandler.getMessageHeaders().getTargetRestEndpointURL());
        try (Response response = client.newCall(fileRequest).execute();){
            Assertions.assertThat((int)response.code()).isEqualTo(fileHandler.getMessageHeaders().getResponseStatusCode().code());
        }
        Request mixedRequest = this.buildMixedRequest(fileHandler.getMessageHeaders().getTargetRestEndpointURL(), new MultipartUploadExtension.TestRequestBody());
        try (Response response = client.newCall(mixedRequest).execute();){
            Assertions.assertThat((int)response.code()).isEqualTo(HttpResponseStatus.BAD_REQUEST.code());
        }
        this.verifyNoFileIsRegisteredToDeleteOnExitHook();
    }

    @Test
    void testUploadCleanupOnUnknownAttribute() throws IOException {
        OkHttpClient client = this.createOkHttpClientWithNoTimeouts();
        Request request = this.buildMixedRequestWithUnknownAttribute(((MultipartUploadExtension)this.multipartUpdateExtensionWrapper.getCustomExtension()).getMixedHandler().getMessageHeaders().getTargetRestEndpointURL());
        try (Response response = client.newCall(request).execute();){
            Assertions.assertThat((int)response.code()).isEqualTo(HttpResponseStatus.BAD_REQUEST.code());
        }
        ((MultipartUploadExtension)this.multipartUpdateExtensionWrapper.getCustomExtension()).assertUploadDirectoryIsEmpty();
        this.verifyNoFileIsRegisteredToDeleteOnExitHook();
    }

    @Test
    void testUploadCleanupOnFailure() throws IOException {
        OkHttpClient client = this.createOkHttpClientWithNoTimeouts();
        Request request = this.buildMalformedRequest(((MultipartUploadExtension)this.multipartUpdateExtensionWrapper.getCustomExtension()).getMixedHandler().getMessageHeaders().getTargetRestEndpointURL());
        try (Response response = client.newCall(request).execute();){
            Assertions.assertThat((int)response.code()).isEqualTo(HttpResponseStatus.INTERNAL_SERVER_ERROR.code());
        }
        ((MultipartUploadExtension)this.multipartUpdateExtensionWrapper.getCustomExtension()).assertUploadDirectoryIsEmpty();
        this.verifyNoFileIsRegisteredToDeleteOnExitHook();
    }

    @Test
    void testFileUploadUsingCustomFilename() throws IOException {
        OkHttpClient client = this.createOkHttpClientWithNoTimeouts();
        String customFilename1 = "different-name-1.jar";
        String customFilename2 = "different-name-2.jar";
        ((MultipartUploadExtension)this.multipartUpdateExtensionWrapper.getCustomExtension()).setFileUploadVerifier(new CustomFilenameVerifier(customFilename1, ((MultipartUploadExtension)this.multipartUpdateExtensionWrapper.getCustomExtension()).file1.toPath(), customFilename2, ((MultipartUploadExtension)this.multipartUpdateExtensionWrapper.getCustomExtension()).file2.toPath()));
        MessageHeaders messageHeaders = ((MultipartUploadExtension)this.multipartUpdateExtensionWrapper.getCustomExtension()).getFileHandler().getMessageHeaders();
        Request request = this.buildRequestWithCustomFilenames(messageHeaders.getTargetRestEndpointURL(), customFilename1, customFilename2);
        try (Response response = client.newCall(request).execute();){
            Assertions.assertThat((int)response.code()).isEqualTo(messageHeaders.getResponseStatusCode().code());
        }
        this.verifyNoFileIsRegisteredToDeleteOnExitHook();
    }

    @Test
    void testFileUploadUsingCustomFilenameWithParentFolderPath() throws IOException {
        OkHttpClient client = this.createOkHttpClientWithNoTimeouts();
        String customFilename1 = "different-name-1.jar";
        String customFilename2 = "different-name-2.jar";
        ((MultipartUploadExtension)this.multipartUpdateExtensionWrapper.getCustomExtension()).setFileUploadVerifier(new CustomFilenameVerifier(customFilename1, ((MultipartUploadExtension)this.multipartUpdateExtensionWrapper.getCustomExtension()).file1.toPath(), customFilename2, ((MultipartUploadExtension)this.multipartUpdateExtensionWrapper.getCustomExtension()).file2.toPath()));
        MessageHeaders messageHeaders = ((MultipartUploadExtension)this.multipartUpdateExtensionWrapper.getCustomExtension()).getFileHandler().getMessageHeaders();
        Request request = this.buildRequestWithCustomFilenames(((MultipartUploadExtension)this.multipartUpdateExtensionWrapper.getCustomExtension()).getFileHandler().getMessageHeaders().getTargetRestEndpointURL(), String.format("../%s", customFilename1), String.format("../%s", customFilename2));
        try (Response response = client.newCall(request).execute();){
            Assertions.assertThat((int)response.code()).isEqualTo(messageHeaders.getResponseStatusCode().code());
        }
        this.verifyNoFileIsRegisteredToDeleteOnExitHook();
    }

    private OkHttpClient createOkHttpClientWithNoTimeouts() {
        return new OkHttpClient.Builder().connectTimeout(0L, TimeUnit.MILLISECONDS).writeTimeout(0L, TimeUnit.MILLISECONDS).readTimeout(0L, TimeUnit.MILLISECONDS).build();
    }

    private void verifyNoFileIsRegisteredToDeleteOnExitHook() {
        ((AbstractThrowableAssert)Assertions.assertThatCode(() -> {
            Class<?> clazz = Class.forName("java.io.DeleteOnExitHook");
            Field field = clazz.getDeclaredField("files");
            field.setAccessible(true);
            LinkedHashSet files = (LinkedHashSet)field.get(null);
            boolean fileFound = false;
            for (String file : files) {
                if (file.contains("mockitoboot")) continue;
                fileFound = true;
                break;
            }
            Assertions.assertThat((boolean)fileFound).isFalse();
        }).withFailMessage("This should never happen.", new Object[0])).doesNotThrowAnyException();
    }

    private static class CustomFilenameVerifier
    implements BiConsumerWithException<HandlerRequest<? extends RequestBody>, RestfulGateway, Exception> {
        private final String customFilename1;
        private final Path fileContent1;
        private final String customFilename2;
        private final Path fileContent2;

        public CustomFilenameVerifier(String customFilename1, Path fileContent1, String customFilename2, Path fileContent2) {
            this.customFilename1 = customFilename1;
            this.fileContent1 = fileContent1;
            this.customFilename2 = customFilename2;
            this.fileContent2 = fileContent2;
        }

        public void accept(HandlerRequest<? extends RequestBody> request, RestfulGateway restfulGateway) throws Exception {
            List uploadedFiles = request.getUploadedFiles().stream().map(File::toPath).collect(Collectors.toList());
            ArrayList actualList = new ArrayList(uploadedFiles);
            actualList.sort(Comparator.comparing(Path::toString));
            TreeMap<String, Path> expectedFilenamesAndContent = new TreeMap<String, Path>();
            expectedFilenamesAndContent.put(this.customFilename1, this.fileContent1);
            expectedFilenamesAndContent.put(this.customFilename2, this.fileContent2);
            Assertions.assertThat(expectedFilenamesAndContent).hasSameSizeAs(uploadedFiles);
            Iterator uploadedFileIterator = actualList.iterator();
            for (Map.Entry expectedFilenameAndContent : expectedFilenamesAndContent.entrySet()) {
                String expectedFilename = (String)expectedFilenameAndContent.getKey();
                Path expectedContent = (Path)expectedFilenameAndContent.getValue();
                Assertions.assertThat(uploadedFileIterator).hasNext();
                Path actual = (Path)uploadedFileIterator.next();
                Assertions.assertThat((Path)actual.getFileName()).hasToString(expectedFilename);
                byte[] originalContent = Files.readAllBytes(expectedContent);
                byte[] receivedContent = Files.readAllBytes(actual);
                Assertions.assertThat((byte[])receivedContent).isEqualTo((Object)originalContent);
            }
        }
    }
}

