/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.leaderelection;

import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.flink.core.testutils.FlinkAssertions;
import org.apache.flink.core.testutils.OneShotLatch;
import org.apache.flink.runtime.concurrent.ManuallyTriggeredScheduledExecutorService;
import org.apache.flink.runtime.leaderelection.DefaultLeaderElectionService;
import org.apache.flink.runtime.leaderelection.LeaderContender;
import org.apache.flink.runtime.leaderelection.LeaderElection;
import org.apache.flink.runtime.leaderelection.LeaderElectionDriver;
import org.apache.flink.runtime.leaderelection.LeaderElectionDriverFactory;
import org.apache.flink.runtime.leaderelection.LeaderElectionService;
import org.apache.flink.runtime.leaderelection.LeaderInformation;
import org.apache.flink.runtime.leaderelection.LeaderInformationRegister;
import org.apache.flink.runtime.leaderelection.TestingContender;
import org.apache.flink.runtime.leaderelection.TestingGenericLeaderContender;
import org.apache.flink.runtime.leaderelection.TestingLeaderElectionDriver;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.util.TestingFatalErrorHandlerExtension;
import org.apache.flink.util.concurrent.Executors;
import org.apache.flink.util.function.RunnableWithException;
import org.apache.flink.util.function.ThrowingConsumer;
import org.apache.flink.util.function.TriConsumer;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AtomicBooleanAssert;
import org.assertj.core.api.AtomicIntegerAssert;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.OptionalAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

class DefaultLeaderElectionServiceTest {
    @RegisterExtension
    public final TestingFatalErrorHandlerExtension fatalErrorHandlerExtension = new TestingFatalErrorHandlerExtension();

    DefaultLeaderElectionServiceTest() {
    }

    @Test
    void testOnGrantAndRevokeLeadership() throws Exception {
        final AtomicReference<LeaderInformationRegister> storedLeaderInformation = new AtomicReference<LeaderInformationRegister>(LeaderInformationRegister.empty());
        new Context(storedLeaderInformation){
            {
                super(storedLeaderInformation2);
                this.runTestWithSynchronousEventHandling(() -> {
                    UUID leaderSessionID = UUID.randomUUID();
                    this.grantLeadership(leaderSessionID);
                    this.applyToBothContenderContexts((ThrowingConsumer<ContenderContext, Exception>)((ThrowingConsumer)ctx -> {
                        ((ContenderContext)ctx).contender.waitForLeader();
                        ((AbstractComparableAssert)Assertions.assertThat((Comparable)((ContenderContext)ctx).contender.getLeaderSessionID()).isEqualTo((Object)this.leaderElectionService.getLeaderSessionID(((ContenderContext)ctx).componentId))).isEqualTo((Object)leaderSessionID);
                        LeaderInformation expectedLeaderInformationInHaBackend = LeaderInformation.known((UUID)leaderSessionID, (String)((ContenderContext)ctx).address);
                        ((OptionalAssert)Assertions.assertThat((Optional)((LeaderInformationRegister)storedLeaderInformation.get()).forComponentId(((ContenderContext)ctx).componentId)).as("The HA backend should have its leader information updated.", new Object[0])).hasValue((Object)expectedLeaderInformationInHaBackend);
                    }));
                    this.revokeLeadership();
                    this.applyToBothContenderContexts((ThrowingConsumer<ContenderContext, Exception>)((ThrowingConsumer)ctx -> {
                        ((ContenderContext)ctx).contender.waitForRevokeLeader();
                        Assertions.assertThat((Comparable)((ContenderContext)ctx).contender.getLeaderSessionID()).isNull();
                        Assertions.assertThat((Comparable)this.leaderElectionService.getLeaderSessionID(((ContenderContext)ctx).componentId)).isNull();
                        LeaderInformation expectedLeaderInformationInHaBackend = LeaderInformation.known((UUID)leaderSessionID, (String)((ContenderContext)ctx).address);
                        ((OptionalAssert)Assertions.assertThat((Optional)((LeaderInformationRegister)storedLeaderInformation.get()).forComponentId(((ContenderContext)ctx).componentId)).as("External storage is not touched by the leader session because the leadership is already lost.", new Object[0])).hasValue((Object)expectedLeaderInformationInHaBackend);
                    }));
                });
            }
        };
    }

    @Test
    void testErrorOnComponentIdReuse() throws Exception {
        new Context(){
            {
                this.runTestWithSynchronousEventHandling(() -> {
                    AbstractThrowableAssert cfr_ignored_0 = (AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.leaderElectionService.createLeaderElection(this.contenderContext0.componentId)).isInstanceOf(IllegalStateException.class);
                });
            }
        };
    }

    @Test
    void testCloseGrantDeadlock() throws Exception {
        OneShotLatch closeReachedLatch = new OneShotLatch();
        OneShotLatch closeContinueLatch = new OneShotLatch();
        OneShotLatch grantReachedLatch = new OneShotLatch();
        OneShotLatch grantContinueLatch = new OneShotLatch();
        CompletableFuture driverCloseTriggered = new CompletableFuture();
        AtomicBoolean leadershipGranted = new AtomicBoolean();
        TestingLeaderElectionDriver.Builder driverBuilder = TestingLeaderElectionDriver.newBuilder(leadershipGranted).setCloseConsumer((ThrowingConsumer<ReentrantLock, Exception>)((ThrowingConsumer)lock -> {
            closeReachedLatch.trigger();
            closeContinueLatch.await();
            try {
                lock.lock();
                driverCloseTriggered.complete(null);
            }
            finally {
                lock.unlock();
            }
        }));
        TestingLeaderElectionDriver.Factory driverFactory = new TestingLeaderElectionDriver.Factory(driverBuilder);
        try (DefaultLeaderElectionService testInstance = new DefaultLeaderElectionService((LeaderElectionDriverFactory)driverFactory, (FatalErrorHandler)this.fatalErrorHandlerExtension.getTestingFatalErrorHandler());){
            LeaderElection leaderElection = testInstance.createLeaderElection("component-id");
            leaderElection.startLeaderElection((LeaderContender)TestingGenericLeaderContender.newBuilder().build());
            TestingLeaderElectionDriver driver = driverFactory.assertAndGetOnlyCreatedDriver();
            Thread closeThread = new Thread(() -> {
                try {
                    leaderElection.close();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }, "CloseThread");
            closeThread.start();
            closeReachedLatch.await();
            Thread grantThread = new Thread(() -> {
                try {
                    driver.getLock().lock();
                    grantReachedLatch.trigger();
                    grantContinueLatch.awaitQuietly();
                    leadershipGranted.set(true);
                    testInstance.onGrantLeadership(UUID.randomUUID());
                }
                finally {
                    driver.getLock().unlock();
                }
            }, "GrantThread");
            grantThread.start();
            grantReachedLatch.await();
            grantContinueLatch.trigger();
            closeContinueLatch.trigger();
            closeThread.join();
            grantThread.join();
            FlinkAssertions.assertThatFuture(driverCloseTriggered).eventuallySucceeds();
        }
    }

    @Test
    void testLazyDriverInstantiation() throws Exception {
        AtomicBoolean driverCreated = new AtomicBoolean();
        try (DefaultLeaderElectionService testInstance = new DefaultLeaderElectionService(listener -> {
            driverCreated.set(true);
            return TestingLeaderElectionDriver.newNoOpBuilder().build(listener);
        }, (FatalErrorHandler)this.fatalErrorHandlerExtension.getTestingFatalErrorHandler(), Executors.newDirectExecutorService());){
            ((AtomicBooleanAssert)Assertions.assertThat((AtomicBoolean)driverCreated).as("The driver shouldn't have been created during service creation.", new Object[0])).isFalse();
            try (LeaderElection leaderElection = testInstance.createLeaderElection("component-id");){
                ((AtomicBooleanAssert)Assertions.assertThat((AtomicBoolean)driverCreated).as("The driver shouldn't have been created during LeaderElection creation.", new Object[0])).isFalse();
                leaderElection.startLeaderElection((LeaderContender)TestingGenericLeaderContender.newBuilder().build());
                ((AtomicBooleanAssert)Assertions.assertThat((AtomicBoolean)driverCreated).as("The driver should have been created when registering the contender in the LeaderElection.", new Object[0])).isTrue();
            }
        }
    }

    @Test
    void testReuseOfServiceIsRestricted() throws Exception {
        DefaultLeaderElectionService testInstance = new DefaultLeaderElectionService((LeaderElectionDriverFactory)new TestingLeaderElectionDriver.Factory(TestingLeaderElectionDriver.newNoOpBuilder()));
        testInstance.close();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> testInstance.createLeaderElection("component-id")).as("Registering a contender on a closed service should have resulted in an IllegalStateException.", new Object[0])).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void testMultipleDriverCreations() throws Exception {
        AtomicInteger closeCount = new AtomicInteger(0);
        TestingLeaderElectionDriver.Factory driverFactory = new TestingLeaderElectionDriver.Factory(TestingLeaderElectionDriver.newNoOpBuilder().setCloseConsumer((ThrowingConsumer<ReentrantLock, Exception>)((ThrowingConsumer)ignoredLock -> closeCount.incrementAndGet())));
        try (DefaultLeaderElectionService testInstance = new DefaultLeaderElectionService((LeaderElectionDriverFactory)driverFactory);){
            String componentId = "component_id";
            int numberOfStartCloseSessions = 2;
            for (int i = 1; i <= 2; ++i) {
                Assertions.assertThat((int)driverFactory.getCreatedDriverCount()).isEqualTo(i - 1);
                Assertions.assertThat((AtomicInteger)closeCount).hasValue(i - 1);
                try (LeaderElection leaderElection = testInstance.createLeaderElection("component_id");){
                    leaderElection.startLeaderElection((LeaderContender)TestingGenericLeaderContender.newBuilder().build());
                }
                Assertions.assertThat((int)driverFactory.getCreatedDriverCount()).isEqualTo(i);
                Assertions.assertThat((AtomicInteger)closeCount).hasValue(i);
            }
        }
    }

    @Test
    void testGrantCallWhileInstantiatingDriver() throws Exception {
        UUID expectedLeaderSessionID = UUID.randomUUID();
        TestingLeaderElectionDriver.Builder driverBuilder = TestingLeaderElectionDriver.newNoOpBuilder();
        try (DefaultLeaderElectionService testInstance = new DefaultLeaderElectionService(listener -> {
            OneShotLatch waitForGrantTriggerLatch = new OneShotLatch();
            CompletableFuture.runAsync(() -> {
                waitForGrantTriggerLatch.trigger();
                listener.onGrantLeadership(expectedLeaderSessionID);
            });
            waitForGrantTriggerLatch.await();
            Thread.sleep(100L);
            return driverBuilder.build(listener);
        }, (FatalErrorHandler)this.fatalErrorHandlerExtension.getTestingFatalErrorHandler(), Executors.newDirectExecutorService());){
            LeaderElection leaderElection = testInstance.createLeaderElection(DefaultLeaderElectionServiceTest.createRandomComponentId());
            TestingContender testingContender = new TestingContender("unused-address", leaderElection);
            testingContender.startLeaderElection();
            testingContender.waitForLeader();
            Assertions.assertThat((Comparable)testingContender.getLeaderSessionID()).isEqualTo((Object)expectedLeaderSessionID);
            leaderElection.close();
        }
    }

    @Test
    void testDelayedGrantCallAfterContenderRegistration() throws Exception {
        TestingLeaderElectionDriver.Factory driverFactory = new TestingLeaderElectionDriver.Factory(TestingLeaderElectionDriver.newNoOpBuilder());
        ManuallyTriggeredScheduledExecutorService leaderEventOperationExecutor = new ManuallyTriggeredScheduledExecutorService();
        try (DefaultLeaderElectionService leaderElectionService = new DefaultLeaderElectionService((LeaderElectionDriverFactory)driverFactory, (FatalErrorHandler)this.fatalErrorHandlerExtension.getTestingFatalErrorHandler(), (ExecutorService)leaderEventOperationExecutor);){
            AtomicBoolean firstContenderReceivedGrant = new AtomicBoolean(false);
            TestingGenericLeaderContender firstContender = TestingGenericLeaderContender.newBuilder().setGrantLeadershipConsumer(ignoredSessionID -> firstContenderReceivedGrant.set(true)).build();
            AtomicBoolean secondContenderReceivedGrant = new AtomicBoolean(false);
            TestingGenericLeaderContender secondContender = TestingGenericLeaderContender.newBuilder().setGrantLeadershipConsumer(ignoredSessionID -> secondContenderReceivedGrant.set(true)).build();
            try (LeaderElection firstLeaderElection = leaderElectionService.createLeaderElection("component_id_0");){
                firstLeaderElection.startLeaderElection((LeaderContender)firstContender);
                ((AbstractIntegerAssert)Assertions.assertThat((int)driverFactory.getCreatedDriverCount()).as("A single driver should have been created when registering the contender.", new Object[0])).isEqualTo(1);
                leaderElectionService.onGrantLeadership(UUID.randomUUID());
                Assertions.assertThat((AtomicBoolean)firstContenderReceivedGrant).isFalse();
                try (LeaderElection secondLeaderElection = leaderElectionService.createLeaderElection("component_id_1");){
                    secondLeaderElection.startLeaderElection((LeaderContender)secondContender);
                    Assertions.assertThat((AtomicBoolean)secondContenderReceivedGrant).isFalse();
                    leaderEventOperationExecutor.trigger();
                    Assertions.assertThat((AtomicBoolean)firstContenderReceivedGrant).isTrue();
                    Assertions.assertThat((AtomicBoolean)secondContenderReceivedGrant).isTrue();
                }
            }
        }
    }

    @Test
    void testDelayedGrantCallAfterContenderBeingDeregisteredAgain() throws Exception {
        TestingLeaderElectionDriver.Factory driverFactory = new TestingLeaderElectionDriver.Factory(TestingLeaderElectionDriver.newNoOpBuilder());
        ManuallyTriggeredScheduledExecutorService leaderEventOperationExecutor = new ManuallyTriggeredScheduledExecutorService();
        try (DefaultLeaderElectionService leaderElectionService = new DefaultLeaderElectionService((LeaderElectionDriverFactory)driverFactory, (FatalErrorHandler)this.fatalErrorHandlerExtension.getTestingFatalErrorHandler(), (ExecutorService)leaderEventOperationExecutor);){
            AtomicBoolean leadershipGrantForwardedToContender = new AtomicBoolean(false);
            TestingGenericLeaderContender leaderContender = TestingGenericLeaderContender.newBuilder().setGrantLeadershipConsumer(ignoredSessionID -> leadershipGrantForwardedToContender.set(true)).build();
            try (LeaderElection leaderElection = leaderElectionService.createLeaderElection("component_id");){
                leaderElection.startLeaderElection((LeaderContender)leaderContender);
                ((AbstractIntegerAssert)Assertions.assertThat((int)driverFactory.getCreatedDriverCount()).as("A single driver should have been created when registering the contender.", new Object[0])).isEqualTo(1);
                leaderElectionService.onGrantLeadership(UUID.randomUUID());
            }
            leaderEventOperationExecutor.trigger();
            Assertions.assertThat((AtomicBoolean)leadershipGrantForwardedToContender).isFalse();
        }
    }

    @Test
    void testDelayedRevokeCallAfterContenderBeingDeregisteredAgain() throws Exception {
        new Context(){
            {
                this.runTestWithManuallyTriggeredEvents((ThrowingConsumer<ManuallyTriggeredScheduledExecutorService, Exception>)((ThrowingConsumer)executorService -> {
                    UUID expectedSessionID = UUID.randomUUID();
                    this.grantLeadership(expectedSessionID);
                    executorService.trigger();
                    LeaderElection leaderElection = this.leaderElectionService.createLeaderElection(DefaultLeaderElectionServiceTest.createRandomComponentId());
                    AtomicInteger revokeCallCount = new AtomicInteger();
                    TestingGenericLeaderContender contender = TestingGenericLeaderContender.newBuilder().setRevokeLeadershipRunnable(revokeCallCount::incrementAndGet).build();
                    leaderElection.startLeaderElection((LeaderContender)contender);
                    executorService.trigger();
                    ((AtomicIntegerAssert)Assertions.assertThat((AtomicInteger)revokeCallCount).as("No revocation should have been triggered, yet.", new Object[0])).hasValue(0);
                    this.revokeLeadership();
                    ((AtomicIntegerAssert)Assertions.assertThat((AtomicInteger)revokeCallCount).as("A revocation was triggered but not processed, yet.", new Object[0])).hasValue(0);
                    leaderElection.close();
                    ((AtomicIntegerAssert)Assertions.assertThat((AtomicInteger)revokeCallCount).as("A revocation should have been triggered and immediately processed through the close call.", new Object[0])).hasValue(1);
                    executorService.triggerAll();
                    ((AtomicIntegerAssert)Assertions.assertThat((AtomicInteger)revokeCallCount).as("The leadership revocation event that was triggered by the HA backend shouldn't have been forwarded to the contender, anymore.", new Object[0])).hasValue(1);
                }));
            }
        };
    }

    @Test
    void testDriverShutdownFailsWithContenderStillBeingRegistered() throws Exception {
        new Context(){
            {
                this.runTestWithSynchronousEventHandling(() -> {
                    AbstractThrowableAssert cfr_ignored_0 = (AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((DefaultLeaderElectionService)this.leaderElectionService).close()).as("The LeaderContender needs to be deregistered before closing the driver.", new Object[0])).isInstanceOf(IllegalStateException.class);
                });
            }
        };
    }

    @Test
    void testProperCleanupOnLeaderElectionCloseWhenHoldingTheLeadership() throws Exception {
        final AtomicReference storedLeaderInformation = new AtomicReference();
        new Context(storedLeaderInformation){
            {
                super(storedLeaderInformation2);
                this.runTestWithSynchronousEventHandling(() -> {
                    UUID leaderSessionID = UUID.randomUUID();
                    this.grantLeadership(leaderSessionID);
                    this.applyToBothContenderContexts((ThrowingConsumer<ContenderContext, Exception>)((ThrowingConsumer)ctx -> {
                        Assertions.assertThat((Comparable)((ContenderContext)ctx).contender.getLeaderSessionID()).isEqualTo((Object)leaderSessionID);
                        Assertions.assertThat((Comparable)this.leaderElectionService.getLeaderSessionID(((ContenderContext)ctx).componentId)).isEqualTo((Object)leaderSessionID);
                        Assertions.assertThat((Comparable)this.leaderElectionService.getLeaderSessionID(((ContenderContext)ctx).componentId)).isEqualTo((Object)leaderSessionID);
                        Assertions.assertThat((Optional)((LeaderInformationRegister)storedLeaderInformation.get()).forComponentId(((ContenderContext)ctx).componentId)).hasValue((Object)LeaderInformation.known((UUID)leaderSessionID, (String)((ContenderContext)ctx).address));
                        ((ContenderContext)ctx).leaderElection.close();
                        ((AbstractComparableAssert)Assertions.assertThat((Comparable)((ContenderContext)ctx).contender.getLeaderSessionID()).as("The LeaderContender should have been informed about the leadership loss.", new Object[0])).isNull();
                        ((AbstractComparableAssert)Assertions.assertThat((Comparable)this.leaderElectionService.getLeaderSessionID(((ContenderContext)ctx).componentId)).as("The LeaderElectionService should have its internal state cleaned.", new Object[0])).isNull();
                    }));
                    ((IterableAssert)Assertions.assertThat((Iterable)((LeaderInformationRegister)storedLeaderInformation.get()).getRegisteredComponentIds()).as("The HA backend's data should have been cleaned.", new Object[0])).isEmpty();
                });
            }
        };
    }

    @Test
    void testSingleLeaderInformationChangedAndShouldBeCorrected() throws Exception {
        final AtomicReference storedLeaderInformation = new AtomicReference();
        new Context(storedLeaderInformation){
            {
                super(storedLeaderInformation2);
                this.runTestWithSynchronousEventHandling(() -> {
                    UUID leaderSessionID = UUID.randomUUID();
                    this.grantLeadership(leaderSessionID);
                    LeaderInformation expectedLeaderInformation = LeaderInformation.known((UUID)leaderSessionID, (String)this.contenderContext0.address);
                    storedLeaderInformation.set(LeaderInformationRegister.empty());
                    this.leaderElectionService.onLeaderInformationChange(this.contenderContext0.componentId, LeaderInformation.empty());
                    ((OptionalAssert)Assertions.assertThat((Optional)((LeaderInformationRegister)storedLeaderInformation.get()).forComponentId(this.contenderContext0.componentId)).as("Removed leader information should have been reset.", new Object[0])).hasValue((Object)expectedLeaderInformation);
                    LeaderInformation faultyLeaderInformation = LeaderInformation.known((UUID)UUID.randomUUID(), (String)"faulty-address");
                    storedLeaderInformation.set(LeaderInformationRegister.of((String)this.contenderContext0.componentId, (LeaderInformation)faultyLeaderInformation));
                    this.leaderElectionService.onLeaderInformationChange(this.contenderContext0.componentId, faultyLeaderInformation);
                    ((OptionalAssert)Assertions.assertThat((Optional)((LeaderInformationRegister)storedLeaderInformation.get()).forComponentId(this.contenderContext0.componentId)).as("Overwritten leader information should have been reset.", new Object[0])).hasValue((Object)expectedLeaderInformation);
                });
            }
        };
    }

    @Test
    void testAllLeaderInformationChangeEventWithPartialCorrection() throws Exception {
        final AtomicReference storedLeaderInformation = new AtomicReference();
        new Context(storedLeaderInformation){
            {
                super(storedLeaderInformation2);
                this.runTestWithSynchronousEventHandling(() -> {
                    UUID leaderSessionID = UUID.randomUUID();
                    this.grantLeadership(leaderSessionID);
                    LeaderInformationRegister correctLeaderInformationRegister = (LeaderInformationRegister)storedLeaderInformation.get();
                    Assertions.assertThat((Iterable)correctLeaderInformationRegister.getRegisteredComponentIds()).containsExactlyInAnyOrder((Object[])new String[]{this.contenderContext0.componentId, this.contenderContext1.componentId});
                    String componentIdWithChange = this.contenderContext0.componentId;
                    String componentIdWithoutChange = this.contenderContext1.componentId;
                    LeaderInformationRegister partiallyChangedLeaderInformationRegister = LeaderInformationRegister.clear((LeaderInformationRegister)correctLeaderInformationRegister, (String)componentIdWithChange);
                    storedLeaderInformation.set(partiallyChangedLeaderInformationRegister);
                    this.leaderElectionService.onLeaderInformationChange(partiallyChangedLeaderInformationRegister);
                    ((OptionalAssert)Assertions.assertThat((Optional)((LeaderInformationRegister)storedLeaderInformation.get()).forComponentId(componentIdWithChange)).as("Removed leader information should have been reset.", new Object[0])).hasValue((Object)correctLeaderInformationRegister.forComponentIdOrEmpty(componentIdWithChange));
                    Assertions.assertThat((Optional)((LeaderInformationRegister)storedLeaderInformation.get()).forComponentId(componentIdWithoutChange)).hasValue((Object)correctLeaderInformationRegister.forComponentIdOrEmpty(componentIdWithoutChange));
                });
            }
        };
    }

    @Test
    void testAllLeaderInformationChangeEventWithUnknownComponentId() throws Exception {
        final AtomicReference storedLeaderInformation = new AtomicReference();
        new Context(storedLeaderInformation){
            {
                super(storedLeaderInformation2);
                this.runTestWithSynchronousEventHandling(() -> {
                    UUID leaderSessionID = UUID.randomUUID();
                    this.grantLeadership(leaderSessionID);
                    LeaderInformationRegister correctLeaderInformationRegister = (LeaderInformationRegister)storedLeaderInformation.get();
                    Assertions.assertThat((Iterable)correctLeaderInformationRegister.getRegisteredComponentIds()).containsExactlyInAnyOrder((Object[])new String[]{this.contenderContext0.componentId, this.contenderContext1.componentId});
                    String unknownComponentId = DefaultLeaderElectionServiceTest.createRandomComponentId();
                    LeaderInformationRegister partiallyChangedLeaderInformationRegister = LeaderInformationRegister.merge((LeaderInformationRegister)correctLeaderInformationRegister, (String)unknownComponentId, (LeaderInformation)LeaderInformation.known((UUID)UUID.randomUUID(), (String)("address-for-" + unknownComponentId)));
                    storedLeaderInformation.set(partiallyChangedLeaderInformationRegister);
                    this.leaderElectionService.onLeaderInformationChange(partiallyChangedLeaderInformationRegister);
                    ((ObjectAssert)Assertions.assertThat(storedLeaderInformation.get()).as("The HA backend shouldn't have been touched by the service.", new Object[0])).isSameAs((Object)partiallyChangedLeaderInformationRegister);
                });
            }
        };
    }

    @Test
    void testHasLeadershipAsyncWithLeadershipButNoGrantEventProcessed() throws Exception {
        new Context(){
            {
                this.runTestWithManuallyTriggeredEvents((ThrowingConsumer<ManuallyTriggeredScheduledExecutorService, Exception>)((ThrowingConsumer)executorService -> {
                    UUID expectedSessionID = UUID.randomUUID();
                    this.grantLeadership(expectedSessionID);
                    this.applyToBothContenderContexts((ThrowingConsumer<ContenderContext, Exception>)((ThrowingConsumer)ctx -> {
                        CompletableFuture validSessionFuture = this.leaderElectionService.hasLeadershipAsync(((ContenderContext)ctx).componentId, expectedSessionID);
                        CompletableFuture invalidSessionFuture = this.leaderElectionService.hasLeadershipAsync(((ContenderContext)ctx).componentId, UUID.randomUUID());
                        executorService.triggerAll();
                        FlinkAssertions.assertThatFuture((CompletableFuture)validSessionFuture).eventuallySucceeds().isEqualTo((Object)true);
                        FlinkAssertions.assertThatFuture((CompletableFuture)invalidSessionFuture).eventuallySucceeds().isEqualTo((Object)false);
                    }));
                }));
            }
        };
    }

    @Test
    void testHasLeadershipAsyncWithLeadershipAndGrantEventProcessed() throws Exception {
        new Context(){
            {
                this.runTestWithManuallyTriggeredEvents((ThrowingConsumer<ManuallyTriggeredScheduledExecutorService, Exception>)((ThrowingConsumer)executorService -> {
                    UUID expectedSessionID = UUID.randomUUID();
                    this.grantLeadership(expectedSessionID);
                    this.applyToBothContenderContexts((ThrowingConsumer<ContenderContext, Exception>)((ThrowingConsumer)ctx -> Assertions.assertThat((Comparable)((ContenderContext)ctx).contender.getLeaderSessionID()).isNull()));
                    executorService.trigger();
                    this.applyToBothContenderContexts((ThrowingConsumer<ContenderContext, Exception>)((ThrowingConsumer)ctx -> {
                        Assertions.assertThat((Comparable)((ContenderContext)ctx).contender.getLeaderSessionID()).isEqualTo((Object)expectedSessionID);
                        CompletableFuture validSessionFuture = this.leaderElectionService.hasLeadershipAsync(((ContenderContext)ctx).componentId, expectedSessionID);
                        CompletableFuture invalidSessionFuture = this.leaderElectionService.hasLeadershipAsync(((ContenderContext)ctx).componentId, UUID.randomUUID());
                        executorService.triggerAll();
                        FlinkAssertions.assertThatFuture((CompletableFuture)validSessionFuture).eventuallySucceeds().isEqualTo((Object)true);
                        FlinkAssertions.assertThatFuture((CompletableFuture)invalidSessionFuture).eventuallySucceeds().isEqualTo((Object)false);
                    }));
                }));
            }
        };
    }

    @Test
    void testHasLeadershipAsyncWithLeadershipLostButNoRevokeEventProcessed() throws Exception {
        new Context(){
            {
                this.runTestWithManuallyTriggeredEvents((ThrowingConsumer<ManuallyTriggeredScheduledExecutorService, Exception>)((ThrowingConsumer)executorService -> {
                    UUID expectedSessionID = UUID.randomUUID();
                    this.grantLeadership(expectedSessionID);
                    executorService.trigger();
                    this.revokeLeadership();
                    this.applyToBothContenderContexts((ThrowingConsumer<ContenderContext, Exception>)((ThrowingConsumer)ctx -> {
                        CompletableFuture validSessionFuture = this.leaderElectionService.hasLeadershipAsync(((ContenderContext)ctx).componentId, expectedSessionID);
                        CompletableFuture invalidSessionFuture = this.leaderElectionService.hasLeadershipAsync(((ContenderContext)ctx).componentId, UUID.randomUUID());
                        executorService.triggerAll();
                        ((ObjectAssert)FlinkAssertions.assertThatFuture((CompletableFuture)validSessionFuture).eventuallySucceeds().as("No operation should be handled anymore after the HA backend indicated leadership loss even if the onRevokeLeadership wasn't processed, yet, because some other process could have picked up the leadership in the meantime already based on the HA backend's decision.", new Object[0])).isEqualTo((Object)false);
                        FlinkAssertions.assertThatFuture((CompletableFuture)invalidSessionFuture).eventuallySucceeds().isEqualTo((Object)false);
                    }));
                }));
            }
        };
    }

    @Test
    void testHasLeadershipAsyncWithLeadershipLostAndRevokeEventProcessed() throws Exception {
        new Context(){
            {
                this.runTestWithSynchronousEventHandling(() -> {
                    UUID expectedSessionID = UUID.randomUUID();
                    this.grantLeadership(expectedSessionID);
                    this.revokeLeadership();
                    this.applyToBothContenderContexts((ThrowingConsumer<ContenderContext, Exception>)((ThrowingConsumer)ctx -> {
                        FlinkAssertions.assertThatFuture((CompletableFuture)this.leaderElectionService.hasLeadershipAsync(((ContenderContext)ctx).componentId, expectedSessionID)).eventuallySucceeds().isEqualTo((Object)false);
                        FlinkAssertions.assertThatFuture((CompletableFuture)this.leaderElectionService.hasLeadershipAsync(((ContenderContext)ctx).componentId, UUID.randomUUID())).eventuallySucceeds().isEqualTo((Object)false);
                    }));
                });
            }
        };
    }

    @Test
    void testHasLeadershipAsyncAfterLeaderElectionClose() throws Exception {
        new Context(){
            {
                this.runTestWithSynchronousEventHandling(() -> {
                    UUID expectedSessionID = UUID.randomUUID();
                    this.grantLeadership(expectedSessionID);
                    this.applyToBothContenderContexts((ThrowingConsumer<ContenderContext, Exception>)((ThrowingConsumer)ctx -> {
                        ((ContenderContext)ctx).leaderElection.close();
                        FlinkAssertions.assertThatFuture((CompletableFuture)this.leaderElectionService.hasLeadershipAsync(((ContenderContext)ctx).componentId, expectedSessionID)).eventuallySucceeds().isEqualTo((Object)false);
                    }));
                });
            }
        };
    }

    @Test
    void testLeaderInformationChangedIfNotBeingLeader() throws Exception {
        final AtomicReference storedLeaderInformation = new AtomicReference();
        new Context(storedLeaderInformation){
            {
                super(storedLeaderInformation2);
                this.runTestWithSynchronousEventHandling(() -> {
                    LeaderInformation differentLeaderInformation = LeaderInformation.known((UUID)UUID.randomUUID(), (String)"different-address");
                    storedLeaderInformation.set(LeaderInformationRegister.of((String)this.contenderContext0.componentId, (LeaderInformation)differentLeaderInformation));
                    this.leaderElectionService.onLeaderInformationChange(this.contenderContext0.componentId, differentLeaderInformation);
                    ((OptionalAssert)Assertions.assertThat((Optional)((LeaderInformationRegister)storedLeaderInformation.get()).forComponentId(this.contenderContext0.componentId)).as("The external storage shouldn't have been changed.", new Object[0])).hasValue((Object)differentLeaderInformation);
                });
            }
        };
    }

    @Test
    void testOnGrantLeadershipIsIgnoredAfterLeaderElectionClose() throws Exception {
        new Context(){
            {
                this.runTestWithSynchronousEventHandling(() -> {
                    this.closeLeaderElectionInBothContexts();
                    this.grantLeadership();
                    this.applyToBothContenderContexts((ThrowingConsumer<ContenderContext, Exception>)((ThrowingConsumer)ctx -> {
                        ((AbstractComparableAssert)Assertions.assertThat((Comparable)this.leaderElectionService.getLeaderSessionID(((ContenderContext)ctx).componentId)).as("The grant event shouldn't have been processed by the LeaderElectionService.", new Object[0])).isNull();
                        ((AbstractComparableAssert)Assertions.assertThat((Comparable)((ContenderContext)ctx).contender.getLeaderSessionID()).as("The grant event shouldn't have been forwarded to the contender.", new Object[0])).isNull();
                    }));
                });
            }
        };
    }

    @Test
    void testOnLeaderInformationChangeIsIgnoredAfterLeaderElectionBeingClosed() throws Exception {
        this.testLeadershipChangeEventHandlingBeingIgnoredAfterLeaderElectionClose((TriConsumer<LeaderElectionDriver.Listener, Iterable<String>, LeaderInformationRegister>)((TriConsumer)(listener, componentIds, externalStorage) -> componentIds.forEach(c -> listener.onLeaderInformationChange(c, externalStorage.forComponentIdOrEmpty(c)))));
    }

    @Test
    void testAllLeaderInformationChangeIsIgnoredAfterLeaderElectionBeingClosed() throws Exception {
        this.testLeadershipChangeEventHandlingBeingIgnoredAfterLeaderElectionClose((TriConsumer<LeaderElectionDriver.Listener, Iterable<String>, LeaderInformationRegister>)((TriConsumer)(listener, ignoredComponentIds, externalStorage) -> listener.onLeaderInformationChange(externalStorage)));
    }

    private void testLeadershipChangeEventHandlingBeingIgnoredAfterLeaderElectionClose(final TriConsumer<LeaderElectionDriver.Listener, Iterable<String>, LeaderInformationRegister> callback) throws Exception {
        final AtomicReference storedLeaderInformation = new AtomicReference();
        new Context(storedLeaderInformation){
            {
                super(storedLeaderInformation2);
                this.runTestWithSynchronousEventHandling(() -> {
                    this.grantLeadership();
                    Assertions.assertThat((Iterable)((LeaderInformationRegister)storedLeaderInformation.get()).getRegisteredComponentIds()).containsExactlyInAnyOrder((Object[])new String[]{this.contenderContext0.componentId, this.contenderContext1.componentId});
                    this.contenderContext0.leaderElection.close();
                    String otherComponentId = DefaultLeaderElectionServiceTest.createRandomComponentId();
                    LeaderInformation otherLeaderInformation = LeaderInformation.known((UUID)UUID.randomUUID(), (String)("address-for-" + otherComponentId));
                    LeaderInformationRegister registerWithUnknownContender = LeaderInformationRegister.of((String)otherComponentId, (LeaderInformation)otherLeaderInformation);
                    storedLeaderInformation.set(registerWithUnknownContender);
                    callback.accept((Object)this.leaderElectionService, Arrays.asList(this.contenderContext0.componentId, this.contenderContext1.componentId), storedLeaderInformation.get());
                    LeaderInformationRegister correctedExternalStorage = (LeaderInformationRegister)storedLeaderInformation.get();
                    ((IterableAssert)Assertions.assertThat((Iterable)correctedExternalStorage.getRegisteredComponentIds()).as("Only the still registered contender and the unknown one should have corrected its LeaderInformation.", new Object[0])).containsExactlyInAnyOrder((Object[])new String[]{this.contenderContext1.componentId, otherComponentId});
                    this.contenderContext1.leaderElection.close();
                    LeaderInformationRegister leftOverData = (LeaderInformationRegister)storedLeaderInformation.get();
                    callback.accept((Object)this.leaderElectionService, Collections.singleton(this.contenderContext1.componentId), (Object)leftOverData);
                    ((IterableAssert)Assertions.assertThat((Iterable)((LeaderInformationRegister)storedLeaderInformation.get()).getRegisteredComponentIds()).as("The following identity check does only make sense if we're not using an empty register.", new Object[0])).hasSize(1);
                    ((ObjectAssert)Assertions.assertThat(storedLeaderInformation.get()).as("The external storage shouldn't have been touched.", new Object[0])).isSameAs((Object)leftOverData);
                });
            }
        };
    }

    @Test
    void testOnRevokeLeadershipIsTriggeredAfterLeaderElectionClose() throws Exception {
        new Context(){
            {
                this.runTestWithSynchronousEventHandling(() -> {
                    this.grantLeadership();
                    UUID oldSessionId = this.leaderElectionService.getLeaderSessionID(this.contenderContext0.componentId);
                    this.applyToBothContenderContexts((ThrowingConsumer<ContenderContext, Exception>)((ThrowingConsumer)ctx -> {
                        Assertions.assertThat((Comparable)((ContenderContext)ctx).contender.getLeaderSessionID()).isEqualTo((Object)oldSessionId);
                        ((ContenderContext)ctx).leaderElection.close();
                        ((AbstractComparableAssert)Assertions.assertThat((Comparable)((ContenderContext)ctx).contender.getLeaderSessionID()).as("LeaderContender should have been revoked as part of the close call.", new Object[0])).isNull();
                    }));
                });
            }
        };
    }

    @Test
    void testOldConfirmLeaderInformationWhileHavingNewLeadership() throws Exception {
        final AtomicReference storedLeaderInformation = new AtomicReference();
        new Context(storedLeaderInformation){
            {
                super(storedLeaderInformation2);
                this.runTestWithSynchronousEventHandling(() -> {
                    UUID currentLeaderSessionId = UUID.randomUUID();
                    this.grantLeadership(currentLeaderSessionId);
                    LeaderInformationRegister initiallyStoredData = (LeaderInformationRegister)storedLeaderInformation.get();
                    this.applyToBothContenderContexts((ThrowingConsumer<ContenderContext, Exception>)((ThrowingConsumer)ctx -> {
                        LeaderInformation expectedLeaderInformation = LeaderInformation.known((UUID)currentLeaderSessionId, (String)((ContenderContext)ctx).address);
                        Assertions.assertThat((Optional)((LeaderInformationRegister)storedLeaderInformation.get()).forComponentId(((ContenderContext)ctx).componentId)).hasValue((Object)expectedLeaderInformation);
                        ((ContenderContext)ctx).leaderElection.confirmLeadershipAsync(UUID.randomUUID(), ((ContenderContext)ctx).address);
                        Assertions.assertThat((Comparable)this.leaderElectionService.getLeaderSessionID(((ContenderContext)ctx).componentId)).isEqualTo((Object)currentLeaderSessionId);
                    }));
                    ((ObjectAssert)Assertions.assertThat(storedLeaderInformation.get()).as("The leader information in the external storage shouldn't have been updated.", new Object[0])).isSameAs((Object)initiallyStoredData);
                });
            }
        };
    }

    @Test
    void testOldConfirmationWhileHavingLeadershipLost() throws Exception {
        new Context(){
            {
                this.runTestWithSynchronousEventHandling(() -> {
                    UUID currentLeaderSessionId = UUID.randomUUID();
                    this.grantLeadership(currentLeaderSessionId);
                    this.revokeLeadership();
                    this.applyToBothContenderContexts((ThrowingConsumer<ContenderContext, Exception>)((ThrowingConsumer)ctx -> {
                        ((ContenderContext)ctx).leaderElection.confirmLeadershipAsync(currentLeaderSessionId, ((ContenderContext)ctx).address);
                        Assertions.assertThat((Comparable)this.leaderElectionService.getLeaderSessionID(((ContenderContext)ctx).componentId)).isNull();
                    }));
                });
            }
        };
    }

    @Test
    void testErrorForwarding() throws Exception {
        new Context(){
            {
                this.runTestWithSynchronousEventHandling(() -> {
                    Exception testException = new Exception("test leader exception");
                    this.leaderElectionService.onError((Throwable)testException);
                    this.applyToBothContenderContexts((ThrowingConsumer<ContenderContext, Exception>)((ThrowingConsumer)contenderContext -> {
                        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)((ContenderContext)contenderContext).contender.getError()).isNotNull()).hasCause((Throwable)testException);
                        ((ContenderContext)contenderContext).contender.clearError();
                    }));
                });
            }
        };
    }

    @Test
    void testErrorIsIgnoredAfterLeaderElectionBeingClosed() throws Exception {
        new Context(){
            {
                this.runTestWithSynchronousEventHandling(() -> {
                    this.closeLeaderElectionInBothContexts();
                    Exception testException = new Exception("test leader exception");
                    this.leaderElectionService.onError((Throwable)testException);
                    this.applyToBothContenderContexts((ThrowingConsumer<ContenderContext, Exception>)((ThrowingConsumer)ctx -> ((AbstractThrowableAssert)Assertions.assertThat((Throwable)((ContenderContext)ctx).contender.getError()).as("No error should have been forwarded.", new Object[0])).isNull()));
                    ((AbstractThrowableAssert)Assertions.assertThat((Throwable)DefaultLeaderElectionServiceTest.this.fatalErrorHandlerExtension.getTestingFatalErrorHandler().getException()).as("The fallback error handler should have caught the error in this case.", new Object[0])).isEqualTo((Object)testException);
                    DefaultLeaderElectionServiceTest.this.fatalErrorHandlerExtension.getTestingFatalErrorHandler().clearError();
                });
            }
        };
    }

    @Test
    void testGrantDoesNotBlockNotifyLeaderInformationChange() throws Exception {
        this.testLeaderEventDoesNotBlockLeaderInformationChangeEventHandling((TriConsumer<LeaderElectionDriver.Listener, String, LeaderInformationRegister>)((TriConsumer)(listener, componentId, storedLeaderInformation) -> listener.onLeaderInformationChange(componentId, storedLeaderInformation.forComponentIdOrEmpty(componentId))));
    }

    @Test
    void testGrantDoesNotBlockNotifyAllKnownLeaderInformation() throws Exception {
        this.testLeaderEventDoesNotBlockLeaderInformationChangeEventHandling((TriConsumer<LeaderElectionDriver.Listener, String, LeaderInformationRegister>)((TriConsumer)(listener, componentId, storedLeaderInformation) -> listener.onLeaderInformationChange(storedLeaderInformation)));
    }

    private void testLeaderEventDoesNotBlockLeaderInformationChangeEventHandling(final TriConsumer<LeaderElectionDriver.Listener, String, LeaderInformationRegister> callback) throws Exception {
        final AtomicReference storedLeaderInformation = new AtomicReference();
        new Context(storedLeaderInformation){
            {
                super(storedLeaderInformation2);
                this.runTestWithManuallyTriggeredEvents((ThrowingConsumer<ManuallyTriggeredScheduledExecutorService, Exception>)((ThrowingConsumer)executorService -> {
                    this.grantLeadership();
                    LeaderInformation changedLeaderInformation = LeaderInformation.known((UUID)UUID.randomUUID(), (String)this.contenderContext0.address);
                    storedLeaderInformation.set(LeaderInformationRegister.of((String)this.contenderContext0.componentId, (LeaderInformation)changedLeaderInformation));
                    callback.accept((Object)this.leaderElectionService, (Object)this.contenderContext0.componentId, storedLeaderInformation.get());
                    ((AbstractBooleanAssert)Assertions.assertThat((boolean)((LeaderInformationRegister)storedLeaderInformation.get()).hasNoLeaderInformation()).as("The blocked leadership grant event shouldn't have blocked the processing of the LeaderInformation change event.", new Object[0])).isTrue();
                }));
            }
        };
    }

    @Test
    void testOnGrantLeadershipAsyncDoesNotBlock() throws Exception {
        this.testNonBlockingCall(latch -> TestingGenericLeaderContender.newBuilder().setGrantLeadershipConsumer(ignoredSessionID -> latch.awaitQuietly()).build(), (leadershipGranted, listener) -> {
            leadershipGranted.set(true);
            listener.onGrantLeadership(UUID.randomUUID());
        });
    }

    @Test
    void testOnRevokeLeadershipDoesNotBlock() throws Exception {
        this.testNonBlockingCall(latch -> TestingGenericLeaderContender.newBuilder().setRevokeLeadershipRunnable(() -> ((OneShotLatch)latch).awaitQuietly()).build(), (leadershipGranted, listener) -> {
            leadershipGranted.set(true);
            listener.onGrantLeadership(UUID.randomUUID());
            leadershipGranted.set(false);
            listener.onRevokeLeadership();
        });
    }

    private void testNonBlockingCall(Function<OneShotLatch, TestingGenericLeaderContender> contenderCreator, BiConsumer<AtomicBoolean, LeaderElectionDriver.Listener> listenerAction) throws Exception {
        OneShotLatch latch = new OneShotLatch();
        TestingGenericLeaderContender contender = contenderCreator.apply(latch);
        AtomicBoolean leadershipGranted = new AtomicBoolean(false);
        TestingLeaderElectionDriver.Factory driverFactory = new TestingLeaderElectionDriver.Factory(TestingLeaderElectionDriver.newBuilder(leadershipGranted, new AtomicReference<LeaderInformationRegister>(), new AtomicBoolean()));
        DefaultLeaderElectionService testInstance = new DefaultLeaderElectionService((LeaderElectionDriverFactory)driverFactory, (FatalErrorHandler)this.fatalErrorHandlerExtension.getTestingFatalErrorHandler());
        LeaderElection leaderElection = testInstance.createLeaderElection(DefaultLeaderElectionServiceTest.createRandomComponentId());
        leaderElection.startLeaderElection((LeaderContender)contender);
        listenerAction.accept(leadershipGranted, (LeaderElectionDriver.Listener)testInstance);
        latch.trigger();
        leaderElection.close();
        testInstance.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testNestedDeadlockInLeadershipConfirmation() throws Exception {
        AtomicReference<LeaderInformationRegister> leaderInformationStorage = new AtomicReference<LeaderInformationRegister>(LeaderInformationRegister.empty());
        try (DefaultLeaderElectionService testInstance = new DefaultLeaderElectionService(TestingLeaderElectionDriver.newBuilder(new AtomicBoolean(false), leaderInformationStorage, new AtomicBoolean(false))::build);){
            CompletableFuture confirmLeadershipFuture;
            CompletableFuture<Void> revocationFuture;
            String componentId = "test-component";
            LeaderElection leaderElection = testInstance.createLeaderElection("test-component");
            CountDownLatch contenderLockAcquireLatch = new CountDownLatch(2);
            OneShotLatch grantReceivedLatch = new OneShotLatch();
            AtomicBoolean contenderLeadership = new AtomicBoolean(false);
            TestingGenericLeaderContender leaderContender = TestingGenericLeaderContender.newBuilder().setPreLockAcquireAction(contenderLockAcquireLatch::countDown).setGrantLeadershipConsumer(ignoredSessionId -> {
                contenderLeadership.set(true);
                grantReceivedLatch.trigger();
            }).setRevokeLeadershipRunnable(() -> contenderLeadership.set(false)).build();
            leaderElection.startLeaderElection((LeaderContender)leaderContender);
            UUID leaderSessionId = UUID.randomUUID();
            testInstance.onGrantLeadership(leaderSessionId);
            grantReceivedLatch.await();
            Object object = leaderContender.getLock();
            synchronized (object) {
                revocationFuture = CompletableFuture.runAsync(() -> ((DefaultLeaderElectionService)testInstance).onRevokeLeadership());
                contenderLockAcquireLatch.await();
                confirmLeadershipFuture = leaderElection.confirmLeadershipAsync(leaderSessionId, "random-address");
            }
            FlinkAssertions.assertThatFuture(revocationFuture).eventuallySucceeds();
            FlinkAssertions.assertThatFuture((CompletableFuture)confirmLeadershipFuture).eventuallySucceeds();
            Assertions.assertThat((AtomicBoolean)contenderLeadership).isFalse();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)leaderInformationStorage.get().forComponentId("test-component").isPresent()).as("The LeaderInformation is empty because the leadership confirmation succeeded the leadership revocation which resulted in no leader information being written out to the HA backend.", new Object[0])).isFalse();
            leaderElection.close();
        }
    }

    private static String createRandomComponentId() {
        return String.format("component-id-%s", UUID.randomUUID());
    }

    private static class ContenderContext
    implements AutoCloseable {
        private final String componentId;
        private final String address;
        private final TestingContender contender;
        private LeaderElection leaderElection;

        private static ContenderContext create(int id, LeaderElectionService leaderElectionService) throws Exception {
            String randomSuffix = UUID.randomUUID().toString().substring(0, 4);
            String componentId = String.format("component-id-%d-%s", id, randomSuffix);
            String address = String.format("address-%d-%s", id, randomSuffix);
            LeaderElection leaderElection = leaderElectionService.createLeaderElection(componentId);
            TestingContender contender = new TestingContender(address, leaderElection);
            contender.startLeaderElection();
            return new ContenderContext(componentId, address, contender, leaderElection);
        }

        private ContenderContext(String componentId, String address, TestingContender contender, LeaderElection leaderElection) {
            this.componentId = componentId;
            this.address = address;
            this.contender = contender;
            this.leaderElection = leaderElection;
        }

        @Override
        public void close() throws Exception {
            this.leaderElection.close();
            this.contender.throwErrorIfPresent();
        }
    }

    private class Context {
        private final TestingLeaderElectionDriver.Factory driverFactory;
        private final AtomicBoolean leadershipGranted;
        DefaultLeaderElectionService leaderElectionService;
        TestingLeaderElectionDriver testingLeaderElectionDriver;
        ContenderContext contenderContext0;
        ContenderContext contenderContext1;

        private Context() {
            this(new AtomicBoolean(false), new AtomicReference<LeaderInformationRegister>());
        }

        private Context(AtomicReference<LeaderInformationRegister> storedLeaderInformation) {
            this(new AtomicBoolean(false), storedLeaderInformation);
        }

        private Context(AtomicBoolean leadershipGranted, AtomicReference<LeaderInformationRegister> storedLeaderInformation) {
            this(leadershipGranted, TestingLeaderElectionDriver.newBuilder(leadershipGranted, storedLeaderInformation, new AtomicBoolean()));
        }

        private Context(AtomicBoolean leadershipGranted, TestingLeaderElectionDriver.Builder driverBuilder) {
            this.leadershipGranted = leadershipGranted;
            this.driverFactory = new TestingLeaderElectionDriver.Factory(driverBuilder);
        }

        void grantLeadership() {
            this.grantLeadership(UUID.randomUUID());
        }

        void grantLeadership(UUID leaderSessionID) {
            this.leadershipGranted.set(true);
            this.leaderElectionService.onGrantLeadership(leaderSessionID);
        }

        void revokeLeadership() {
            this.leadershipGranted.set(false);
            this.leaderElectionService.onRevokeLeadership();
        }

        void closeLeaderElectionInBothContexts() throws Exception {
            this.applyToBothContenderContexts((ThrowingConsumer<ContenderContext, Exception>)((ThrowingConsumer)ctx -> ((ContenderContext)ctx).leaderElection.close()));
        }

        void applyToBothContenderContexts(ThrowingConsumer<ContenderContext, Exception> callback) throws Exception {
            callback.accept((Object)this.contenderContext0);
            callback.accept((Object)this.contenderContext1);
        }

        void runTestWithSynchronousEventHandling(RunnableWithException testMethod) throws Exception {
            this.runTest(testMethod, Executors.newDirectExecutorService());
        }

        void runTestWithManuallyTriggeredEvents(ThrowingConsumer<ManuallyTriggeredScheduledExecutorService, Exception> testMethod) throws Exception {
            ManuallyTriggeredScheduledExecutorService executorService = new ManuallyTriggeredScheduledExecutorService();
            this.runTest(() -> testMethod.accept((Object)executorService), executorService);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void runTest(RunnableWithException testMethod, ExecutorService leaderEventOperationExecutor) throws Exception {
            try (DefaultLeaderElectionService localLeaderElectionService = new DefaultLeaderElectionService((LeaderElectionDriverFactory)this.driverFactory, (FatalErrorHandler)DefaultLeaderElectionServiceTest.this.fatalErrorHandlerExtension.getTestingFatalErrorHandler(), leaderEventOperationExecutor);){
                this.leaderElectionService = localLeaderElectionService;
                try (ContenderContext localContenderContext0 = ContenderContext.create(0, (LeaderElectionService)this.leaderElectionService);
                     ContenderContext localContenderContext1 = ContenderContext.create(1, (LeaderElectionService)this.leaderElectionService);){
                    this.contenderContext0 = localContenderContext0;
                    this.contenderContext1 = localContenderContext1;
                    this.testingLeaderElectionDriver = this.driverFactory.assertAndGetOnlyCreatedDriver();
                    testMethod.run();
                }
            }
            finally {
                if (this.testingLeaderElectionDriver != null) {
                    this.testingLeaderElectionDriver.close();
                }
            }
        }
    }
}

