/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.netty;

import org.apache.flink.runtime.io.network.netty.ByteBufUtils;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.apache.flink.shaded.netty4.io.netty.buffer.Unpooled;
import org.assertj.core.api.AbstractByteAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ByteBufUtilsTest {
    private static final byte ACCUMULATION_BYTE = 125;
    private static final byte NON_ACCUMULATION_BYTE = 35;

    ByteBufUtilsTest() {
    }

    @Test
    void testAccumulateWithoutCopy() {
        int sourceLength = 128;
        int sourceReaderIndex = 32;
        int expectedAccumulationSize = 16;
        ByteBuf src = ByteBufUtilsTest.createSourceBuffer(sourceLength, sourceReaderIndex, expectedAccumulationSize);
        ByteBuf target = Unpooled.buffer((int)expectedAccumulationSize);
        ByteBuf accumulated = ByteBufUtils.accumulate((ByteBuf)target, (ByteBuf)src, (int)expectedAccumulationSize, (int)target.readableBytes());
        Assertions.assertThat((Comparable)accumulated).isSameAs((Object)src);
        Assertions.assertThat((int)src.readerIndex()).isEqualTo(sourceReaderIndex);
        ByteBufUtilsTest.verifyBufferContent(src, sourceReaderIndex, expectedAccumulationSize);
    }

    @Test
    void testAccumulateWithCopy() {
        int sourceLength = 128;
        int firstSourceReaderIndex = 32;
        int secondSourceReaderIndex = 0;
        int expectedAccumulationSize = 128;
        int firstAccumulationSize = sourceLength - firstSourceReaderIndex;
        int secondAccumulationSize = expectedAccumulationSize - firstAccumulationSize;
        ByteBuf firstSource = ByteBufUtilsTest.createSourceBuffer(sourceLength, firstSourceReaderIndex, firstAccumulationSize);
        ByteBuf secondSource = ByteBufUtilsTest.createSourceBuffer(sourceLength, secondSourceReaderIndex, secondAccumulationSize);
        ByteBuf target = Unpooled.buffer((int)expectedAccumulationSize);
        ByteBuf accumulated = ByteBufUtils.accumulate((ByteBuf)target, (ByteBuf)firstSource, (int)expectedAccumulationSize, (int)target.readableBytes());
        Assertions.assertThat((Comparable)accumulated).isNull();
        Assertions.assertThat((int)firstSource.readerIndex()).isEqualTo(sourceLength);
        Assertions.assertThat((int)target.readableBytes()).isEqualTo(firstAccumulationSize);
        accumulated = ByteBufUtils.accumulate((ByteBuf)target, (ByteBuf)secondSource, (int)expectedAccumulationSize, (int)target.readableBytes());
        Assertions.assertThat((Comparable)accumulated).isSameAs((Object)target);
        Assertions.assertThat((int)secondSource.readerIndex()).isEqualTo(secondSourceReaderIndex + secondAccumulationSize);
        Assertions.assertThat((int)target.readableBytes()).isEqualTo(expectedAccumulationSize);
        ByteBufUtilsTest.verifyBufferContent(accumulated, 0, expectedAccumulationSize);
    }

    private static ByteBuf createSourceBuffer(int size, int readerIndex, int accumulationSize) {
        int i;
        ByteBuf buf = Unpooled.buffer((int)size);
        for (i = 0; i < readerIndex; ++i) {
            buf.writeByte(35);
        }
        for (i = readerIndex; i < readerIndex + accumulationSize; ++i) {
            buf.writeByte(125);
        }
        for (i = readerIndex + accumulationSize; i < size; ++i) {
            buf.writeByte(35);
        }
        buf.readerIndex(readerIndex);
        return buf;
    }

    private static void verifyBufferContent(ByteBuf buf, int start, int length) {
        for (int i = 0; i < length; ++i) {
            byte b = buf.getByte(start + i);
            ((AbstractByteAssert)Assertions.assertThat((byte)b).withFailMessage("The byte at position %d is not right.", new Object[]{start + i})).isEqualTo((byte)125);
        }
    }
}

