/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.flink.runtime.io.network.partition.PartitionRequestListener;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannelID;

public class PartitionRequestListenerManager {
    private final Map<InputChannelID, PartitionRequestListener> listeners = new HashMap<InputChannelID, PartitionRequestListener>();

    public Collection<PartitionRequestListener> getPartitionRequestListeners() {
        return this.listeners.values();
    }

    public void remove(InputChannelID receiverId) {
        this.listeners.remove((Object)receiverId);
    }

    public boolean isEmpty() {
        return this.listeners.isEmpty();
    }

    public void registerListener(PartitionRequestListener listener) {
        PartitionRequestListener previous = this.listeners.put(listener.getReceiverId(), listener);
        if (previous != null) {
            throw new IllegalStateException("Partition request listener with receiver " + (Object)((Object)listener.getReceiverId()) + " has been registered.");
        }
    }

    public void removeExpiration(long now, long timeout, Collection<PartitionRequestListener> timeoutListeners) {
        Iterator<Map.Entry<InputChannelID, PartitionRequestListener>> iterator = this.listeners.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<InputChannelID, PartitionRequestListener> entry = iterator.next();
            PartitionRequestListener partitionRequestListener = entry.getValue();
            if (now - partitionRequestListener.getCreateTimestamp() <= timeout) continue;
            timeoutListeners.add(partitionRequestListener);
            iterator.remove();
        }
    }
}

