/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adapter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.scheduler.adapter.DefaultResultPartition;
import org.apache.flink.runtime.scheduler.strategy.ConsumerVertexGroup;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.runtime.scheduler.strategy.ResultPartitionState;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class DefaultResultPartitionTest {
    private static final TestResultPartitionStateSupplier resultPartitionState = new TestResultPartitionStateSupplier();
    private final IntermediateResultPartitionID resultPartitionId = new IntermediateResultPartitionID();
    private final IntermediateDataSetID intermediateResultId = new IntermediateDataSetID();
    private DefaultResultPartition resultPartition;
    private final Map<IntermediateResultPartitionID, List<ConsumerVertexGroup>> consumerVertexGroups = new HashMap<IntermediateResultPartitionID, List<ConsumerVertexGroup>>();

    DefaultResultPartitionTest() {
    }

    @BeforeEach
    void setUp() {
        this.resultPartition = new DefaultResultPartition(this.resultPartitionId, this.intermediateResultId, ResultPartitionType.BLOCKING, (Supplier)resultPartitionState, () -> this.consumerVertexGroups.computeIfAbsent(this.resultPartitionId, ignored -> new ArrayList()), () -> {
            throw new UnsupportedOperationException();
        });
    }

    @Test
    void testGetPartitionState() {
        for (ResultPartitionState state : ResultPartitionState.values()) {
            resultPartitionState.setResultPartitionState(state);
            Assertions.assertThat((Comparable)this.resultPartition.getState()).isEqualTo((Object)state);
        }
    }

    @Test
    void testGetConsumerVertexGroup() {
        Assertions.assertThat((List)this.resultPartition.getConsumerVertexGroups()).isEmpty();
        ExecutionVertexID executionVertexId = new ExecutionVertexID(new JobVertexID(), 0);
        this.consumerVertexGroups.put(this.resultPartition.getId(), Collections.singletonList(ConsumerVertexGroup.fromSingleVertex((ExecutionVertexID)executionVertexId, (ResultPartitionType)this.resultPartition.getResultType())));
        Assertions.assertThat((List)this.resultPartition.getConsumerVertexGroups()).isNotEmpty();
        Assertions.assertThat((Iterable)((Iterable)this.resultPartition.getConsumerVertexGroups().get(0))).contains((Object[])new ExecutionVertexID[]{executionVertexId});
    }

    private static class TestResultPartitionStateSupplier
    implements Supplier<ResultPartitionState> {
        private ResultPartitionState resultPartitionState;

        private TestResultPartitionStateSupplier() {
        }

        void setResultPartitionState(ResultPartitionState state) {
            this.resultPartitionState = state;
        }

        @Override
        public ResultPartitionState get() {
            return this.resultPartitionState;
        }
    }
}

