/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.jobmanager.slots.TaskManagerGateway;
import org.apache.flink.runtime.jobmaster.LogicalSlot;
import org.apache.flink.runtime.jobmaster.SlotOwner;
import org.apache.flink.runtime.jobmaster.TestingLogicalSlot;
import org.apache.flink.runtime.jobmaster.TestingLogicalSlotBuilder;
import org.apache.flink.runtime.scheduler.ExecutionSlotAllocator;
import org.apache.flink.runtime.scheduler.ExecutionSlotAssignment;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.util.Preconditions;

public class TestExecutionSlotAllocator
implements ExecutionSlotAllocator,
SlotOwner {
    private final Map<ExecutionAttemptID, ExecutionSlotAssignment> pendingRequests = new HashMap<ExecutionAttemptID, ExecutionSlotAssignment>();
    private final TestingLogicalSlotBuilder logicalSlotBuilder;
    private boolean autoCompletePendingRequests = true;
    private boolean completePendingRequestsWithReturnedSlots = false;
    private final List<LogicalSlot> returnedSlots = new ArrayList<LogicalSlot>();

    public TestExecutionSlotAllocator() {
        this(new TestingLogicalSlotBuilder());
    }

    public TestExecutionSlotAllocator(TaskManagerGateway taskManagerGateway) {
        this(new TestingLogicalSlotBuilder().setTaskManagerGateway(taskManagerGateway));
    }

    public TestExecutionSlotAllocator(TestingLogicalSlotBuilder logicalSlotBuilder) {
        this.logicalSlotBuilder = logicalSlotBuilder;
    }

    public Map<ExecutionAttemptID, ExecutionSlotAssignment> allocateSlotsFor(List<ExecutionAttemptID> executionAttemptIds) {
        Map<ExecutionAttemptID, ExecutionSlotAssignment> executionSlotAssignments = this.createExecutionSlotAssignments(executionAttemptIds);
        this.registerPendingRequests(executionSlotAssignments);
        this.maybeCompletePendingRequests();
        return executionSlotAssignments;
    }

    private Map<ExecutionAttemptID, ExecutionSlotAssignment> createExecutionSlotAssignments(List<ExecutionAttemptID> executionAttemptIds) {
        HashMap<ExecutionAttemptID, ExecutionSlotAssignment> result = new HashMap<ExecutionAttemptID, ExecutionSlotAssignment>();
        for (ExecutionAttemptID executionAttemptId : executionAttemptIds) {
            CompletableFuture logicalSlotFuture = new CompletableFuture();
            result.put(executionAttemptId, new ExecutionSlotAssignment(executionAttemptId, logicalSlotFuture));
        }
        return result;
    }

    private void registerPendingRequests(Map<ExecutionAttemptID, ExecutionSlotAssignment> executionSlotAssignments) {
        this.pendingRequests.putAll(executionSlotAssignments);
    }

    private void maybeCompletePendingRequests() {
        if (this.autoCompletePendingRequests) {
            this.completePendingRequests();
        }
    }

    public void completePendingRequests() {
        ArrayList<ExecutionAttemptID> executionIds = new ArrayList<ExecutionAttemptID>(this.pendingRequests.keySet());
        executionIds.forEach(this::completePendingRequest);
    }

    public LogicalSlot completePendingRequest(ExecutionAttemptID executionAttemptId) {
        TestingLogicalSlot slot = this.logicalSlotBuilder.setSlotOwner(this).createTestingLogicalSlot();
        ExecutionSlotAssignment executionSlotAssignment = this.removePendingRequest(executionAttemptId);
        Preconditions.checkState((executionSlotAssignment != null ? 1 : 0) != 0);
        executionSlotAssignment.getLogicalSlotFuture().complete(slot);
        return slot;
    }

    public LogicalSlot completePendingRequest(ExecutionVertexID executionVertexId) {
        return this.completePendingRequest(this.findExecutionIdByVertexId(executionVertexId));
    }

    private ExecutionSlotAssignment removePendingRequest(ExecutionAttemptID executionAttemptId) {
        return this.pendingRequests.remove(executionAttemptId);
    }

    public void timeoutPendingRequests() {
        ArrayList<ExecutionAttemptID> executionIds = new ArrayList<ExecutionAttemptID>(this.pendingRequests.keySet());
        executionIds.forEach(this::timeoutPendingRequest);
    }

    public void timeoutPendingRequest(ExecutionAttemptID executionAttemptId) {
        ExecutionSlotAssignment slotVertexAssignment = this.removePendingRequest(executionAttemptId);
        Preconditions.checkState((slotVertexAssignment != null ? 1 : 0) != 0);
        slotVertexAssignment.getLogicalSlotFuture().completeExceptionally(new TimeoutException());
    }

    public void timeoutPendingRequest(ExecutionVertexID executionVertexId) {
        this.timeoutPendingRequest(this.findExecutionIdByVertexId(executionVertexId));
    }

    private ExecutionAttemptID findExecutionIdByVertexId(ExecutionVertexID executionVertexId) {
        ArrayList<ExecutionAttemptID> executionIds = new ArrayList<ExecutionAttemptID>();
        for (ExecutionAttemptID executionAttemptId : this.pendingRequests.keySet()) {
            if (!executionAttemptId.getExecutionVertexId().equals((Object)executionVertexId)) continue;
            executionIds.add(executionAttemptId);
        }
        Preconditions.checkState((executionIds.size() == 1 ? 1 : 0) != 0, (Object)"It is expected to find one and only one ExecutionAttemptID of the given ExecutionVertexID.");
        return (ExecutionAttemptID)executionIds.get(0);
    }

    public void enableAutoCompletePendingRequests() {
        this.autoCompletePendingRequests = true;
    }

    public void disableAutoCompletePendingRequests() {
        this.autoCompletePendingRequests = false;
    }

    public void enableCompletePendingRequestsWithReturnedSlots() {
        this.completePendingRequestsWithReturnedSlots = true;
    }

    public void cancel(ExecutionAttemptID executionAttemptId) {
        ExecutionSlotAssignment executionSlotAssignment = this.removePendingRequest(executionAttemptId);
        if (executionSlotAssignment != null) {
            executionSlotAssignment.getLogicalSlotFuture().cancel(false);
        }
    }

    public void returnLogicalSlot(LogicalSlot logicalSlot) {
        this.returnedSlots.add(logicalSlot);
        if (this.completePendingRequestsWithReturnedSlots && this.pendingRequests.size() > 0) {
            TestingLogicalSlot slot = this.logicalSlotBuilder.setSlotOwner(this).createTestingLogicalSlot();
            ExecutionSlotAssignment executionSlotAssignment = this.pendingRequests.remove(this.pendingRequests.keySet().stream().findAny().get());
            executionSlotAssignment.getLogicalSlotFuture().complete(slot);
        }
    }

    public List<LogicalSlot> getReturnedSlots() {
        return new ArrayList<LogicalSlot>(this.returnedSlots);
    }

    public TestingLogicalSlotBuilder getLogicalSlotBuilder() {
        return this.logicalSlotBuilder;
    }

    public Map<ExecutionAttemptID, ExecutionSlotAssignment> getPendingRequests() {
        return Collections.unmodifiableMap(this.pendingRequests);
    }
}

