/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rpc;

import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.core.testutils.OneShotLatch;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.rpc.FencedRpcEndpoint;
import org.apache.flink.runtime.rpc.FencedRpcGateway;
import org.apache.flink.runtime.rpc.RpcEndpoint;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.RpcTimeout;
import org.apache.flink.runtime.rpc.RpcUtils;
import org.apache.flink.runtime.rpc.TestingRpcService;
import org.apache.flink.runtime.rpc.exceptions.FencingTokenException;
import org.apache.flink.runtime.rpc.exceptions.RpcRuntimeException;
import org.apache.flink.util.ExceptionUtils;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

class FencedRpcEndpointTest {
    private static final Time timeout = Time.seconds((long)10L);
    private static RpcService rpcService;

    FencedRpcEndpointTest() {
    }

    @BeforeAll
    static void setup() {
        rpcService = new TestingRpcService();
    }

    @AfterAll
    static void teardown() throws ExecutionException, InterruptedException, TimeoutException {
        if (rpcService != null) {
            RpcUtils.terminateRpcService((RpcService[])new RpcService[]{rpcService});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testFencing() throws Exception {
        UUID fencingToken = UUID.randomUUID();
        UUID wrongFencingToken = UUID.randomUUID();
        String value = "barfoo";
        FencedTestingEndpoint fencedTestingEndpoint = new FencedTestingEndpoint(rpcService, "barfoo", fencingToken);
        try {
            fencedTestingEndpoint.start();
            FencedTestingGateway properFencedGateway = (FencedTestingGateway)rpcService.connect(fencedTestingEndpoint.getAddress(), (Serializable)fencingToken, FencedTestingGateway.class).get(timeout.toMilliseconds(), TimeUnit.MILLISECONDS);
            FencedTestingGateway wronglyFencedGateway = (FencedTestingGateway)rpcService.connect(fencedTestingEndpoint.getAddress(), (Serializable)wrongFencingToken, FencedTestingGateway.class).get(timeout.toMilliseconds(), TimeUnit.MILLISECONDS);
            Assertions.assertThat((String)properFencedGateway.foobar(timeout).get(timeout.toMilliseconds(), TimeUnit.MILLISECONDS)).isEqualTo("barfoo");
            try {
                wronglyFencedGateway.foobar(timeout).get(timeout.toMilliseconds(), TimeUnit.MILLISECONDS);
                Fail.fail((String)"This should fail since we have the wrong fencing token.");
            }
            catch (ExecutionException e) {
                Assertions.assertThat((Throwable)ExceptionUtils.stripExecutionException((Throwable)e)).isInstanceOf(FencingTokenException.class);
            }
        }
        catch (Throwable throwable) {
            RpcUtils.terminateRpcEndpoint((RpcEndpoint[])new RpcEndpoint[]{fencedTestingEndpoint});
            fencedTestingEndpoint.validateResourceClosed();
            throw throwable;
        }
        RpcUtils.terminateRpcEndpoint((RpcEndpoint[])new RpcEndpoint[]{fencedTestingEndpoint});
        fencedTestingEndpoint.validateResourceClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testUnfencedRemoteGateway() throws Exception {
        UUID initialFencingToken = UUID.randomUUID();
        String value = "foobar";
        FencedTestingEndpoint fencedTestingEndpoint = new FencedTestingEndpoint(rpcService, "foobar", initialFencingToken);
        try {
            fencedTestingEndpoint.start();
            FencedTestingGateway unfencedGateway = (FencedTestingGateway)rpcService.connect(fencedTestingEndpoint.getAddress(), FencedTestingGateway.class).get(timeout.toMilliseconds(), TimeUnit.MILLISECONDS);
            try {
                unfencedGateway.foobar(timeout).get(timeout.toMilliseconds(), TimeUnit.MILLISECONDS);
                Fail.fail((String)"This should have failed because we have an unfenced gateway.");
            }
            catch (ExecutionException e) {
                Assertions.assertThat((Throwable)ExceptionUtils.stripExecutionException((Throwable)e)).isInstanceOf(RpcRuntimeException.class);
            }
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((FencedTestingGateway)unfencedGateway).getFencingToken()).withFailMessage("We should not be able to call getFencingToken on an unfenced gateway.", new Object[0])).isInstanceOf(UnsupportedOperationException.class);
        }
        catch (Throwable throwable) {
            RpcUtils.terminateRpcEndpoint((RpcEndpoint[])new RpcEndpoint[]{fencedTestingEndpoint});
            fencedTestingEndpoint.validateResourceClosed();
            throw throwable;
        }
        RpcUtils.terminateRpcEndpoint((RpcEndpoint[])new RpcEndpoint[]{fencedTestingEndpoint});
        fencedTestingEndpoint.validateResourceClosed();
    }

    private static class FencedTestingEndpoint
    extends FencedRpcEndpoint<UUID>
    implements FencedTestingGateway {
        private final OneShotLatch computationLatch = new OneShotLatch();
        private final String value;

        protected FencedTestingEndpoint(RpcService rpcService, String value, UUID initialFencingToken) {
            super(rpcService, (Serializable)initialFencingToken);
            this.value = value;
        }

        @Override
        public CompletableFuture<String> foobar(Time timeout) {
            return CompletableFuture.completedFuture(this.value);
        }

        @Override
        public CompletableFuture<Acknowledge> triggerComputationLatch(Time timeout) {
            this.computationLatch.trigger();
            return CompletableFuture.completedFuture(Acknowledge.get());
        }
    }

    public static interface FencedTestingGateway
    extends FencedRpcGateway<UUID> {
        public CompletableFuture<String> foobar(@RpcTimeout Time var1);

        public CompletableFuture<Acknowledge> triggerComputationLatch(@RpcTimeout Time var1);
    }
}

