/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.leaderelection;

import java.util.UUID;
import org.apache.flink.runtime.leaderelection.LeaderContender;
import org.apache.flink.runtime.leaderelection.LeaderElection;
import org.apache.flink.runtime.leaderelection.LeaderInformation;
import org.apache.flink.runtime.leaderelection.TestingLeaderBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestingContender
extends TestingLeaderBase
implements LeaderContender {
    private static final Logger LOG = LoggerFactory.getLogger(TestingContender.class);
    private final String address;
    private final LeaderElection leaderElection;
    private UUID leaderSessionID = null;

    public TestingContender(String address, LeaderElection leaderElection) {
        this.address = address;
        this.leaderElection = leaderElection;
    }

    public void startLeaderElection() throws Exception {
        this.leaderElection.startLeaderElection((LeaderContender)this);
    }

    public void grantLeadership(UUID leaderSessionID) {
        LOG.debug("Was granted leadership with session ID {}.", (Object)leaderSessionID);
        this.leaderSessionID = leaderSessionID;
        this.leaderElection.confirmLeadership(leaderSessionID, this.address);
        this.leaderEventQueue.offer(LeaderInformation.known((UUID)leaderSessionID, (String)this.address));
    }

    public void revokeLeadership() {
        LOG.debug("Was revoked leadership. Old session ID {}.", (Object)this.leaderSessionID);
        this.leaderSessionID = null;
        this.leaderEventQueue.offer(LeaderInformation.empty());
    }

    public void handleError(Exception exception) {
        super.handleError(exception);
    }

    public UUID getLeaderSessionID() {
        return this.leaderSessionID;
    }
}

