/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid;

import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.flink.runtime.io.network.partition.hybrid.BufferIndexAndChannel;
import org.apache.flink.runtime.io.network.partition.hybrid.HsSpillingInfoProvider;
import org.apache.flink.runtime.io.network.partition.hybrid.HsSpillingStrategy;

public class TestingSpillingStrategy
implements HsSpillingStrategy {
    private final BiFunction<Integer, Integer, Optional<HsSpillingStrategy.Decision>> onMemoryUsageChangedFunction;
    private final BiFunction<Integer, Integer, Optional<HsSpillingStrategy.Decision>> onBufferFinishedFunction;
    private final Function<BufferIndexAndChannel, Optional<HsSpillingStrategy.Decision>> onBufferConsumedFunction;
    private final Function<HsSpillingInfoProvider, HsSpillingStrategy.Decision> decideActionWithGlobalInfoFunction;
    private final Function<HsSpillingInfoProvider, HsSpillingStrategy.Decision> onResultPartitionClosedFunction;

    private TestingSpillingStrategy(BiFunction<Integer, Integer, Optional<HsSpillingStrategy.Decision>> onMemoryUsageChangedFunction, BiFunction<Integer, Integer, Optional<HsSpillingStrategy.Decision>> onBufferFinishedFunction, Function<BufferIndexAndChannel, Optional<HsSpillingStrategy.Decision>> onBufferConsumedFunction, Function<HsSpillingInfoProvider, HsSpillingStrategy.Decision> decideActionWithGlobalInfoFunction, Function<HsSpillingInfoProvider, HsSpillingStrategy.Decision> onResultPartitionClosedFunction) {
        this.onMemoryUsageChangedFunction = onMemoryUsageChangedFunction;
        this.onBufferFinishedFunction = onBufferFinishedFunction;
        this.onBufferConsumedFunction = onBufferConsumedFunction;
        this.decideActionWithGlobalInfoFunction = decideActionWithGlobalInfoFunction;
        this.onResultPartitionClosedFunction = onResultPartitionClosedFunction;
    }

    public Optional<HsSpillingStrategy.Decision> onMemoryUsageChanged(int numTotalRequestedBuffers, int currentPoolSize) {
        return this.onMemoryUsageChangedFunction.apply(numTotalRequestedBuffers, currentPoolSize);
    }

    public Optional<HsSpillingStrategy.Decision> onBufferFinished(int numTotalUnSpillBuffers, int currentPoolSize) {
        return this.onBufferFinishedFunction.apply(numTotalUnSpillBuffers, currentPoolSize);
    }

    public Optional<HsSpillingStrategy.Decision> onBufferConsumed(BufferIndexAndChannel consumedBuffer) {
        return this.onBufferConsumedFunction.apply(consumedBuffer);
    }

    public HsSpillingStrategy.Decision decideActionWithGlobalInfo(HsSpillingInfoProvider spillingInfoProvider) {
        return this.decideActionWithGlobalInfoFunction.apply(spillingInfoProvider);
    }

    public HsSpillingStrategy.Decision onResultPartitionClosed(HsSpillingInfoProvider spillingInfoProvider) {
        return this.onResultPartitionClosedFunction.apply(spillingInfoProvider);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private BiFunction<Integer, Integer, Optional<HsSpillingStrategy.Decision>> onMemoryUsageChangedFunction = (ignore1, ignore2) -> Optional.of(HsSpillingStrategy.Decision.NO_ACTION);
        private BiFunction<Integer, Integer, Optional<HsSpillingStrategy.Decision>> onBufferFinishedFunction = (ignore1, ignore2) -> Optional.of(HsSpillingStrategy.Decision.NO_ACTION);
        private Function<BufferIndexAndChannel, Optional<HsSpillingStrategy.Decision>> onBufferConsumedFunction = ignore -> Optional.of(HsSpillingStrategy.Decision.NO_ACTION);
        private Function<HsSpillingInfoProvider, HsSpillingStrategy.Decision> decideActionWithGlobalInfoFunction = ignore -> HsSpillingStrategy.Decision.NO_ACTION;
        private Function<HsSpillingInfoProvider, HsSpillingStrategy.Decision> onResultPartitionClosedFunction = ignore -> HsSpillingStrategy.Decision.NO_ACTION;

        private Builder() {
        }

        public Builder setOnMemoryUsageChangedFunction(BiFunction<Integer, Integer, Optional<HsSpillingStrategy.Decision>> onMemoryUsageChangedFunction) {
            this.onMemoryUsageChangedFunction = onMemoryUsageChangedFunction;
            return this;
        }

        public Builder setOnBufferFinishedFunction(BiFunction<Integer, Integer, Optional<HsSpillingStrategy.Decision>> onBufferFinishedFunction) {
            this.onBufferFinishedFunction = onBufferFinishedFunction;
            return this;
        }

        public Builder setOnBufferConsumedFunction(Function<BufferIndexAndChannel, Optional<HsSpillingStrategy.Decision>> onBufferConsumedFunction) {
            this.onBufferConsumedFunction = onBufferConsumedFunction;
            return this;
        }

        public Builder setDecideActionWithGlobalInfoFunction(Function<HsSpillingInfoProvider, HsSpillingStrategy.Decision> decideActionWithGlobalInfoFunction) {
            this.decideActionWithGlobalInfoFunction = decideActionWithGlobalInfoFunction;
            return this;
        }

        public Builder setOnResultPartitionClosedFunction(Function<HsSpillingInfoProvider, HsSpillingStrategy.Decision> onResultPartitionClosedFunction) {
            this.onResultPartitionClosedFunction = onResultPartitionClosedFunction;
            return this;
        }

        public TestingSpillingStrategy build() {
            return new TestingSpillingStrategy(this.onMemoryUsageChangedFunction, this.onBufferFinishedFunction, this.onBufferConsumedFunction, this.decideActionWithGlobalInfoFunction, this.onResultPartitionClosedFunction);
        }
    }
}

