/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.flink.runtime.io.network.partition.hybrid.BufferIndexAndChannel;
import org.apache.flink.runtime.io.network.partition.hybrid.HsSpillingStrategyUtils;
import org.apache.flink.runtime.io.network.partition.hybrid.HybridShuffleTestUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class HsSpillingStrategyUtilsTest {
    HsSpillingStrategyUtilsTest() {
    }

    @Test
    void testGetBuffersByConsumptionPriorityInOrderEmptyExpectedSize() {
        TreeMap<Integer, Deque<BufferIndexAndChannel>> subpartitionToAllBuffers = new TreeMap<Integer, Deque<BufferIndexAndChannel>>();
        subpartitionToAllBuffers.put(0, HybridShuffleTestUtils.createBufferIndexAndChannelsDeque(0, 0, 1));
        subpartitionToAllBuffers.put(1, HybridShuffleTestUtils.createBufferIndexAndChannelsDeque(1, 2, 4));
        TreeMap buffersByConsumptionPriorityInOrder = HsSpillingStrategyUtils.getBuffersByConsumptionPriorityInOrder(Arrays.asList(0, 1), subpartitionToAllBuffers, (int)0);
        Assertions.assertThat((Map)buffersByConsumptionPriorityInOrder).isEmpty();
    }

    @Test
    void testGetBuffersByConsumptionPriorityInOrder() {
        boolean subpartition1 = false;
        boolean subpartition2 = true;
        int progress1 = 10;
        int progress2 = 20;
        TreeMap<Integer, ArrayDeque<BufferIndexAndChannel>> subpartitionBuffers = new TreeMap<Integer, ArrayDeque<BufferIndexAndChannel>>();
        List<BufferIndexAndChannel> subpartitionBuffers1 = HybridShuffleTestUtils.createBufferIndexAndChannelsList(0, 10, 12, 16);
        List<BufferIndexAndChannel> subpartitionBuffers2 = HybridShuffleTestUtils.createBufferIndexAndChannelsList(1, 21, 22, 25);
        subpartitionBuffers.put(0, new ArrayDeque<BufferIndexAndChannel>(subpartitionBuffers1));
        subpartitionBuffers.put(1, new ArrayDeque<BufferIndexAndChannel>(subpartitionBuffers2));
        TreeMap buffersByConsumptionPriorityInOrder = HsSpillingStrategyUtils.getBuffersByConsumptionPriorityInOrder(Arrays.asList(10, 20), subpartitionBuffers, (int)5);
        Assertions.assertThat((Map)buffersByConsumptionPriorityInOrder).hasSize(2);
        Assertions.assertThat((List)((List)buffersByConsumptionPriorityInOrder.get(0))).isEqualTo(subpartitionBuffers1.subList(1, 3));
        Assertions.assertThat((List)((List)buffersByConsumptionPriorityInOrder.get(1))).isEqualTo(subpartitionBuffers2.subList(0, 3));
    }
}

