/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.io.Serializable;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.runtime.executiongraph.ErrorInfo;
import org.apache.flink.testutils.ClassLoaderUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ErrorInfoTest {
    ErrorInfoTest() {
    }

    @Test
    void testSerializationWithExceptionOutsideClassLoader() throws Exception {
        ErrorInfo error = new ErrorInfo((Throwable)new ExceptionWithCustomClassLoader(), System.currentTimeMillis());
        ErrorInfo copy = (ErrorInfo)CommonTestUtils.createCopySerializable((Serializable)error);
        Assertions.assertThat((long)copy.getTimestamp()).isEqualTo(error.getTimestamp());
        Assertions.assertThat((String)copy.getExceptionAsString()).isEqualTo(error.getExceptionAsString());
        Assertions.assertThat((String)copy.getException().getMessage()).isEqualTo(error.getException().getMessage());
    }

    private static final class ExceptionWithCustomClassLoader
    extends Exception {
        private static final long serialVersionUID = 42L;
        private final Serializable outOfClassLoader = (Serializable)ClassLoaderUtils.createSerializableObjectFromNewClassLoader().getObject();

        public ExceptionWithCustomClassLoader() {
            super("tada");
        }
    }
}

