/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.deployment;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.apache.flink.runtime.deployment.TaskDeploymentDescriptor;
import org.apache.flink.runtime.deployment.TaskDeploymentDescriptorFactory;
import org.apache.flink.runtime.executiongraph.IntermediateResultPartition;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.scheduler.strategy.ConsumedPartitionGroup;
import org.apache.flink.runtime.shuffle.ShuffleDescriptor;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.FunctionWithException;

public class CachedShuffleDescriptors {
    private final List<TaskDeploymentDescriptor.MaybeOffloaded<TaskDeploymentDescriptorFactory.ShuffleDescriptorAndIndex[]>> serializedShuffleDescriptors;
    private final Queue<TaskDeploymentDescriptorFactory.ShuffleDescriptorAndIndex> toBeSerialized;
    private final Map<IntermediateResultPartitionID, Integer> resultPartitionIdToIndex = new HashMap<IntermediateResultPartitionID, Integer>();

    public CachedShuffleDescriptors(ConsumedPartitionGroup consumedPartitionGroup, TaskDeploymentDescriptorFactory.ShuffleDescriptorAndIndex[] shuffleDescriptors) {
        int index = 0;
        for (IntermediateResultPartitionID resultPartitionID : consumedPartitionGroup) {
            this.resultPartitionIdToIndex.put(resultPartitionID, index++);
        }
        this.toBeSerialized = new ArrayDeque<TaskDeploymentDescriptorFactory.ShuffleDescriptorAndIndex>(consumedPartitionGroup.size());
        this.serializedShuffleDescriptors = new ArrayList<TaskDeploymentDescriptor.MaybeOffloaded<TaskDeploymentDescriptorFactory.ShuffleDescriptorAndIndex[]>>();
        for (TaskDeploymentDescriptorFactory.ShuffleDescriptorAndIndex shuffleDescriptor : shuffleDescriptors) {
            this.toBeSerialized.offer(shuffleDescriptor);
        }
    }

    public List<TaskDeploymentDescriptor.MaybeOffloaded<TaskDeploymentDescriptorFactory.ShuffleDescriptorAndIndex[]>> getAllSerializedShuffleDescriptors() {
        return new ArrayList<TaskDeploymentDescriptor.MaybeOffloaded<TaskDeploymentDescriptorFactory.ShuffleDescriptorAndIndex[]>>(this.serializedShuffleDescriptors);
    }

    public void serializeShuffleDescriptors(FunctionWithException<TaskDeploymentDescriptorFactory.ShuffleDescriptorAndIndex[], TaskDeploymentDescriptor.MaybeOffloaded<TaskDeploymentDescriptorFactory.ShuffleDescriptorAndIndex[]>, IOException> shuffleDescriptorSerializer) throws IOException {
        if (!this.toBeSerialized.isEmpty()) {
            TaskDeploymentDescriptor.MaybeOffloaded serializedShuffleDescriptor = (TaskDeploymentDescriptor.MaybeOffloaded)shuffleDescriptorSerializer.apply((Object)this.toBeSerialized.toArray(new TaskDeploymentDescriptorFactory.ShuffleDescriptorAndIndex[0]));
            this.toBeSerialized.clear();
            this.serializedShuffleDescriptors.add(serializedShuffleDescriptor);
        }
    }

    public void markPartitionFinished(IntermediateResultPartition resultPartition) {
        ShuffleDescriptor consumedPartitionShuffleDescriptor = TaskDeploymentDescriptorFactory.getConsumedPartitionShuffleDescriptor(resultPartition, TaskDeploymentDescriptorFactory.PartitionLocationConstraint.MUST_BE_KNOWN, false);
        this.toBeSerialized.offer(new TaskDeploymentDescriptorFactory.ShuffleDescriptorAndIndex(consumedPartitionShuffleDescriptor, (Integer)Preconditions.checkNotNull((Object)this.resultPartitionIdToIndex.get(resultPartition.getPartitionId()))));
    }
}

