/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor;

import java.io.File;
import java.net.InetAddress;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import org.apache.flink.configuration.ClusterOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.configuration.TaskManagerOptionsInternal;
import org.apache.flink.core.plugin.PluginManager;
import org.apache.flink.core.plugin.PluginUtils;
import org.apache.flink.runtime.blob.BlobCacheService;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.entrypoint.ClusterEntrypointUtils;
import org.apache.flink.runtime.entrypoint.WorkingDirectory;
import org.apache.flink.runtime.externalresource.ExternalResourceInfoProvider;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.security.token.DelegationTokenReceiverRepository;
import org.apache.flink.runtime.taskexecutor.TaskExecutorResourceUtils;
import org.apache.flink.runtime.taskexecutor.TaskManagerRunner;
import org.apache.flink.runtime.taskexecutor.TestingTaskExecutorService;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.TestLogger;
import org.apache.flink.util.TimeUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.Timeout;

public class TaskManagerRunnerTest
extends TestLogger {
    @ClassRule
    public static final TemporaryFolder TEMPORARY_FOLDER = new TemporaryFolder();
    @Rule
    public final Timeout timeout = Timeout.seconds((long)30L);
    private TaskManagerRunner taskManagerRunner;

    @After
    public void after() throws Exception {
        if (this.taskManagerRunner != null) {
            this.taskManagerRunner.close();
        }
    }

    @Test
    public void testShouldShutdownOnFatalError() throws Exception {
        Configuration configuration = TaskManagerRunnerTest.createConfiguration();
        configuration.set(TaskManagerOptions.REGISTRATION_TIMEOUT, (Object)TimeUtils.parseDuration((String)"42 h"));
        this.taskManagerRunner = TaskManagerRunnerTest.createTaskManagerRunner(configuration);
        this.taskManagerRunner.onFatalError((Throwable)new RuntimeException());
        Assert.assertThat(this.taskManagerRunner.getTerminationFuture().join(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)TaskManagerRunner.Result.FAILURE)));
    }

    @Test
    public void testShouldShutdownIfRegistrationWithJobManagerFails() throws Exception {
        Configuration configuration = TaskManagerRunnerTest.createConfiguration();
        configuration.set(TaskManagerOptions.REGISTRATION_TIMEOUT, (Object)TimeUtils.parseDuration((String)"10 ms"));
        this.taskManagerRunner = TaskManagerRunnerTest.createTaskManagerRunner(configuration);
        Assert.assertThat(this.taskManagerRunner.getTerminationFuture().join(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)TaskManagerRunner.Result.FAILURE)));
    }

    @Test
    public void testGenerateTaskManagerResourceIDWithMetaData() throws Exception {
        Configuration configuration = TaskManagerRunnerTest.createConfiguration();
        String metadata = "test";
        configuration.set(TaskManagerOptionsInternal.TASK_MANAGER_RESOURCE_ID_METADATA, (Object)"test");
        ResourceID taskManagerResourceID = (ResourceID)TaskManagerRunner.getTaskManagerResourceID((Configuration)configuration, (String)"", (int)-1).unwrap();
        Assert.assertThat((Object)taskManagerResourceID.getMetadata(), (Matcher)Matchers.equalTo((Object)"test"));
    }

    @Test
    public void testGenerateTaskManagerResourceIDWithoutMetaData() throws Exception {
        Configuration configuration = TaskManagerRunnerTest.createConfiguration();
        String resourceID = "test";
        configuration.set(TaskManagerOptions.TASK_MANAGER_RESOURCE_ID, (Object)"test");
        ResourceID taskManagerResourceID = (ResourceID)TaskManagerRunner.getTaskManagerResourceID((Configuration)configuration, (String)"", (int)-1).unwrap();
        Assert.assertThat((Object)taskManagerResourceID.getMetadata(), (Matcher)Matchers.equalTo((Object)""));
        Assert.assertThat((Object)taskManagerResourceID.getStringWithMetadata(), (Matcher)Matchers.equalTo((Object)"test"));
    }

    @Test
    public void testGenerateTaskManagerResourceIDWithConfig() throws Exception {
        Configuration configuration = TaskManagerRunnerTest.createConfiguration();
        String resourceID = "test";
        configuration.set(TaskManagerOptions.TASK_MANAGER_RESOURCE_ID, (Object)"test");
        ResourceID taskManagerResourceID = (ResourceID)TaskManagerRunner.getTaskManagerResourceID((Configuration)configuration, (String)"", (int)-1).unwrap();
        Assert.assertThat((Object)taskManagerResourceID.getResourceIdString(), (Matcher)Matchers.equalTo((Object)"test"));
    }

    @Test
    public void testGenerateTaskManagerResourceIDWithRemoteRpcService() throws Exception {
        Configuration configuration = TaskManagerRunnerTest.createConfiguration();
        String rpcAddress = "flink";
        int rpcPort = 9090;
        ResourceID taskManagerResourceID = (ResourceID)TaskManagerRunner.getTaskManagerResourceID((Configuration)configuration, (String)"flink", (int)9090).unwrap();
        Assert.assertThat((Object)taskManagerResourceID, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)taskManagerResourceID.getResourceIdString(), (Matcher)Matchers.containsString((String)"flink:9090"));
    }

    @Test
    public void testGenerateTaskManagerResourceIDWithLocalRpcService() throws Exception {
        Configuration configuration = TaskManagerRunnerTest.createConfiguration();
        String rpcAddress = "";
        int rpcPort = -1;
        ResourceID taskManagerResourceID = (ResourceID)TaskManagerRunner.getTaskManagerResourceID((Configuration)configuration, (String)"", (int)-1).unwrap();
        Assert.assertThat((Object)taskManagerResourceID, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)taskManagerResourceID.getResourceIdString(), (Matcher)Matchers.containsString((String)InetAddress.getLocalHost().getHostName()));
    }

    @Test
    public void testUnexpectedTaskManagerTerminationFailsRunnerFatally() throws Exception {
        CompletableFuture<Void> terminationFuture = new CompletableFuture<Void>();
        TestingTaskExecutorService taskExecutorService = TestingTaskExecutorService.newBuilder().setTerminationFuture(terminationFuture).build();
        TaskManagerRunner taskManagerRunner = TaskManagerRunnerTest.createTaskManagerRunner(TaskManagerRunnerTest.createConfiguration(), this.createTaskExecutorServiceFactory(taskExecutorService));
        terminationFuture.complete(null);
        Assert.assertThat(taskManagerRunner.getTerminationFuture().join(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)TaskManagerRunner.Result.FAILURE)));
    }

    @Test
    public void testUnexpectedTaskManagerTerminationAfterRunnerCloseWillBeIgnored() throws Exception {
        CompletableFuture<Void> terminationFuture = new CompletableFuture<Void>();
        TestingTaskExecutorService taskExecutorService = TestingTaskExecutorService.newBuilder().setTerminationFuture(terminationFuture).withManualTerminationFutureCompletion().build();
        TaskManagerRunner taskManagerRunner = TaskManagerRunnerTest.createTaskManagerRunner(TaskManagerRunnerTest.createConfiguration(), this.createTaskExecutorServiceFactory(taskExecutorService));
        taskManagerRunner.closeAsync();
        terminationFuture.complete(null);
        Assert.assertThat(taskManagerRunner.getTerminationFuture().join(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)TaskManagerRunner.Result.SUCCESS)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWorkingDirIsSetupWhenStartingTaskManagerRunner() throws Exception {
        File workingDirBase = TEMPORARY_FOLDER.newFolder();
        ResourceID taskManagerResourceId = new ResourceID("foobar");
        Configuration configuration = this.createConfigurationWithWorkingDirectory(workingDirBase, taskManagerResourceId);
        File workingDir = ClusterEntrypointUtils.generateTaskManagerWorkingDirectoryFile((Configuration)configuration, (ResourceID)taskManagerResourceId);
        try (TaskManagerRunner taskManagerRunner = TaskManagerRunnerTest.createTaskManagerRunner(configuration);){
            Assert.assertTrue((boolean)workingDir.exists());
        }
        Assert.assertFalse((String)"The working dir should be cleaned up when stopping the TaskManager process gracefully.", (boolean)workingDir.exists());
    }

    @Nonnull
    private Configuration createConfigurationWithWorkingDirectory(File workingDirBase, ResourceID taskManagerResourceId) {
        Configuration configuration = TaskManagerRunnerTest.createConfiguration();
        configuration.set(ClusterOptions.PROCESS_WORKING_DIR_BASE, (Object)workingDirBase.getAbsolutePath());
        configuration.set(TaskManagerOptions.TASK_MANAGER_RESOURCE_ID, (Object)taskManagerResourceId.toString());
        return configuration;
    }

    @Test
    public void testWorkingDirIsNotDeletedInCaseOfFailure() throws Exception {
        File workingDirBase = TEMPORARY_FOLDER.newFolder();
        ResourceID resourceId = ResourceID.generate();
        Configuration configuration = this.createConfigurationWithWorkingDirectory(workingDirBase, resourceId);
        TaskManagerRunner taskManagerRunner = TaskManagerRunnerTest.createTaskManagerRunner(configuration, new TestingFailingTaskExecutorServiceFactory());
        taskManagerRunner.getTerminationFuture().join();
        Assert.assertTrue((boolean)ClusterEntrypointUtils.generateTaskManagerWorkingDirectoryFile((Configuration)configuration, (ResourceID)resourceId).exists());
    }

    @Nonnull
    private TaskManagerRunner.TaskExecutorServiceFactory createTaskExecutorServiceFactory(TestingTaskExecutorService taskExecutorService) {
        return (configuration, resourceID, rpcService, highAvailabilityServices, heartbeatServices, metricRegistry, blobCacheService, localCommunicationOnly, externalResourceInfoProvider, workingDirectory, fatalErrorHandler, delegationTokenReceiverRepository) -> taskExecutorService;
    }

    private static Configuration createConfiguration() {
        Configuration configuration = new Configuration();
        configuration.setString(JobManagerOptions.ADDRESS, "localhost");
        configuration.setString(TaskManagerOptions.HOST, "localhost");
        return TaskExecutorResourceUtils.adjustForLocalExecution((Configuration)configuration);
    }

    private static TaskManagerRunner createTaskManagerRunner(Configuration configuration) throws Exception {
        return TaskManagerRunnerTest.createTaskManagerRunner(configuration, TaskManagerRunner::createTaskExecutorService);
    }

    private static TaskManagerRunner createTaskManagerRunner(Configuration configuration, TaskManagerRunner.TaskExecutorServiceFactory taskExecutorServiceFactory) throws Exception {
        PluginManager pluginManager = PluginUtils.createPluginManagerFromRootFolder((Configuration)configuration);
        TaskManagerRunner taskManagerRunner = new TaskManagerRunner(configuration, pluginManager, taskExecutorServiceFactory);
        taskManagerRunner.start();
        return taskManagerRunner;
    }

    private static class TestingFailingTaskExecutorServiceFactory
    implements TaskManagerRunner.TaskExecutorServiceFactory {
        private TestingFailingTaskExecutorServiceFactory() {
        }

        public TaskManagerRunner.TaskExecutorService createTaskExecutor(Configuration configuration, ResourceID resourceID, RpcService rpcService, HighAvailabilityServices highAvailabilityServices, HeartbeatServices heartbeatServices, MetricRegistry metricRegistry, BlobCacheService blobCacheService, boolean localCommunicationOnly, ExternalResourceInfoProvider externalResourceInfoProvider, WorkingDirectory workingDirectory, FatalErrorHandler fatalErrorHandler, DelegationTokenReceiverRepository delegationTokenReceiverRepository) {
            return TestingTaskExecutorService.newBuilder().setStartRunnable(() -> fatalErrorHandler.onFatalError((Throwable)new FlinkException("Cannot instantiate the TaskExecutorService."))).build();
        }
    }
}

