/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptive;

import org.apache.flink.api.common.JobStatus;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionGraph;
import org.apache.flink.runtime.rest.handler.legacy.utils.ArchivedExecutionGraphBuilder;
import org.apache.flink.runtime.scheduler.adaptive.Finished;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class FinishedTest
extends TestLogger {
    private final JobStatus testJobStatus = JobStatus.FAILED;

    @Test
    public void testOnFinishedCallOnEnter() throws Exception {
        MockFinishedContext ctx = new MockFinishedContext();
        this.createFinishedState(ctx);
        Assert.assertThat((Object)ctx.getArchivedExecutionGraph().getState(), (Matcher)CoreMatchers.is((Object)this.testJobStatus));
    }

    @Test
    public void testCancelIgnored() throws Exception {
        MockFinishedContext ctx = new MockFinishedContext();
        this.createFinishedState(ctx).cancel();
        Assert.assertThat((Object)ctx.getArchivedExecutionGraph().getState(), (Matcher)CoreMatchers.is((Object)this.testJobStatus));
    }

    @Test
    public void testSuspendIgnored() throws Exception {
        MockFinishedContext ctx = new MockFinishedContext();
        this.createFinishedState(ctx).suspend((Throwable)new RuntimeException());
        Assert.assertThat((Object)ctx.getArchivedExecutionGraph().getState(), (Matcher)CoreMatchers.is((Object)this.testJobStatus));
    }

    @Test
    public void testGlobalFailureIgnored() {
        MockFinishedContext ctx = new MockFinishedContext();
        this.createFinishedState(ctx).handleGlobalFailure((Throwable)new RuntimeException());
        Assert.assertThat((Object)ctx.getArchivedExecutionGraph().getState(), (Matcher)CoreMatchers.is((Object)this.testJobStatus));
    }

    @Test
    public void testGetJobStatus() {
        MockFinishedContext ctx = new MockFinishedContext();
        Assert.assertThat((Object)this.createFinishedState(ctx).getJobStatus(), (Matcher)CoreMatchers.is((Object)this.testJobStatus));
    }

    private Finished createFinishedState(MockFinishedContext ctx) {
        ArchivedExecutionGraph archivedExecutionGraph = new ArchivedExecutionGraphBuilder().setState(this.testJobStatus).build();
        return new Finished((Finished.Context)ctx, archivedExecutionGraph, this.log);
    }

    private static class MockFinishedContext
    implements Finished.Context {
        private ArchivedExecutionGraph archivedExecutionGraph = null;

        private MockFinishedContext() {
        }

        public void onFinished(ArchivedExecutionGraph archivedExecutionGraph) {
            if (archivedExecutionGraph == null) {
                throw new AssertionError((Object)"Transitioned to onFinished twice");
            }
            this.archivedExecutionGraph = archivedExecutionGraph;
        }

        private ArchivedExecutionGraph getArchivedExecutionGraph() {
            return this.archivedExecutionGraph;
        }
    }
}

