/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.persistence;

import java.io.IOException;
import java.io.Serializable;
import java.util.function.Function;
import org.apache.flink.runtime.persistence.RetrievableStateStorageHelper;
import org.apache.flink.runtime.state.RetrievableStateHandle;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.FunctionWithException;
import org.apache.flink.util.function.ThrowingConsumer;

public final class TestingRetrievableStateStorageHelper<T extends Serializable>
implements RetrievableStateStorageHelper<T> {
    private FunctionWithException<T, T, IOException> retrieveStateFunction = state -> state;
    private ThrowingConsumer<T, Exception> discardStateHandler = state -> {};
    private Function<T, Long> getStateSizeFunction = state -> 0L;

    public RetrievableStateHandle<T> store(T state) {
        return new TestingRetrievableStateHandle(this, (Serializable)state);
    }

    public void setRetrieveStateFunction(FunctionWithException<T, T, IOException> retrieveStateFunction) {
        this.retrieveStateFunction = (FunctionWithException)Preconditions.checkNotNull(retrieveStateFunction);
    }

    public void setDiscardStateHandler(ThrowingConsumer<T, Exception> discardStateHandler) {
        this.discardStateHandler = (ThrowingConsumer)Preconditions.checkNotNull(discardStateHandler);
    }

    public void setGetStateSizeFunction(Function<T, Long> getStateSizeFunction) {
        this.getStateSizeFunction = (Function)Preconditions.checkNotNull(getStateSizeFunction);
    }

    private static final class TestingRetrievableStateHandle
    implements RetrievableStateHandle<T> {
        private static final long serialVersionUID = 1L;
        private final T state;
        final /* synthetic */ TestingRetrievableStateStorageHelper this$0;

        private TestingRetrievableStateHandle(T state) {
            this.this$0 = var1_1;
            this.state = state;
        }

        public T retrieveState() throws IOException {
            return (Serializable)this.this$0.retrieveStateFunction.apply(this.state);
        }

        public void discardState() throws Exception {
            this.this$0.discardStateHandler.accept(this.state);
        }

        public long getStateSize() {
            return (Long)this.this$0.getStateSizeFunction.apply(this.state);
        }
    }
}

