/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.coordination;

import java.util.concurrent.CompletableFuture;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.operators.coordination.CoordinatorStore;
import org.apache.flink.runtime.operators.coordination.CoordinatorStoreImpl;
import org.apache.flink.runtime.operators.coordination.OperatorCoordinator;

public class MockOperatorCoordinatorContext
implements OperatorCoordinator.Context {
    private final OperatorID operatorID;
    private final ClassLoader userCodeClassLoader;
    private final int numSubtasks;
    private final CoordinatorStore coordinatorStore = new CoordinatorStoreImpl();
    private boolean jobFailed;
    private Throwable jobFailureReason;
    private final CompletableFuture<Void> jobFailedFuture = new CompletableFuture();

    public MockOperatorCoordinatorContext(OperatorID operatorID, int numSubtasks) {
        this(operatorID, numSubtasks, MockOperatorCoordinatorContext.class.getClassLoader());
    }

    public MockOperatorCoordinatorContext(OperatorID operatorID, ClassLoader userCodeClassLoader) {
        this(operatorID, 1, userCodeClassLoader);
    }

    public MockOperatorCoordinatorContext(OperatorID operatorID, int numSubtasks, ClassLoader userCodeClassLoader) {
        this.operatorID = operatorID;
        this.numSubtasks = numSubtasks;
        this.jobFailed = false;
        this.jobFailureReason = null;
        this.userCodeClassLoader = userCodeClassLoader;
    }

    public OperatorID getOperatorId() {
        return this.operatorID;
    }

    public void failJob(Throwable cause) {
        this.jobFailed = true;
        this.jobFailureReason = cause;
        this.jobFailedFuture.complete(null);
    }

    public int currentParallelism() {
        return this.numSubtasks;
    }

    public ClassLoader getUserCodeClassloader() {
        return this.userCodeClassLoader;
    }

    public CoordinatorStore getCoordinatorStore() {
        return this.coordinatorStore;
    }

    public boolean isConcurrentExecutionAttemptsSupported() {
        return false;
    }

    public boolean isJobFailed() {
        return this.jobFailed;
    }

    public Throwable getJobFailureReason() {
        return this.jobFailureReason;
    }

    public CompletableFuture<Void> getJobFailedFuture() {
        return this.jobFailedFuture;
    }
}

