/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.buffer;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.io.network.buffer.AbstractByteBufTest;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferRecycler;
import org.apache.flink.runtime.io.network.buffer.FreeingBufferRecycler;
import org.apache.flink.runtime.io.network.buffer.NetworkBuffer;
import org.apache.flink.runtime.io.network.buffer.ReadOnlySlicedNetworkBuffer;
import org.apache.flink.runtime.io.network.netty.NettyBufferPool;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBufAllocator;
import org.junit.Assert;
import org.junit.Test;

public class NetworkBufferTest
extends AbstractByteBufTest {
    private static final int MAX_CAPACITY_UPPER_BOUND = 0x4000000;
    private static final NettyBufferPool NETTY_BUFFER_POOL = new NettyBufferPool(1);

    protected NetworkBuffer newBuffer(int length, int maxCapacity) {
        return NetworkBufferTest.newBuffer(length, maxCapacity, false);
    }

    private static NetworkBuffer newBuffer(int length, int maxCapacity, boolean isBuffer) {
        return NetworkBufferTest.newBuffer(length, maxCapacity, isBuffer, FreeingBufferRecycler.INSTANCE);
    }

    private static NetworkBuffer newBuffer(int length, int maxCapacity, boolean isBuffer, BufferRecycler recycler) {
        MemorySegment segment = MemorySegmentFactory.allocateUnpooledSegment((int)Math.min(maxCapacity, 0x4000000));
        Buffer.DataType dataType = isBuffer ? Buffer.DataType.DATA_BUFFER : Buffer.DataType.EVENT_BUFFER;
        NetworkBuffer buffer = new NetworkBuffer(segment, recycler, dataType);
        buffer.capacity(length);
        buffer.setAllocator((ByteBufAllocator)NETTY_BUFFER_POOL);
        Assert.assertSame((Object)ByteOrder.BIG_ENDIAN, (Object)buffer.order());
        Assert.assertEquals((long)0L, (long)buffer.readerIndex());
        Assert.assertEquals((long)0L, (long)buffer.writerIndex());
        return buffer;
    }

    @Test
    public void testDataBufferIsBuffer() {
        Assert.assertTrue((boolean)NetworkBufferTest.newBuffer(1024, 1024, true).isBuffer());
    }

    @Test
    public void testEventBufferIsBuffer() {
        Assert.assertFalse((boolean)NetworkBufferTest.newBuffer(1024, 1024, false).isBuffer());
    }

    @Test
    public void testDataBufferTagAsEvent() {
        NetworkBufferTest.testTagAsEvent(true);
    }

    @Test
    public void testEventBufferTagAsEvent() {
        NetworkBufferTest.testTagAsEvent(false);
    }

    private static void testTagAsEvent(boolean isBuffer) {
        NetworkBuffer buffer = NetworkBufferTest.newBuffer(1024, 1024, isBuffer);
        buffer.setDataType(Buffer.DataType.EVENT_BUFFER);
        Assert.assertFalse((boolean)buffer.isBuffer());
    }

    @Test
    public void testDataBufferGetMemorySegment() {
        NetworkBufferTest.testGetMemorySegment(true);
    }

    @Test
    public void testEventBufferGetMemorySegment() {
        NetworkBufferTest.testGetMemorySegment(false);
    }

    private static void testGetMemorySegment(boolean isBuffer) {
        MemorySegment segment = MemorySegmentFactory.allocateUnpooledSegment((int)1024);
        Buffer.DataType dataType = isBuffer ? Buffer.DataType.DATA_BUFFER : Buffer.DataType.EVENT_BUFFER;
        NetworkBuffer buffer = new NetworkBuffer(segment, FreeingBufferRecycler.INSTANCE, dataType);
        Assert.assertSame((Object)segment, (Object)buffer.getMemorySegment());
    }

    @Test
    public void testDataBufferGetRecycler() {
        NetworkBufferTest.testGetRecycler(true);
    }

    @Test
    public void testEventBufferGetRecycler() {
        NetworkBufferTest.testGetRecycler(false);
    }

    private static void testGetRecycler(boolean isBuffer) {
        BufferRecycler recycler = MemorySegment::free;
        NetworkBuffer dataBuffer = NetworkBufferTest.newBuffer(1024, 1024, isBuffer, recycler);
        Assert.assertSame((Object)recycler, (Object)dataBuffer.getRecycler());
    }

    @Test
    public void testDataBufferRecycleBuffer() {
        NetworkBufferTest.testRecycleBuffer(true);
    }

    @Test
    public void testEventBufferRecycleBuffer() {
        NetworkBufferTest.testRecycleBuffer(false);
    }

    private static void testRecycleBuffer(boolean isBuffer) {
        NetworkBuffer buffer = NetworkBufferTest.newBuffer(1024, 1024, isBuffer);
        Assert.assertFalse((boolean)buffer.isRecycled());
        buffer.recycleBuffer();
        Assert.assertTrue((boolean)buffer.isRecycled());
        Assert.assertEquals((long)0L, (long)buffer.refCnt());
    }

    @Test
    public void testDataBufferRetainBuffer() {
        NetworkBufferTest.testRetainBuffer(true);
    }

    @Test
    public void testEventBufferRetainBuffer() {
        NetworkBufferTest.testRetainBuffer(false);
    }

    private static void testRetainBuffer(boolean isBuffer) {
        NetworkBuffer buffer = NetworkBufferTest.newBuffer(1024, 1024, isBuffer);
        Assert.assertFalse((boolean)buffer.isRecycled());
        buffer.retainBuffer();
        Assert.assertFalse((boolean)buffer.isRecycled());
        Assert.assertEquals((long)2L, (long)buffer.refCnt());
    }

    @Test
    public void testDataBufferCreateSlice1() {
        NetworkBufferTest.testCreateSlice1(true);
    }

    @Test
    public void testEventBufferCreateSlice1() {
        NetworkBufferTest.testCreateSlice1(false);
    }

    private static void testCreateSlice1(boolean isBuffer) {
        NetworkBuffer buffer = NetworkBufferTest.newBuffer(1024, 1024, isBuffer);
        buffer.setSize(10);
        ReadOnlySlicedNetworkBuffer slice = buffer.readOnlySlice();
        Assert.assertEquals((long)0L, (long)slice.getReaderIndex());
        Assert.assertEquals((long)10L, (long)slice.getSize());
        Assert.assertSame((Object)buffer, (Object)slice.unwrap().unwrap());
        buffer.setSize(8);
        buffer.setReaderIndex(2);
        Assert.assertEquals((long)0L, (long)slice.getReaderIndex());
        Assert.assertEquals((long)10L, (long)slice.getSize());
    }

    @Test
    public void testDataBufferCreateSlice2() {
        NetworkBufferTest.testCreateSlice2(true);
    }

    @Test
    public void testEventBufferCreateSlice2() {
        NetworkBufferTest.testCreateSlice2(false);
    }

    private static void testCreateSlice2(boolean isBuffer) {
        NetworkBuffer buffer = NetworkBufferTest.newBuffer(1024, 1024, isBuffer);
        buffer.setSize(2);
        ReadOnlySlicedNetworkBuffer slice = buffer.readOnlySlice(1, 10);
        Assert.assertEquals((long)0L, (long)slice.getReaderIndex());
        Assert.assertEquals((long)10L, (long)slice.getSize());
        Assert.assertSame((Object)buffer, (Object)slice.unwrap().unwrap());
        buffer.setSize(8);
        buffer.setReaderIndex(2);
        Assert.assertEquals((long)0L, (long)slice.getReaderIndex());
        Assert.assertEquals((long)10L, (long)slice.getSize());
    }

    @Test
    public void testDataBufferGetMaxCapacity() {
        NetworkBufferTest.testGetMaxCapacity(true);
    }

    @Test
    public void testEventBufferGetMaxCapacity() {
        NetworkBufferTest.testGetMaxCapacity(false);
    }

    private static void testGetMaxCapacity(boolean isBuffer) {
        NetworkBuffer buffer = NetworkBufferTest.newBuffer(100, 1024, isBuffer);
        Assert.assertEquals((long)1024L, (long)buffer.getMaxCapacity());
        MemorySegment segment = buffer.getMemorySegment();
        Assert.assertEquals((long)segment.size(), (long)buffer.getMaxCapacity());
        Assert.assertEquals((long)segment.size(), (long)buffer.maxCapacity());
    }

    @Test
    public void testDataBufferGetSetReaderIndex() {
        NetworkBufferTest.testGetSetReaderIndex(true);
    }

    @Test
    public void testEventBufferGetSetReaderIndex() {
        NetworkBufferTest.testGetSetReaderIndex(false);
    }

    private static void testGetSetReaderIndex(boolean isBuffer) {
        NetworkBuffer buffer = NetworkBufferTest.newBuffer(100, 1024, isBuffer);
        Assert.assertEquals((long)0L, (long)buffer.getReaderIndex());
        buffer.setSize(100);
        Assert.assertEquals((long)0L, (long)buffer.getReaderIndex());
        buffer.setReaderIndex(1);
        Assert.assertEquals((long)1L, (long)buffer.getReaderIndex());
    }

    @Test
    public void testDataBufferSetGetSize() {
        NetworkBufferTest.testSetGetSize(true);
    }

    @Test
    public void testEventBufferSetGetSize() {
        NetworkBufferTest.testSetGetSize(false);
    }

    private static void testSetGetSize(boolean isBuffer) {
        NetworkBuffer buffer = NetworkBufferTest.newBuffer(1024, 1024, isBuffer);
        Assert.assertEquals((long)0L, (long)buffer.getSize());
        Assert.assertEquals((long)buffer.writerIndex(), (long)buffer.getSize());
        Assert.assertEquals((long)0L, (long)buffer.readerIndex());
        buffer.setSize(10);
        Assert.assertEquals((long)10L, (long)buffer.getSize());
        Assert.assertEquals((long)buffer.writerIndex(), (long)buffer.getSize());
        Assert.assertEquals((long)0L, (long)buffer.readerIndex());
    }

    @Test
    public void testDataBufferReadableBytes() {
        NetworkBufferTest.testReadableBytes(true);
    }

    @Test
    public void testEventBufferReadableBytes() {
        NetworkBufferTest.testReadableBytes(false);
    }

    private static void testReadableBytes(boolean isBuffer) {
        NetworkBuffer buffer = NetworkBufferTest.newBuffer(1024, 1024, isBuffer);
        Assert.assertEquals((long)0L, (long)buffer.readableBytes());
        buffer.setSize(10);
        Assert.assertEquals((long)10L, (long)buffer.readableBytes());
        buffer.setReaderIndex(2);
        Assert.assertEquals((long)8L, (long)buffer.readableBytes());
        buffer.setReaderIndex(10);
        Assert.assertEquals((long)0L, (long)buffer.readableBytes());
    }

    @Test
    public void testDataBufferGetNioBufferReadable() {
        this.testGetNioBufferReadable(true);
    }

    @Test
    public void testEventBufferGetNioBufferReadable() {
        this.testGetNioBufferReadable(false);
    }

    private void testGetNioBufferReadable(boolean isBuffer) {
        NetworkBuffer buffer = NetworkBufferTest.newBuffer(1024, 1024, isBuffer);
        ByteBuffer byteBuffer = buffer.getNioBufferReadable();
        Assert.assertFalse((boolean)byteBuffer.isReadOnly());
        Assert.assertEquals((long)0L, (long)byteBuffer.remaining());
        Assert.assertEquals((long)0L, (long)byteBuffer.limit());
        Assert.assertEquals((long)0L, (long)byteBuffer.capacity());
        buffer.setSize(10);
        Assert.assertEquals((long)0L, (long)byteBuffer.remaining());
        Assert.assertEquals((long)0L, (long)byteBuffer.limit());
        Assert.assertEquals((long)0L, (long)byteBuffer.capacity());
        byteBuffer = buffer.getNioBufferReadable();
        Assert.assertFalse((boolean)byteBuffer.isReadOnly());
        Assert.assertEquals((long)10L, (long)byteBuffer.remaining());
        Assert.assertEquals((long)10L, (long)byteBuffer.limit());
        Assert.assertEquals((long)10L, (long)byteBuffer.capacity());
        byteBuffer.position(1);
        Assert.assertEquals((long)0L, (long)buffer.getReaderIndex());
        Assert.assertEquals((long)10L, (long)buffer.getSize());
    }

    @Test
    public void testGetNioBufferReadableThreadSafe() {
        NetworkBuffer buffer = this.newBuffer(1024, 1024);
        NetworkBufferTest.testGetNioBufferReadableThreadSafe((Buffer)buffer);
    }

    static void testGetNioBufferReadableThreadSafe(Buffer buffer) {
        ByteBuffer buf1 = buffer.getNioBufferReadable();
        ByteBuffer buf2 = buffer.getNioBufferReadable();
        Assert.assertNotNull((Object)buf1);
        Assert.assertNotNull((Object)buf2);
        Assert.assertTrue((String)"Repeated call to getNioBuffer() returns the same nio buffer", (buf1 != buf2 ? 1 : 0) != 0);
    }

    @Test
    public void testDataBufferGetNioBuffer() {
        this.testGetNioBuffer(true);
    }

    @Test
    public void testEventBufferGetNioBuffer() {
        this.testGetNioBuffer(false);
    }

    private void testGetNioBuffer(boolean isBuffer) {
        NetworkBuffer buffer = NetworkBufferTest.newBuffer(1024, 1024, isBuffer);
        ByteBuffer byteBuffer = buffer.getNioBuffer(1, 1);
        Assert.assertFalse((boolean)byteBuffer.isReadOnly());
        Assert.assertEquals((long)1L, (long)byteBuffer.remaining());
        Assert.assertEquals((long)1L, (long)byteBuffer.limit());
        Assert.assertEquals((long)1L, (long)byteBuffer.capacity());
        buffer.setSize(10);
        Assert.assertEquals((long)1L, (long)byteBuffer.remaining());
        Assert.assertEquals((long)1L, (long)byteBuffer.limit());
        Assert.assertEquals((long)1L, (long)byteBuffer.capacity());
        byteBuffer = buffer.getNioBuffer(1, 2);
        Assert.assertFalse((boolean)byteBuffer.isReadOnly());
        Assert.assertEquals((long)2L, (long)byteBuffer.remaining());
        Assert.assertEquals((long)2L, (long)byteBuffer.limit());
        Assert.assertEquals((long)2L, (long)byteBuffer.capacity());
        byteBuffer.position(1);
        Assert.assertEquals((long)0L, (long)buffer.getReaderIndex());
        Assert.assertEquals((long)10L, (long)buffer.getSize());
    }

    @Test
    public void testGetNioBufferThreadSafe() {
        NetworkBuffer buffer = this.newBuffer(1024, 1024);
        NetworkBufferTest.testGetNioBufferThreadSafe((Buffer)buffer, 10);
    }

    static void testGetNioBufferThreadSafe(Buffer buffer, int length) {
        ByteBuffer buf1 = buffer.getNioBuffer(0, length);
        ByteBuffer buf2 = buffer.getNioBuffer(0, length);
        Assert.assertNotNull((Object)buf1);
        Assert.assertNotNull((Object)buf2);
        Assert.assertTrue((String)"Repeated call to getNioBuffer(int, int) returns the same nio buffer", (buf1 != buf2 ? 1 : 0) != 0);
    }

    @Test
    public void testDataBufferSetAllocator() {
        this.testSetAllocator(true);
    }

    @Test
    public void testEventBufferSetAllocator() {
        this.testSetAllocator(false);
    }

    private void testSetAllocator(boolean isBuffer) {
        NetworkBuffer buffer = NetworkBufferTest.newBuffer(1024, 1024, isBuffer);
        NettyBufferPool allocator = new NettyBufferPool(1);
        buffer.setAllocator((ByteBufAllocator)allocator);
        Assert.assertSame((Object)allocator, (Object)buffer.alloc());
    }
}

