/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.disk;

import java.io.File;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.api.common.time.Deadline;
import org.apache.flink.runtime.io.disk.FileChannelManager;
import org.apache.flink.runtime.io.disk.FileChannelManagerImpl;
import org.apache.flink.runtime.io.disk.iomanager.FileIOChannel;
import org.apache.flink.runtime.testutils.TestJvmProcess;
import org.apache.flink.util.OperatingSystem;
import org.apache.flink.util.ShutdownHookUtil;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileChannelManagerImplTest
extends TestLogger {
    private static final Logger LOG = LoggerFactory.getLogger(FileChannelManagerImplTest.class);
    private static final String DIR_NAME_PREFIX = "manager-test";
    private static final String SIGNAL_FILE_FOR_KILLING = "could-kill";
    private static final Duration TEST_TIMEOUT = Duration.ofSeconds(10L);
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void testFairness() throws Exception {
        int i;
        String directory1 = this.temporaryFolder.newFolder().getAbsoluteFile().getAbsolutePath();
        String directory2 = this.temporaryFolder.newFolder().getAbsoluteFile().getAbsolutePath();
        FileChannelManagerImpl fileChannelManager = new FileChannelManagerImpl(new String[]{directory1, directory2}, "test");
        int numChannelIDs = 100000;
        AtomicInteger counter1 = new AtomicInteger();
        AtomicInteger counter2 = new AtomicInteger();
        int numThreads = 10;
        Thread[] threads = new Thread[numThreads];
        for (i = 0; i < numThreads; ++i) {
            threads[i] = new Thread(() -> FileChannelManagerImplTest.lambda$testFairness$0(numChannelIDs, (FileChannelManager)fileChannelManager, directory1, counter1, counter2));
            threads[i].start();
        }
        for (i = 0; i < numThreads; ++i) {
            threads[i].join();
        }
        Assert.assertEquals((long)counter1.get(), (long)counter2.get());
    }

    @Test
    public void testDirectoriesCleanupOnKillWithoutCallerHook() throws Exception {
        this.testDirectoriesCleanupOnKill(false);
    }

    @Test
    public void testDirectoriesCleanupOnKillWithCallerHook() throws Exception {
        this.testDirectoriesCleanupOnKill(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testDirectoriesCleanupOnKill(boolean callerHasHook) throws Exception {
        Assume.assumeTrue((OperatingSystem.isLinux() || OperatingSystem.isFreeBSD() || OperatingSystem.isSolaris() || OperatingSystem.isMac() ? 1 : 0) != 0);
        File fileChannelDir = this.temporaryFolder.newFolder();
        File signalDir = this.temporaryFolder.newFolder();
        File signalFile = new File(signalDir.getAbsolutePath(), SIGNAL_FILE_FOR_KILLING);
        FileChannelManagerTestProcess fileChannelManagerTestProcess = new FileChannelManagerTestProcess(callerHasHook, fileChannelDir.getAbsolutePath(), signalFile.getAbsolutePath());
        try {
            fileChannelManagerTestProcess.startProcess();
            TestJvmProcess.waitForMarkerFile(signalFile, 3L * TEST_TIMEOUT.toMillis());
            Process kill = Runtime.getRuntime().exec("kill " + fileChannelManagerTestProcess.getProcessId());
            kill.waitFor();
            Assert.assertEquals((String)"Failed to send SIG_TERM to process", (long)0L, (long)kill.exitValue());
            Deadline deadline = Deadline.now().plus(TEST_TIMEOUT);
            while (fileChannelManagerTestProcess.isAlive() && deadline.hasTimeLeft()) {
                Thread.sleep(100L);
            }
            Assert.assertFalse((String)("The file channel manager test process does not terminate in time, its output is: \n" + fileChannelManagerTestProcess.getProcessOutput()), (boolean)fileChannelManagerTestProcess.isAlive());
            Assert.assertFalse((String)("The file channel manager test process does not remove the tmp shuffle directories after termination, its output is \n" + fileChannelManagerTestProcess.getProcessOutput()), (boolean)this.fileOrDirExists(fileChannelDir, DIR_NAME_PREFIX));
        }
        finally {
            fileChannelManagerTestProcess.destroy();
        }
    }

    private boolean fileOrDirExists(File rootTmpDir, String namePattern) {
        File[] candidates = rootTmpDir.listFiles((dir, name) -> name.contains(namePattern));
        return candidates != null && candidates.length > 0;
    }

    private static /* synthetic */ void lambda$testFairness$0(int numChannelIDs, FileChannelManager fileChannelManager, String directory1, AtomicInteger counter1, AtomicInteger counter2) {
        for (int j = 0; j < numChannelIDs; ++j) {
            FileIOChannel.ID channelID = fileChannelManager.createChannel();
            if (channelID.getPath().startsWith(directory1)) {
                counter1.incrementAndGet();
                continue;
            }
            counter2.incrementAndGet();
        }
    }

    public static class FileChannelManagerCleanupRunner {
        public static void main(String[] args) throws Exception {
            boolean callerHasHook = Boolean.parseBoolean(args[0]);
            String tmpDirectory = args[1];
            String signalFilePath = args[2];
            LOG.info("The FileChannelManagerCleanupRunner process has started");
            FileChannelManagerImpl manager = new FileChannelManagerImpl(new String[]{tmpDirectory}, FileChannelManagerImplTest.DIR_NAME_PREFIX);
            if (callerHasHook) {
                ShutdownHookUtil.addShutdownHook(() -> FileChannelManagerCleanupRunner.lambda$main$0((FileChannelManager)manager), (String)"Caller", (Logger)LOG);
            }
            LOG.info("The FileChannelManagerCleanupRunner is going to create the new file");
            new File(signalFilePath).createNewFile();
            LOG.info("The FileChannelManagerCleanupRunner has created the new file");
            Thread.sleep(3L * TEST_TIMEOUT.toMillis());
        }

        private static /* synthetic */ void lambda$main$0(FileChannelManager manager) throws Exception {
            manager.close();
        }
    }

    private static class FileChannelManagerTestProcess
    extends TestJvmProcess {
        private final boolean callerHasHook;
        private final String tmpDirectories;
        private final String signalFilePath;

        FileChannelManagerTestProcess(boolean callerHasHook, String tmpDirectories, String signalFilePath) throws Exception {
            this.callerHasHook = callerHasHook;
            this.tmpDirectories = tmpDirectories;
            this.signalFilePath = signalFilePath;
        }

        @Override
        public String getName() {
            return "File Channel Manager Test";
        }

        @Override
        public String[] getJvmArgs() {
            return new String[]{Boolean.toString(this.callerHasHook), this.tmpDirectories, this.signalFilePath};
        }

        @Override
        public String getEntryPointClassName() {
            return FileChannelManagerCleanupRunner.class.getName();
        }
    }
}

