/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.highavailability.nonha.embedded;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.flink.runtime.highavailability.nonha.embedded.EmbeddedLeaderService;
import org.apache.flink.runtime.highavailability.nonha.embedded.TestingLeaderContender;
import org.apache.flink.runtime.leaderelection.LeaderContender;
import org.apache.flink.runtime.leaderelection.LeaderElectionService;
import org.apache.flink.testutils.TestingUtils;
import org.apache.flink.testutils.executor.TestExecutorResource;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

public class EmbeddedLeaderServiceTest
extends TestLogger {
    @ClassRule
    public static final TestExecutorResource<ScheduledExecutorService> EXECUTOR_RESOURCE = TestingUtils.defaultExecutorResource();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcurrentGrantLeadershipAndShutdown() throws Exception {
        EmbeddedLeaderService embeddedLeaderService = new EmbeddedLeaderService((Executor)EXECUTOR_RESOURCE.getExecutor());
        try {
            LeaderElectionService leaderElectionService = embeddedLeaderService.createLeaderElectionService();
            TestingLeaderContender contender = new TestingLeaderContender();
            leaderElectionService.start((LeaderContender)contender);
            leaderElectionService.stop();
            try {
                contender.getLeaderSessionFuture().get(10L, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException timeoutException) {
                // empty catch block
            }
            Assert.assertThat((Object)embeddedLeaderService.isShutdown(), (Matcher)Matchers.is((Object)false));
        }
        finally {
            embeddedLeaderService.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcurrentRevokeLeadershipAndShutdown() throws Exception {
        EmbeddedLeaderService embeddedLeaderService = new EmbeddedLeaderService((Executor)EXECUTOR_RESOURCE.getExecutor());
        try {
            LeaderElectionService leaderElectionService = embeddedLeaderService.createLeaderElectionService();
            TestingLeaderContender contender = new TestingLeaderContender();
            leaderElectionService.start((LeaderContender)contender);
            contender.getLeaderSessionFuture().get();
            CompletableFuture revokeLeadershipFuture = embeddedLeaderService.revokeLeadership();
            leaderElectionService.stop();
            try {
                revokeLeadershipFuture.get(10L, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException timeoutException) {
                // empty catch block
            }
            Assert.assertThat((Object)embeddedLeaderService.isShutdown(), (Matcher)Matchers.is((Object)false));
        }
        finally {
            embeddedLeaderService.shutdown();
        }
    }
}

