/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import org.apache.flink.runtime.accumulators.StringifiedAccumulatorResult;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.AccessExecution;
import org.apache.flink.runtime.executiongraph.AccessExecutionVertex;
import org.apache.flink.runtime.executiongraph.ErrorInfo;
import org.apache.flink.util.OptionalFailure;
import org.apache.flink.util.SerializedValue;
import org.assertj.core.api.Assertions;

class ArchivedExecutionGraphTestUtils {
    private ArchivedExecutionGraphTestUtils() {
    }

    static void compareExecutionVertex(AccessExecutionVertex runtimeVertex, AccessExecutionVertex archivedVertex) {
        Assertions.assertThat((String)runtimeVertex.getTaskNameWithSubtaskIndex()).isEqualTo(archivedVertex.getTaskNameWithSubtaskIndex());
        Assertions.assertThat((int)runtimeVertex.getParallelSubtaskIndex()).isEqualTo(archivedVertex.getParallelSubtaskIndex());
        Assertions.assertThat((Comparable)runtimeVertex.getExecutionState()).isEqualTo((Object)archivedVertex.getExecutionState());
        Assertions.assertThat((long)runtimeVertex.getStateTimestamp(ExecutionState.CREATED)).isEqualTo(archivedVertex.getStateTimestamp(ExecutionState.CREATED));
        Assertions.assertThat((long)runtimeVertex.getStateTimestamp(ExecutionState.SCHEDULED)).isEqualTo(archivedVertex.getStateTimestamp(ExecutionState.SCHEDULED));
        Assertions.assertThat((long)runtimeVertex.getStateTimestamp(ExecutionState.DEPLOYING)).isEqualTo(archivedVertex.getStateTimestamp(ExecutionState.DEPLOYING));
        Assertions.assertThat((long)runtimeVertex.getStateTimestamp(ExecutionState.INITIALIZING)).isEqualTo(archivedVertex.getStateTimestamp(ExecutionState.INITIALIZING));
        Assertions.assertThat((long)runtimeVertex.getStateTimestamp(ExecutionState.RUNNING)).isEqualTo(archivedVertex.getStateTimestamp(ExecutionState.RUNNING));
        Assertions.assertThat((long)runtimeVertex.getStateTimestamp(ExecutionState.FINISHED)).isEqualTo(archivedVertex.getStateTimestamp(ExecutionState.FINISHED));
        Assertions.assertThat((long)runtimeVertex.getStateTimestamp(ExecutionState.CANCELING)).isEqualTo(archivedVertex.getStateTimestamp(ExecutionState.CANCELING));
        Assertions.assertThat((long)runtimeVertex.getStateTimestamp(ExecutionState.CANCELED)).isEqualTo(archivedVertex.getStateTimestamp(ExecutionState.CANCELED));
        Assertions.assertThat((long)runtimeVertex.getStateTimestamp(ExecutionState.FAILED)).isEqualTo(archivedVertex.getStateTimestamp(ExecutionState.FAILED));
        Assertions.assertThat(runtimeVertex.getFailureInfo().map(ErrorInfo::getExceptionAsString)).isEqualTo(archivedVertex.getFailureInfo().map(ErrorInfo::getExceptionAsString));
        Assertions.assertThat(runtimeVertex.getFailureInfo().map(ErrorInfo::getTimestamp)).isEqualTo(archivedVertex.getFailureInfo().map(ErrorInfo::getTimestamp));
        Assertions.assertThat((Comparable)runtimeVertex.getCurrentAssignedResourceLocation()).isEqualTo((Object)archivedVertex.getCurrentAssignedResourceLocation());
        ArchivedExecutionGraphTestUtils.compareExecution(runtimeVertex.getCurrentExecutionAttempt(), archivedVertex.getCurrentExecutionAttempt());
        ArchivedExecutionGraphTestUtils.compareExecutions(runtimeVertex.getCurrentExecutions(), archivedVertex.getCurrentExecutions());
    }

    private static <RT extends AccessExecution, AT extends AccessExecution> void compareExecutions(Collection<RT> runtimeExecutions, Collection<AT> archivedExecutions) {
        Assertions.assertThat(runtimeExecutions).hasSameSizeAs(archivedExecutions);
        ArrayList<RT> sortedRuntimeExecutions = new ArrayList<RT>(runtimeExecutions);
        ArrayList<AT> sortedArchivedExecutions = new ArrayList<AT>(archivedExecutions);
        sortedRuntimeExecutions.sort(Comparator.comparingInt(AccessExecution::getAttemptNumber));
        sortedArchivedExecutions.sort(Comparator.comparingInt(AccessExecution::getAttemptNumber));
        for (int i = 0; i < runtimeExecutions.size(); ++i) {
            ArchivedExecutionGraphTestUtils.compareExecution((AccessExecution)sortedRuntimeExecutions.get(i), (AccessExecution)sortedArchivedExecutions.get(i));
        }
    }

    private static void compareExecution(AccessExecution runtimeExecution, AccessExecution archivedExecution) {
        Assertions.assertThat((Object)runtimeExecution.getAttemptId()).isEqualTo((Object)archivedExecution.getAttemptId());
        Assertions.assertThat((int)runtimeExecution.getAttemptNumber()).isEqualTo(archivedExecution.getAttemptNumber());
        Assertions.assertThat((long[])runtimeExecution.getStateTimestamps()).containsExactly(archivedExecution.getStateTimestamps());
        Assertions.assertThat((long[])runtimeExecution.getStateEndTimestamps()).containsExactly(archivedExecution.getStateEndTimestamps());
        Assertions.assertThat((Comparable)runtimeExecution.getState()).isEqualTo((Object)archivedExecution.getState());
        Assertions.assertThat((Comparable)runtimeExecution.getAssignedResourceLocation()).isEqualTo((Object)archivedExecution.getAssignedResourceLocation());
        Assertions.assertThat(runtimeExecution.getFailureInfo().map(ErrorInfo::getExceptionAsString)).isEqualTo(archivedExecution.getFailureInfo().map(ErrorInfo::getExceptionAsString));
        Assertions.assertThat(runtimeExecution.getFailureInfo().map(ErrorInfo::getTimestamp)).isEqualTo(archivedExecution.getFailureInfo().map(ErrorInfo::getTimestamp));
        Assertions.assertThat((long)runtimeExecution.getStateTimestamp(ExecutionState.CREATED)).isEqualTo(archivedExecution.getStateTimestamp(ExecutionState.CREATED));
        Assertions.assertThat((long)runtimeExecution.getStateTimestamp(ExecutionState.SCHEDULED)).isEqualTo(archivedExecution.getStateTimestamp(ExecutionState.SCHEDULED));
        Assertions.assertThat((long)runtimeExecution.getStateTimestamp(ExecutionState.DEPLOYING)).isEqualTo(archivedExecution.getStateTimestamp(ExecutionState.DEPLOYING));
        Assertions.assertThat((long)runtimeExecution.getStateTimestamp(ExecutionState.INITIALIZING)).isEqualTo(archivedExecution.getStateTimestamp(ExecutionState.INITIALIZING));
        Assertions.assertThat((long)runtimeExecution.getStateTimestamp(ExecutionState.RUNNING)).isEqualTo(archivedExecution.getStateTimestamp(ExecutionState.RUNNING));
        Assertions.assertThat((long)runtimeExecution.getStateTimestamp(ExecutionState.FINISHED)).isEqualTo(archivedExecution.getStateTimestamp(ExecutionState.FINISHED));
        Assertions.assertThat((long)runtimeExecution.getStateTimestamp(ExecutionState.CANCELING)).isEqualTo(archivedExecution.getStateTimestamp(ExecutionState.CANCELING));
        Assertions.assertThat((long)runtimeExecution.getStateTimestamp(ExecutionState.CANCELED)).isEqualTo(archivedExecution.getStateTimestamp(ExecutionState.CANCELED));
        Assertions.assertThat((long)runtimeExecution.getStateTimestamp(ExecutionState.FAILED)).isEqualTo(archivedExecution.getStateTimestamp(ExecutionState.FAILED));
        Assertions.assertThat((long)runtimeExecution.getStateEndTimestamp(ExecutionState.CREATED)).isEqualTo(archivedExecution.getStateEndTimestamp(ExecutionState.CREATED));
        Assertions.assertThat((long)runtimeExecution.getStateEndTimestamp(ExecutionState.SCHEDULED)).isEqualTo(archivedExecution.getStateEndTimestamp(ExecutionState.SCHEDULED));
        Assertions.assertThat((long)runtimeExecution.getStateEndTimestamp(ExecutionState.DEPLOYING)).isEqualTo(archivedExecution.getStateEndTimestamp(ExecutionState.DEPLOYING));
        Assertions.assertThat((long)runtimeExecution.getStateEndTimestamp(ExecutionState.INITIALIZING)).isEqualTo(archivedExecution.getStateEndTimestamp(ExecutionState.INITIALIZING));
        Assertions.assertThat((long)runtimeExecution.getStateEndTimestamp(ExecutionState.RUNNING)).isEqualTo(archivedExecution.getStateEndTimestamp(ExecutionState.RUNNING));
        Assertions.assertThat((long)runtimeExecution.getStateEndTimestamp(ExecutionState.FINISHED)).isEqualTo(archivedExecution.getStateEndTimestamp(ExecutionState.FINISHED));
        Assertions.assertThat((long)runtimeExecution.getStateEndTimestamp(ExecutionState.CANCELING)).isEqualTo(archivedExecution.getStateEndTimestamp(ExecutionState.CANCELING));
        Assertions.assertThat((long)runtimeExecution.getStateEndTimestamp(ExecutionState.CANCELED)).isEqualTo(archivedExecution.getStateEndTimestamp(ExecutionState.CANCELED));
        Assertions.assertThat((long)runtimeExecution.getStateEndTimestamp(ExecutionState.FAILED)).isEqualTo(archivedExecution.getStateEndTimestamp(ExecutionState.FAILED));
        ArchivedExecutionGraphTestUtils.compareStringifiedAccumulators(runtimeExecution.getUserAccumulatorsStringified(), archivedExecution.getUserAccumulatorsStringified());
        Assertions.assertThat((int)runtimeExecution.getParallelSubtaskIndex()).isEqualTo(archivedExecution.getParallelSubtaskIndex());
    }

    static void compareStringifiedAccumulators(StringifiedAccumulatorResult[] runtimeAccs, StringifiedAccumulatorResult[] archivedAccs) {
        Assertions.assertThat((int)runtimeAccs.length).isEqualTo(archivedAccs.length);
        for (int x = 0; x < runtimeAccs.length; ++x) {
            StringifiedAccumulatorResult runtimeResult = runtimeAccs[x];
            StringifiedAccumulatorResult archivedResult = archivedAccs[x];
            Assertions.assertThat((String)runtimeResult.getName()).isEqualTo(archivedResult.getName());
            Assertions.assertThat((String)runtimeResult.getType()).isEqualTo(archivedResult.getType());
            Assertions.assertThat((String)runtimeResult.getValue()).isEqualTo(archivedResult.getValue());
        }
    }

    static void compareSerializedAccumulators(Map<String, SerializedValue<OptionalFailure<Object>>> runtimeAccs, Map<String, SerializedValue<OptionalFailure<Object>>> archivedAccs) throws IOException, ClassNotFoundException {
        Assertions.assertThat((int)runtimeAccs.size()).isEqualTo(archivedAccs.size());
        for (Map.Entry<String, SerializedValue<OptionalFailure<Object>>> runtimeAcc : runtimeAccs.entrySet()) {
            long runtimeUserAcc = (Long)((OptionalFailure)runtimeAcc.getValue().deserializeValue(ClassLoader.getSystemClassLoader())).getUnchecked();
            long archivedUserAcc = (Long)((OptionalFailure)archivedAccs.get(runtimeAcc.getKey()).deserializeValue(ClassLoader.getSystemClassLoader())).getUnchecked();
            Assertions.assertThat((long)runtimeUserAcc).isEqualTo(archivedUserAcc);
        }
    }
}

