/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import org.apache.flink.runtime.checkpoint.CheckpointException;
import org.apache.flink.runtime.checkpoint.CheckpointFailureManager;
import org.apache.flink.runtime.checkpoint.CheckpointFailureReason;
import org.apache.flink.runtime.checkpoint.CheckpointProperties;
import org.apache.flink.runtime.checkpoint.CheckpointRetentionPolicy;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.util.TestLogger;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class CheckpointFailureManagerTest
extends TestLogger {
    CheckpointFailureManagerTest() {
    }

    @Test
    void testIgnoresPastCheckpoints() {
        TestFailJobCallback callback = new TestFailJobCallback();
        CheckpointFailureManager failureManager = new CheckpointFailureManager(2, (CheckpointFailureManager.FailJobCallback)callback);
        CheckpointProperties checkpointProperties = CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.NEVER_RETAIN_AFTER_TERMINATION);
        failureManager.handleJobLevelCheckpointException(checkpointProperties, new CheckpointException(CheckpointFailureReason.CHECKPOINT_EXPIRED), 1L);
        failureManager.handleJobLevelCheckpointException(checkpointProperties, new CheckpointException(CheckpointFailureReason.CHECKPOINT_EXPIRED), 2L);
        failureManager.handleCheckpointSuccess(2L);
        failureManager.handleJobLevelCheckpointException(checkpointProperties, new CheckpointException(CheckpointFailureReason.CHECKPOINT_EXPIRED), 1L);
        failureManager.handleJobLevelCheckpointException(checkpointProperties, new CheckpointException(CheckpointFailureReason.CHECKPOINT_EXPIRED), 3L);
        failureManager.handleJobLevelCheckpointException(checkpointProperties, new CheckpointException(CheckpointFailureReason.CHECKPOINT_EXPIRED), 4L);
        Assertions.assertThat((int)callback.getInvokeCounter()).isZero();
    }

    @Test
    void testContinuousFailure() {
        TestFailJobCallback callback = new TestFailJobCallback();
        CheckpointFailureManager failureManager = new CheckpointFailureManager(2, (CheckpointFailureManager.FailJobCallback)callback);
        CheckpointProperties checkpointProperties = CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.NEVER_RETAIN_AFTER_TERMINATION);
        failureManager.handleJobLevelCheckpointException(checkpointProperties, new CheckpointException(CheckpointFailureReason.CHECKPOINT_DECLINED), 1L);
        failureManager.handleJobLevelCheckpointException(checkpointProperties, new CheckpointException(CheckpointFailureReason.CHECKPOINT_DECLINED), 2L);
        failureManager.handleJobLevelCheckpointException(checkpointProperties, new CheckpointException(CheckpointFailureReason.JOB_FAILOVER_REGION), 3L);
        failureManager.handleJobLevelCheckpointException(checkpointProperties, new CheckpointException(CheckpointFailureReason.CHECKPOINT_DECLINED), 4L);
        Assertions.assertThat((int)callback.getInvokeCounter()).isOne();
    }

    @Test
    void testBreakContinuousFailure() {
        TestFailJobCallback callback = new TestFailJobCallback();
        CheckpointFailureManager failureManager = new CheckpointFailureManager(2, (CheckpointFailureManager.FailJobCallback)callback);
        CheckpointProperties checkpointProperties = CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.NEVER_RETAIN_AFTER_TERMINATION);
        failureManager.handleJobLevelCheckpointException(checkpointProperties, new CheckpointException(CheckpointFailureReason.IO_EXCEPTION), 1L);
        failureManager.handleJobLevelCheckpointException(checkpointProperties, new CheckpointException(CheckpointFailureReason.CHECKPOINT_DECLINED), 2L);
        failureManager.handleJobLevelCheckpointException(checkpointProperties, new CheckpointException(CheckpointFailureReason.JOB_FAILOVER_REGION), 3L);
        failureManager.handleCheckpointSuccess(4L);
        failureManager.handleJobLevelCheckpointException(checkpointProperties, new CheckpointException(CheckpointFailureReason.CHECKPOINT_EXPIRED), 5L);
        Assertions.assertThat((int)callback.getInvokeCounter()).isZero();
    }

    @Test
    void testTotalCountValue() {
        TestFailJobCallback callback = new TestFailJobCallback();
        CheckpointProperties checkpointProperties = CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.NEVER_RETAIN_AFTER_TERMINATION);
        CheckpointFailureManager failureManager = new CheckpointFailureManager(0, (CheckpointFailureManager.FailJobCallback)callback);
        for (CheckpointFailureReason reason : CheckpointFailureReason.values()) {
            failureManager.handleJobLevelCheckpointException(checkpointProperties, new CheckpointException(reason), -2L);
        }
        Assertions.assertThat((int)callback.getInvokeCounter()).isEqualTo(5);
    }

    @Test
    void testIgnoreOneCheckpointRepeatedlyCountMultiTimes() {
        TestFailJobCallback callback = new TestFailJobCallback();
        CheckpointFailureManager failureManager = new CheckpointFailureManager(2, (CheckpointFailureManager.FailJobCallback)callback);
        CheckpointProperties checkpointProperties = CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.NEVER_RETAIN_AFTER_TERMINATION);
        failureManager.handleJobLevelCheckpointException(checkpointProperties, new CheckpointException(CheckpointFailureReason.CHECKPOINT_DECLINED), 1L);
        failureManager.handleJobLevelCheckpointException(checkpointProperties, new CheckpointException(CheckpointFailureReason.CHECKPOINT_DECLINED), 2L);
        failureManager.handleJobLevelCheckpointException(checkpointProperties, new CheckpointException(CheckpointFailureReason.JOB_FAILOVER_REGION), 3L);
        failureManager.handleJobLevelCheckpointException(checkpointProperties, new CheckpointException(CheckpointFailureReason.CHECKPOINT_DECLINED), 2L);
        Assertions.assertThat((int)callback.getInvokeCounter()).isZero();
    }

    private static class TestFailJobCallback
    implements CheckpointFailureManager.FailJobCallback {
        private int invokeCounter = 0;

        private TestFailJobCallback() {
        }

        public void failJob(Throwable cause) {
            ++this.invokeCounter;
        }

        public void failJobDueToTaskFailure(Throwable cause, ExecutionAttemptID executionAttemptID) {
            ++this.invokeCounter;
        }

        public int getInvokeCounter() {
            return this.invokeCounter;
        }
    }
}

