/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.blob.BlobCacheSizeTracker;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BlobCacheSizeTrackerTest
extends TestLogger {
    private BlobCacheSizeTracker tracker;
    private JobID jobId;
    private BlobKey blobKey;

    @Before
    public void setup() {
        this.tracker = new BlobCacheSizeTracker(5L);
        this.jobId = new JobID();
        this.blobKey = BlobKey.createKey((BlobKey.BlobType)BlobKey.BlobType.PERMANENT_BLOB);
        this.tracker.track(this.jobId, this.blobKey, 3L);
    }

    @Test
    public void testCheckLimit() {
        List keys = this.tracker.checkLimit(3L);
        Assert.assertEquals((long)1L, (long)keys.size());
        Assert.assertEquals((Object)this.jobId, (Object)((Tuple2)keys.get((int)0)).f0);
        Assert.assertEquals((Object)this.blobKey, (Object)((Tuple2)keys.get((int)0)).f1);
    }

    @Test
    public void testCheckLimitForEmptyBlob() {
        List keys = this.tracker.checkLimit(0L);
        Assert.assertEquals((long)0L, (long)keys.size());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCheckLimitForBlobWithNegativeSize() {
        this.tracker.checkLimit(-1L);
    }

    @Test
    public void testTrack() {
        Assert.assertEquals((long)3L, (long)this.tracker.getSize(this.jobId, this.blobKey));
        Assert.assertTrue((boolean)this.tracker.getBlobKeysByJobId(this.jobId).contains(this.blobKey));
    }

    @Test
    public void testTrackDuplicatedBlob() {
        this.tracker.track(this.jobId, this.blobKey, 1L);
        Assert.assertEquals((long)3L, (long)this.tracker.getSize(this.jobId, this.blobKey));
        Assert.assertEquals((long)1L, (long)this.tracker.getBlobKeysByJobId(this.jobId).size());
    }

    @Test
    public void testUntrack() {
        Assert.assertEquals((long)1L, (long)this.tracker.checkLimit(3L).size());
        this.tracker.untrack(Tuple2.of((Object)this.jobId, (Object)this.blobKey));
        Assert.assertNull((Object)this.tracker.getSize(this.jobId, this.blobKey));
        Assert.assertEquals((long)0L, (long)this.tracker.getBlobKeysByJobId(this.jobId).size());
        Assert.assertEquals((long)0L, (long)this.tracker.checkLimit(3L).size());
    }

    @Test
    public void testUntrackNonExistingBlob() {
        this.tracker.untrack(Tuple2.of((Object)this.jobId, (Object)BlobKey.createKey((BlobKey.BlobType)BlobKey.BlobType.PERMANENT_BLOB)));
        Assert.assertEquals((long)1L, (long)this.tracker.getBlobKeysByJobId(this.jobId).size());
    }

    @Test(expected=NullPointerException.class)
    public void testUntrackBlobWithNullJobId() {
        this.tracker.untrack(Tuple2.of(null, (Object)BlobKey.createKey((BlobKey.BlobType)BlobKey.BlobType.PERMANENT_BLOB)));
    }

    @Test
    public void testUpdate() {
        int i;
        BlobCacheSizeTracker tracker = new BlobCacheSizeTracker(5L);
        ArrayList<JobID> jobIds = new ArrayList<JobID>();
        ArrayList<BlobKey> blobKeys = new ArrayList<BlobKey>();
        for (i = 0; i < 5; ++i) {
            jobIds.add(new JobID());
            blobKeys.add(BlobKey.createKey((BlobKey.BlobType)BlobKey.BlobType.PERMANENT_BLOB));
        }
        for (i = 0; i < 5; ++i) {
            tracker.track((JobID)jobIds.get(i), (BlobKey)blobKeys.get(i), 1L);
        }
        tracker.update((JobID)jobIds.get(1), (BlobKey)blobKeys.get(1));
        tracker.update((JobID)jobIds.get(2), (BlobKey)blobKeys.get(2));
        List blobsToDelete = tracker.checkLimit(2L);
        MatcherAssert.assertThat((Object)blobsToDelete, (Matcher)Matchers.containsInAnyOrder((Object[])new Tuple2[]{Tuple2.of(jobIds.get(0), blobKeys.get(0)), Tuple2.of(jobIds.get(3), blobKeys.get(3))}));
    }

    @Test
    public void testUpdateNonExistingBlob() {
        this.tracker.track(new JobID(), BlobKey.createKey((BlobKey.BlobType)BlobKey.BlobType.PERMANENT_BLOB), 2L);
        Assert.assertEquals((long)1L, (long)this.tracker.checkLimit(3L).size());
        this.tracker.update(new JobID(), BlobKey.createKey((BlobKey.BlobType)BlobKey.BlobType.PERMANENT_BLOB));
        Assert.assertEquals((long)1L, (long)this.tracker.checkLimit(3L).size());
    }

    @Test
    public void testUntrackAll() {
        this.tracker.track(this.jobId, BlobKey.createKey((BlobKey.BlobType)BlobKey.BlobType.PERMANENT_BLOB), 1L);
        JobID anotherJobId = new JobID();
        this.tracker.track(anotherJobId, BlobKey.createKey((BlobKey.BlobType)BlobKey.BlobType.PERMANENT_BLOB), 1L);
        Assert.assertEquals((long)2L, (long)this.tracker.getBlobKeysByJobId(this.jobId).size());
        this.tracker.untrackAll(this.jobId);
        Assert.assertEquals((long)0L, (long)this.tracker.getBlobKeysByJobId(this.jobId).size());
        Assert.assertEquals((long)1L, (long)this.tracker.getBlobKeysByJobId(anotherJobId).size());
    }

    @Test
    public void testUntrackAllWithNonExistingJob() {
        this.tracker.track(this.jobId, BlobKey.createKey((BlobKey.BlobType)BlobKey.BlobType.PERMANENT_BLOB), 1L);
        Assert.assertEquals((long)2L, (long)this.tracker.getBlobKeysByJobId(this.jobId).size());
        this.tracker.untrackAll(new JobID());
        Assert.assertEquals((long)2L, (long)this.tracker.getBlobKeysByJobId(this.jobId).size());
    }
}

