/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph.tasks;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import javax.annotation.Nullable;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.checkpoint.CheckpointException;
import org.apache.flink.runtime.checkpoint.CheckpointMetaData;
import org.apache.flink.runtime.checkpoint.CheckpointMetricsBuilder;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.jobgraph.tasks.CheckpointableTask;
import org.apache.flink.runtime.jobgraph.tasks.CoordinatedTask;
import org.apache.flink.runtime.jobgraph.tasks.TaskInvokable;
import org.apache.flink.runtime.operators.coordination.OperatorEvent;
import org.apache.flink.runtime.taskmanager.Task;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.SerializedValue;

public abstract class AbstractInvokable
implements TaskInvokable,
CheckpointableTask,
CoordinatedTask {
    private final Environment environment;

    public AbstractInvokable(Environment environment) {
        this.environment = (Environment)Preconditions.checkNotNull((Object)environment);
    }

    @Override
    public abstract void invoke() throws Exception;

    @Override
    public void cancel() throws Exception {
    }

    @Override
    public void cleanUp(@Nullable Throwable throwable) throws Exception {
    }

    @Override
    public void maybeInterruptOnCancel(Thread toInterrupt, @Nullable String taskName, @Nullable Long timeout) {
        if (taskName != null && timeout != null) {
            Task.logTaskThreadStackTrace(toInterrupt, taskName, timeout, "interrupting");
        }
        toInterrupt.interrupt();
    }

    public final Environment getEnvironment() {
        return this.environment;
    }

    public final ClassLoader getUserCodeClassLoader() {
        return this.getEnvironment().getUserCodeClassLoader().asClassLoader();
    }

    public int getCurrentNumberOfSubtasks() {
        return this.environment.getTaskInfo().getNumberOfParallelSubtasks();
    }

    public int getIndexInSubtaskGroup() {
        return this.environment.getTaskInfo().getIndexOfThisSubtask();
    }

    public final Configuration getTaskConfiguration() {
        return this.environment.getTaskConfiguration();
    }

    public Configuration getJobConfiguration() {
        return this.environment.getJobConfiguration();
    }

    public ExecutionConfig getExecutionConfig() {
        return this.environment.getExecutionConfig();
    }

    @Override
    public CompletableFuture<Boolean> triggerCheckpointAsync(CheckpointMetaData checkpointMetaData, CheckpointOptions checkpointOptions) {
        throw new UnsupportedOperationException(String.format("triggerCheckpointAsync not supported by %s", this.getClass().getName()));
    }

    @Override
    public void triggerCheckpointOnBarrier(CheckpointMetaData checkpointMetaData, CheckpointOptions checkpointOptions, CheckpointMetricsBuilder checkpointMetrics) throws IOException {
        throw new UnsupportedOperationException(String.format("triggerCheckpointOnBarrier not supported by %s", this.getClass().getName()));
    }

    @Override
    public void abortCheckpointOnBarrier(long checkpointId, CheckpointException cause) throws IOException {
        throw new UnsupportedOperationException(String.format("abortCheckpointOnBarrier not supported by %s", this.getClass().getName()));
    }

    @Override
    public Future<Void> notifyCheckpointCompleteAsync(long checkpointId) {
        throw new UnsupportedOperationException(String.format("notifyCheckpointCompleteAsync not supported by %s", this.getClass().getName()));
    }

    @Override
    public Future<Void> notifyCheckpointAbortAsync(long checkpointId, long latestCompletedCheckpointId) {
        throw new UnsupportedOperationException(String.format("notifyCheckpointAbortAsync not supported by %s", this.getClass().getName()));
    }

    @Override
    public Future<Void> notifyCheckpointSubsumedAsync(long checkpointId) {
        throw new UnsupportedOperationException(String.format("notifyCheckpointSubsumeAsync not supported by %s", this.getClass().getName()));
    }

    @Override
    public void dispatchOperatorEvent(OperatorID operator, SerializedValue<OperatorEvent> event) throws FlinkException {
        throw new UnsupportedOperationException("dispatchOperatorEvent not supported by " + this.getClass().getName());
    }

    @Override
    public void restore() throws Exception {
    }

    @Override
    public boolean isUsingNonBlockingInput() {
        return false;
    }
}

