/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.apache.flink.runtime.io.network.partition.BufferAvailabilityListener;
import org.apache.flink.runtime.io.network.partition.PipelinedSubpartition;
import org.apache.flink.runtime.io.network.partition.ProducerFailedException;
import org.apache.flink.runtime.io.network.partition.ResultSubpartition;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionView;
import org.apache.flink.util.Preconditions;

public class PipelinedSubpartitionView
implements ResultSubpartitionView {
    private final PipelinedSubpartition parent;
    private final BufferAvailabilityListener availabilityListener;
    final AtomicBoolean isReleased;

    public PipelinedSubpartitionView(PipelinedSubpartition parent, BufferAvailabilityListener listener) {
        this.parent = (PipelinedSubpartition)Preconditions.checkNotNull((Object)parent);
        this.availabilityListener = (BufferAvailabilityListener)Preconditions.checkNotNull((Object)listener);
        this.isReleased = new AtomicBoolean();
    }

    @Override
    @Nullable
    public ResultSubpartition.BufferAndBacklog getNextBuffer() {
        return this.parent.pollBuffer();
    }

    @Override
    public void notifyDataAvailable() {
        this.availabilityListener.notifyDataAvailable();
    }

    @Override
    public void notifyPriorityEvent(int priorityBufferNumber) {
        this.availabilityListener.notifyPriorityEvent(priorityBufferNumber);
    }

    @Override
    public void releaseAllResources() {
        if (this.isReleased.compareAndSet(false, true)) {
            this.parent.onConsumedSubpartition();
        }
    }

    @Override
    public boolean isReleased() {
        return this.isReleased.get() || this.parent.isReleased();
    }

    @Override
    public void resumeConsumption() {
        this.parent.resumeConsumption();
    }

    @Override
    public void acknowledgeAllDataProcessed() {
        this.parent.acknowledgeAllDataProcessed();
    }

    @Override
    public ResultSubpartitionView.AvailabilityWithBacklog getAvailabilityAndBacklog(int numCreditsAvailable) {
        return this.parent.getAvailabilityAndBacklog(numCreditsAvailable);
    }

    @Override
    public Throwable getFailureCause() {
        Throwable cause = this.parent.getFailureCause();
        if (cause != null) {
            return new ProducerFailedException(cause);
        }
        return null;
    }

    @Override
    public int unsynchronizedGetNumberOfQueuedBuffers() {
        return this.parent.unsynchronizedGetNumberOfQueuedBuffers();
    }

    @Override
    public int getNumberOfQueuedBuffers() {
        return this.parent.getNumberOfQueuedBuffers();
    }

    @Override
    public void notifyNewBufferSize(int newBufferSize) {
        this.parent.bufferSize(newBufferSize);
    }

    public String toString() {
        return String.format("%s(index: %d) of ResultPartition %s", this.getClass().getSimpleName(), this.parent.getSubPartitionIndex(), this.parent.parent.getPartitionId());
    }
}

