/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.io.IOException;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.blob.BlobStore;
import org.apache.flink.runtime.blob.VoidBlobStore;
import org.junit.rules.ExternalResource;
import org.junit.rules.TemporaryFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlobServerResource
extends ExternalResource {
    private static final Logger LOG = LoggerFactory.getLogger(BlobServerResource.class);
    private final TemporaryFolder temporaryFolder = new TemporaryFolder();
    private BlobServer blobServer;

    protected void before() throws Throwable {
        this.temporaryFolder.create();
        Configuration config = new Configuration();
        this.blobServer = new BlobServer(config, this.temporaryFolder.newFolder(), (BlobStore)new VoidBlobStore());
        this.blobServer.start();
    }

    protected void after() {
        this.temporaryFolder.delete();
        try {
            this.blobServer.close();
        }
        catch (IOException e) {
            LOG.error("Exception while shutting down blob server.", (Throwable)e);
        }
    }

    public int getBlobServerPort() {
        return this.blobServer.getPort();
    }

    public BlobServer getBlobServer() {
        return this.blobServer;
    }
}

