/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.shuffle;

import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.shuffle.PartitionDescriptor;

public class PartitionDescriptorBuilder {
    private IntermediateResultPartitionID partitionId = new IntermediateResultPartitionID();
    private ResultPartitionType partitionType = ResultPartitionType.PIPELINED;
    private int totalNumberOfPartitions = 1;

    private PartitionDescriptorBuilder() {
    }

    public PartitionDescriptorBuilder setPartitionId(IntermediateResultPartitionID partitionId) {
        this.partitionId = partitionId;
        return this;
    }

    public PartitionDescriptorBuilder setPartitionType(ResultPartitionType partitionType) {
        this.partitionType = partitionType;
        return this;
    }

    public PartitionDescriptorBuilder setTotalNumberOfPartitions(int totalNumberOfPartitions) {
        this.totalNumberOfPartitions = totalNumberOfPartitions;
        return this;
    }

    public PartitionDescriptor build() {
        return new PartitionDescriptor(new IntermediateDataSetID(), this.totalNumberOfPartitions, this.partitionId, this.partitionType, 1, 0);
    }

    public static PartitionDescriptorBuilder newBuilder() {
        return new PartitionDescriptorBuilder();
    }
}

