/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.instance.InstanceID;
import org.apache.flink.runtime.resourcemanager.WorkerResourceSpec;
import org.apache.flink.runtime.resourcemanager.slotmanager.ResourceActions;
import org.apache.flink.runtime.slots.ResourceRequirement;

public class TestingResourceActions
implements ResourceActions {
    @Nonnull
    private final BiConsumer<InstanceID, Exception> releaseResourceConsumer;
    @Nonnull
    private final Function<WorkerResourceSpec, Boolean> allocateResourceFunction;
    @Nonnull
    private final Consumer<Tuple3<JobID, AllocationID, Exception>> notifyAllocationFailureConsumer;
    @Nonnull
    private final BiConsumer<JobID, Collection<ResourceRequirement>> notifyNotEnoughResourcesConsumer;

    public TestingResourceActions(@Nonnull BiConsumer<InstanceID, Exception> releaseResourceConsumer, @Nonnull Function<WorkerResourceSpec, Boolean> allocateResourceFunction, @Nonnull Consumer<Tuple3<JobID, AllocationID, Exception>> notifyAllocationFailureConsumer, @Nonnull BiConsumer<JobID, Collection<ResourceRequirement>> notifyNotEnoughResourcesConsumer) {
        this.releaseResourceConsumer = releaseResourceConsumer;
        this.allocateResourceFunction = allocateResourceFunction;
        this.notifyAllocationFailureConsumer = notifyAllocationFailureConsumer;
        this.notifyNotEnoughResourcesConsumer = notifyNotEnoughResourcesConsumer;
    }

    public void releaseResource(InstanceID instanceId, Exception cause) {
        this.releaseResourceConsumer.accept(instanceId, cause);
    }

    public boolean allocateResource(WorkerResourceSpec workerResourceSpec) {
        return this.allocateResourceFunction.apply(workerResourceSpec);
    }

    public void notifyAllocationFailure(JobID jobId, AllocationID allocationId, Exception cause) {
        this.notifyAllocationFailureConsumer.accept((Tuple3<JobID, AllocationID, Exception>)Tuple3.of((Object)jobId, (Object)allocationId, (Object)cause));
    }

    public void notifyNotEnoughResourcesAvailable(JobID jobId, Collection<ResourceRequirement> acquiredResources) {
        this.notifyNotEnoughResourcesConsumer.accept(jobId, acquiredResources);
    }
}

