/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.testutils;

import java.io.IOException;
import org.apache.flink.runtime.operators.testutils.types.StringPair;
import org.apache.flink.util.MutableObjectIterator;

public class UniformStringPairGenerator
implements MutableObjectIterator<StringPair> {
    private final int numKeys;
    private final int numVals;
    private int keyCnt = 0;
    private int valCnt = 0;
    private boolean repeatKey;

    public UniformStringPairGenerator(int numKeys, int numVals, boolean repeatKey) {
        this.numKeys = numKeys;
        this.numVals = numVals;
        this.repeatKey = repeatKey;
    }

    public StringPair next(StringPair target) throws IOException {
        if (!this.repeatKey) {
            if (this.valCnt >= this.numVals) {
                return null;
            }
            target.setKey(Integer.toString(this.keyCnt++));
            target.setValue(Integer.toBinaryString(this.valCnt));
            if (this.keyCnt == this.numKeys) {
                this.keyCnt = 0;
                ++this.valCnt;
            }
        } else {
            if (this.keyCnt >= this.numKeys) {
                return null;
            }
            target.setKey(Integer.toString(this.keyCnt));
            target.setValue(Integer.toBinaryString(this.valCnt++));
            if (this.valCnt == this.numVals) {
                this.valCnt = 0;
                ++this.keyCnt;
            }
        }
        return target;
    }

    public StringPair next() throws IOException {
        return this.next(new StringPair());
    }
}

