/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.utils;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.flink.runtime.jobmaster.JobResult;
import org.apache.flink.util.SerializedThrowable;

public final class JobResultUtils {
    public static void assertSuccess(JobResult result) {
        JobResultUtils.throwAssertionErrorOnFailedResult(result);
    }

    public static void assertIncomplete(CompletableFuture<JobResult> result) {
        if (result.isDone()) {
            JobResult jobResult;
            try {
                jobResult = result.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new AssertionError("Unexpected exception when processing finished future.", e);
            }
            if (jobResult.isSuccess()) {
                throw new AssertionError((Object)"Job finished successfully.");
            }
            JobResultUtils.throwAssertionErrorOnFailedResult(jobResult);
        }
    }

    private static void throwAssertionErrorOnFailedResult(JobResult result) {
        if (!result.isSuccess()) {
            if (result.getSerializedThrowable().isPresent()) {
                throw new AssertionError("Job failed.", ((SerializedThrowable)result.getSerializedThrowable().get()).deserializeError(JobResultUtils.class.getClassLoader()));
            }
            throw new AssertionError((Object)"Job was not successful but did not fail with an error.");
        }
    }
}

