/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.jobmaster.SlotRequestId;
import org.apache.flink.runtime.jobmaster.slotpool.PendingRequest;
import org.apache.flink.runtime.jobmaster.slotpool.PreferredAllocationRequestSlotMatchingStrategy;
import org.apache.flink.runtime.jobmaster.slotpool.RequestSlotMatchingStrategy;
import org.apache.flink.runtime.scheduler.TestingPhysicalSlot;
import org.apache.flink.util.TestLoggerExtension;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={TestLoggerExtension.class})
public class PreferredAllocationRequestSlotMatchingStrategyTest {
    @Test
    public void testNewSlotsAreMatchedAgainstPreferredAllocationIDs() throws Exception {
        PreferredAllocationRequestSlotMatchingStrategy strategy = PreferredAllocationRequestSlotMatchingStrategy.INSTANCE;
        AllocationID allocationId1 = new AllocationID();
        AllocationID allocationId2 = new AllocationID();
        List<TestingPhysicalSlot> slots = Arrays.asList(TestingPhysicalSlot.builder().withAllocationID(allocationId1).build(), TestingPhysicalSlot.builder().withAllocationID(allocationId2).build());
        List<PendingRequest> pendingRequests = Arrays.asList(PendingRequest.createNormalRequest((SlotRequestId)new SlotRequestId(), (ResourceProfile)ResourceProfile.UNKNOWN, Collections.singleton(allocationId2)), PendingRequest.createNormalRequest((SlotRequestId)new SlotRequestId(), (ResourceProfile)ResourceProfile.UNKNOWN, Collections.singleton(allocationId1)));
        Collection requestSlotMatches = strategy.matchRequestsAndSlots(slots, pendingRequests);
        Assertions.assertThat((Collection)requestSlotMatches).hasSize(2);
        for (RequestSlotMatchingStrategy.RequestSlotMatch requestSlotMatch : requestSlotMatches) {
            Assertions.assertThat((Collection)requestSlotMatch.getPendingRequest().getPreferredAllocations()).contains((Object[])new AllocationID[]{requestSlotMatch.getSlot().getAllocationId()});
        }
    }
}

