/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutorServiceAdapter;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionGraphTestUtils;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.executiongraph.utils.SimpleAckingTaskManagerGateway;
import org.apache.flink.runtime.jobgraph.JobGraphTestUtils;
import org.apache.flink.runtime.jobmaster.TestingLogicalSlot;
import org.apache.flink.runtime.jobmaster.TestingLogicalSlotBuilder;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.scheduler.DefaultScheduler;
import org.apache.flink.runtime.scheduler.SchedulerTestingUtils;
import org.apache.flink.util.TestLogger;
import org.apache.flink.util.concurrent.FutureUtils;
import org.junit.Assert;
import org.junit.Test;

public class ExecutionVertexCancelTest
extends TestLogger {
    @Test
    public void testCancelFromCreated() {
        try {
            ExecutionVertex vertex = ExecutionGraphTestUtils.getExecutionVertex();
            Assert.assertEquals((Object)ExecutionState.CREATED, (Object)vertex.getExecutionState());
            vertex.cancel();
            Assert.assertEquals((Object)ExecutionState.CANCELED, (Object)vertex.getExecutionState());
            Assert.assertFalse((boolean)vertex.getFailureInfo().isPresent());
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.CREATED) > 0L ? 1 : 0) != 0);
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.CANCELING) > 0L ? 1 : 0) != 0);
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.CANCELED) > 0L ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testCancelFromScheduled() {
        try {
            ExecutionVertex vertex = ExecutionGraphTestUtils.getExecutionVertex();
            ExecutionGraphTestUtils.setVertexState(vertex, ExecutionState.SCHEDULED);
            Assert.assertEquals((Object)ExecutionState.SCHEDULED, (Object)vertex.getExecutionState());
            vertex.cancel();
            Assert.assertEquals((Object)ExecutionState.CANCELED, (Object)vertex.getExecutionState());
            Assert.assertFalse((boolean)vertex.getFailureInfo().isPresent());
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.CREATED) > 0L ? 1 : 0) != 0);
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.CANCELING) > 0L ? 1 : 0) != 0);
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.CANCELED) > 0L ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testCancelFromRunning() {
        try {
            ExecutionVertex vertex = ExecutionGraphTestUtils.getExecutionVertex();
            TestingLogicalSlot slot = new TestingLogicalSlotBuilder().setTaskManagerGateway(new CancelSequenceSimpleAckingTaskManagerGateway(1)).createTestingLogicalSlot();
            ExecutionGraphTestUtils.setVertexResource(vertex, slot);
            ExecutionGraphTestUtils.setVertexState(vertex, ExecutionState.RUNNING);
            Assert.assertEquals((Object)ExecutionState.RUNNING, (Object)vertex.getExecutionState());
            vertex.cancel();
            vertex.getCurrentExecutionAttempt().completeCancelling();
            Assert.assertEquals((Object)ExecutionState.CANCELED, (Object)vertex.getExecutionState());
            Assert.assertFalse((boolean)slot.isAlive());
            Assert.assertFalse((boolean)vertex.getFailureInfo().isPresent());
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.CREATED) > 0L ? 1 : 0) != 0);
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.CANCELING) > 0L ? 1 : 0) != 0);
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.CANCELED) > 0L ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testRepeatedCancelFromRunning() {
        try {
            ExecutionVertex vertex = ExecutionGraphTestUtils.getExecutionVertex();
            TestingLogicalSlot slot = new TestingLogicalSlotBuilder().setTaskManagerGateway(new CancelSequenceSimpleAckingTaskManagerGateway(1)).createTestingLogicalSlot();
            ExecutionGraphTestUtils.setVertexResource(vertex, slot);
            ExecutionGraphTestUtils.setVertexState(vertex, ExecutionState.RUNNING);
            Assert.assertEquals((Object)ExecutionState.RUNNING, (Object)vertex.getExecutionState());
            vertex.cancel();
            Assert.assertEquals((Object)ExecutionState.CANCELING, (Object)vertex.getExecutionState());
            vertex.cancel();
            Assert.assertEquals((Object)ExecutionState.CANCELING, (Object)vertex.getExecutionState());
            vertex.getCurrentExecutionAttempt().completeCancelling();
            Assert.assertEquals((Object)ExecutionState.CANCELED, (Object)vertex.getExecutionState());
            Assert.assertFalse((boolean)slot.isAlive());
            Assert.assertFalse((boolean)vertex.getFailureInfo().isPresent());
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.CREATED) > 0L ? 1 : 0) != 0);
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.CANCELING) > 0L ? 1 : 0) != 0);
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.CANCELED) > 0L ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testCancelFromRunningDidNotFindTask() {
        try {
            ExecutionVertex vertex = ExecutionGraphTestUtils.getExecutionVertex();
            TestingLogicalSlot slot = new TestingLogicalSlotBuilder().setTaskManagerGateway(new CancelSequenceSimpleAckingTaskManagerGateway(1)).createTestingLogicalSlot();
            ExecutionGraphTestUtils.setVertexResource(vertex, slot);
            ExecutionGraphTestUtils.setVertexState(vertex, ExecutionState.RUNNING);
            Assert.assertEquals((Object)ExecutionState.RUNNING, (Object)vertex.getExecutionState());
            vertex.cancel();
            Assert.assertEquals((Object)ExecutionState.CANCELING, (Object)vertex.getExecutionState());
            Assert.assertFalse((boolean)vertex.getFailureInfo().isPresent());
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.CREATED) > 0L ? 1 : 0) != 0);
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.CANCELING) > 0L ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testCancelCallFails() {
        try {
            ExecutionVertex vertex = ExecutionGraphTestUtils.getExecutionVertex();
            TestingLogicalSlot slot = new TestingLogicalSlotBuilder().setTaskManagerGateway(new CancelSequenceSimpleAckingTaskManagerGateway(0)).createTestingLogicalSlot();
            ExecutionGraphTestUtils.setVertexResource(vertex, slot);
            ExecutionGraphTestUtils.setVertexState(vertex, ExecutionState.RUNNING);
            Assert.assertEquals((Object)ExecutionState.RUNNING, (Object)vertex.getExecutionState());
            vertex.cancel();
            Assert.assertEquals((Object)ExecutionState.CANCELED, (Object)vertex.getExecutionState());
            Assert.assertFalse((boolean)slot.isAlive());
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.CREATED) > 0L ? 1 : 0) != 0);
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.CANCELING) > 0L ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSendCancelAndReceiveFail() throws Exception {
        DefaultScheduler scheduler = SchedulerTestingUtils.createScheduler(JobGraphTestUtils.streamingJobGraph(ExecutionGraphTestUtils.createNoOpVertex(10)), ComponentMainThreadExecutorServiceAdapter.forMainThread());
        ExecutionGraph graph = scheduler.getExecutionGraph();
        scheduler.startScheduling();
        ExecutionGraphTestUtils.switchAllVerticesToRunning(graph);
        Assert.assertEquals((Object)JobStatus.RUNNING, (Object)graph.getState());
        ExecutionVertex[] vertices = ((ExecutionJobVertex)graph.getVerticesTopologically().iterator().next()).getTaskVertices();
        Assert.assertEquals((long)vertices.length, (long)graph.getRegisteredExecutions().size());
        Execution exec = vertices[3].getCurrentExecutionAttempt();
        exec.cancel();
        Assert.assertEquals((Object)ExecutionState.CANCELING, (Object)exec.getState());
        exec.markFailed((Throwable)new Exception("test"));
        Assert.assertTrue((exec.getState() == ExecutionState.FAILED || exec.getState() == ExecutionState.CANCELED ? 1 : 0) != 0);
        Assert.assertFalse((boolean)exec.getAssignedResource().isAlive());
        Assert.assertEquals((long)(vertices.length - 1), (long)graph.getRegisteredExecutions().size());
    }

    private static class CancelSequenceSimpleAckingTaskManagerGateway
    extends SimpleAckingTaskManagerGateway {
        private final int successfulOperations;
        private int index = -1;

        public CancelSequenceSimpleAckingTaskManagerGateway(int successfulOperations) {
            this.successfulOperations = successfulOperations;
        }

        @Override
        public CompletableFuture<Acknowledge> cancelTask(ExecutionAttemptID executionAttemptID, Time timeout) {
            ++this.index;
            if (this.index >= this.successfulOperations) {
                return FutureUtils.completedExceptionally((Throwable)new IOException("Rpc call fails"));
            }
            return CompletableFuture.completedFuture(Acknowledge.get());
        }
    }
}

