/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.flink.runtime.util.Runnables;
import org.apache.flink.shaded.guava30.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class RunnablesTest
extends TestLogger {
    private static final int TIMEOUT_MS = 100;

    @Test
    public void testExecutorService_uncaughtExceptionHandler() throws InterruptedException {
        CountDownLatch handlerCalled = new CountDownLatch(1);
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setUncaughtExceptionHandler((t, e) -> handlerCalled.countDown()).build();
        ExecutorService executorService = Executors.newSingleThreadExecutor(threadFactory);
        executorService.execute(() -> {
            throw new RuntimeException("foo");
        });
        handlerCalled.await();
    }

    @Test
    public void testScheduledExecutorService_uncaughtExceptionHandler() throws InterruptedException {
        CountDownLatch handlerCalled = new CountDownLatch(1);
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setUncaughtExceptionHandler((t, e) -> handlerCalled.countDown()).build();
        ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(threadFactory);
        scheduledExecutorService.execute(() -> {
            throw new RuntimeException("foo");
        });
        Assert.assertFalse((String)"Expected handler not to be called.", (boolean)handlerCalled.await(100L, TimeUnit.MILLISECONDS));
    }

    @Test
    public void testWithUncaughtExceptionHandler_runtimeException() throws InterruptedException {
        RuntimeException expected = new RuntimeException("foo");
        RunnablesTest.testWithUncaughtExceptionHandler(() -> {
            throw expected;
        }, expected);
    }

    @Test
    public void testWithUncaughtExceptionHandler_error() throws InterruptedException {
        Error expected = new Error("foo");
        RunnablesTest.testWithUncaughtExceptionHandler(() -> {
            throw expected;
        }, expected);
    }

    private static void testWithUncaughtExceptionHandler(Runnable runnable, Throwable expected) throws InterruptedException {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("ueh-test-%d").build();
        ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(threadFactory);
        AtomicReference thread = new AtomicReference();
        AtomicReference throwable = new AtomicReference();
        CountDownLatch handlerCalled = new CountDownLatch(1);
        Runnable guardedRunnable = Runnables.withUncaughtExceptionHandler((Runnable)runnable, (t, e) -> {
            thread.set(t);
            throwable.set(e);
            handlerCalled.countDown();
        });
        scheduledExecutorService.execute(guardedRunnable);
        Assert.assertTrue((boolean)handlerCalled.await(100L, TimeUnit.MILLISECONDS));
        Assert.assertNotNull(thread.get());
        Assert.assertNotNull(throwable.get());
        Assert.assertEquals((Object)"ueh-test-0", (Object)((Thread)thread.get()).getName());
        Assert.assertEquals(expected.getClass(), ((Throwable)throwable.get()).getClass());
        Assert.assertEquals((Object)"foo", (Object)((Throwable)throwable.get()).getMessage());
    }
}

