/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.testutils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.flink.runtime.testutils.CommonTestUtils;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.ShutdownHookUtil;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TestJvmProcess {
    private static final Logger LOG = LoggerFactory.getLogger(TestJvmProcess.class);
    private final Object createDestroyLock = new Object();
    private final String javaCommandPath;
    private final String log4jConfigFilePath;
    private final Thread shutdownHook;
    private int jvmMemoryInMb = 80;
    private volatile Process process;
    private volatile StringWriter processOutput;
    private volatile boolean destroyed;

    public TestJvmProcess() throws Exception {
        this(CommonTestUtils.getJavaCommandPath(), CommonTestUtils.createTemporaryLog4JProperties().getPath());
    }

    public TestJvmProcess(String javaCommandPath, String log4jConfigFilePath) {
        this.javaCommandPath = (String)Preconditions.checkNotNull((Object)javaCommandPath, (String)"Java command path");
        this.log4jConfigFilePath = (String)Preconditions.checkNotNull((Object)log4jConfigFilePath, (String)"log4j config file path");
        this.shutdownHook = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    TestJvmProcess.this.destroy();
                }
                catch (Throwable t) {
                    LOG.error("Error during process cleanup shutdown hook.", t);
                }
            }
        });
    }

    public abstract String getName();

    public abstract String[] getJvmArgs();

    public abstract String getEntryPointClassName();

    public void setJVMMemory(int jvmMemoryInMb) {
        Preconditions.checkArgument((jvmMemoryInMb >= 80 ? 1 : 0) != 0, (Object)"Process JVM Requires at least 80 MBs of memory.");
        Preconditions.checkState((this.process == null ? 1 : 0) != 0, (Object)"Cannot set memory after process was started");
        this.jvmMemoryInMb = jvmMemoryInMb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startProcess() throws IOException {
        Object[] cmd = new String[]{this.javaCommandPath, "-Dlog.level=DEBUG", "-Dlog4j.configurationFile=file:" + this.log4jConfigFilePath, "-Xms" + this.jvmMemoryInMb + "m", "-Xmx" + this.jvmMemoryInMb + "m", "-classpath", CommonTestUtils.getCurrentClasspath(), this.getEntryPointClassName()};
        Object[] jvmArgs = this.getJvmArgs();
        if (jvmArgs != null && jvmArgs.length > 0) {
            cmd = (String[])ArrayUtils.addAll((Object[])cmd, (Object[])jvmArgs);
        }
        Object object = this.createDestroyLock;
        synchronized (object) {
            Preconditions.checkState((this.process == null ? 1 : 0) != 0, (Object)"process already started");
            LOG.debug("Running command '{}'.", (Object)Arrays.toString(cmd));
            this.process = new ProcessBuilder((String[])cmd).start();
            this.processOutput = new StringWriter();
            new CommonTestUtils.PipeForwarder(this.process.getErrorStream(), this.processOutput);
            try {
                Runtime.getRuntime().addShutdownHook(this.shutdownHook);
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (Throwable t) {
                LOG.error("Cannot register process cleanup shutdown hook.", t);
            }
        }
    }

    public void printProcessLog() {
        Preconditions.checkState((this.processOutput != null ? 1 : 0) != 0, (Object)"not started");
        System.out.println("-----------------------------------------");
        System.out.println(" BEGIN SPAWNED PROCESS LOG FOR " + this.getName());
        System.out.println("-----------------------------------------");
        String out = this.processOutput.toString();
        if (out == null || out.length() == 0) {
            System.out.println("(EMPTY)");
        } else {
            System.out.println(out);
        }
        System.out.println("-----------------------------------------");
        System.out.println("\t\tEND SPAWNED PROCESS LOG " + this.getName());
        System.out.println("-----------------------------------------");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.createDestroyLock;
        synchronized (object) {
            Preconditions.checkState((this.process != null ? 1 : 0) != 0, (Object)"process not started");
            if (this.destroyed) {
                return;
            }
            LOG.info("Destroying " + this.getName() + " process.");
            try {
                boolean destroyed = false;
                try {
                    Method m = this.process.getClass().getMethod("destroyForcibly", new Class[0]);
                    m.setAccessible(true);
                    m.invoke((Object)this.process, new Object[0]);
                    destroyed = true;
                }
                catch (NoSuchMethodException m) {
                }
                catch (Throwable t) {
                    LOG.error("Failed to forcibly destroy process", t);
                }
                if (!destroyed) {
                    try {
                        this.process.destroy();
                    }
                    catch (Throwable t) {
                        LOG.error("Error while trying to destroy process.", t);
                    }
                }
            }
            finally {
                this.destroyed = true;
                ShutdownHookUtil.removeShutdownHook((Thread)this.shutdownHook, (String)this.getClass().getSimpleName(), (Logger)LOG);
            }
        }
    }

    public String getProcessOutput() {
        if (this.processOutput != null) {
            return this.processOutput.toString();
        }
        return null;
    }

    public long getProcessId() {
        Preconditions.checkState((this.process != null ? 1 : 0) != 0, (Object)"process not started");
        try {
            Class<?> clazz = this.process.getClass();
            if (clazz.getName().equals("java.lang.UNIXProcess")) {
                Field pidField = clazz.getDeclaredField("pid");
                pidField.setAccessible(true);
                return pidField.getLong(this.process);
            }
            if (clazz.getName().equals("java.lang.ProcessImpl")) {
                Method pid = clazz.getDeclaredMethod("pid", new Class[0]);
                pid.setAccessible(true);
                return (Long)pid.invoke((Object)this.process, new Object[0]);
            }
            return -1L;
        }
        catch (Throwable ignored) {
            return -1L;
        }
    }

    public boolean isAlive() {
        if (this.destroyed) {
            return false;
        }
        try {
            this.process.exitValue();
            return false;
        }
        catch (IllegalThreadStateException ignored) {
            return true;
        }
    }

    public void waitFor() throws InterruptedException {
        Process process = this.process;
        if (process == null) {
            throw new IllegalStateException("process not started");
        }
        process.waitFor();
    }

    public boolean waitFor(long timeout, TimeUnit unit) throws InterruptedException {
        Process process = this.process;
        if (process != null) {
            return process.waitFor(timeout, unit);
        }
        throw new IllegalStateException("process not started");
    }

    public int exitCode() {
        Process process = this.process;
        if (process != null) {
            return process.exitValue();
        }
        throw new IllegalStateException("process not started");
    }

    public static void touchFile(File file) throws IOException {
        if (!file.exists()) {
            new FileOutputStream(file).close();
        }
        if (!file.setLastModified(System.currentTimeMillis())) {
            throw new IOException("Could not touch the file.");
        }
    }

    public static void waitForMarkerFile(File file, long timeoutMillis) throws InterruptedException {
        boolean exists;
        long deadline = System.nanoTime() + timeoutMillis * 1000000L;
        while (!(exists = file.exists()) && System.nanoTime() < deadline) {
            Thread.sleep(10L);
        }
        if (!exists) {
            Assert.fail((String)("The marker file was not found within " + timeoutMillis + " msecs"));
        }
    }

    public static void killProcessWithSigTerm(long pid) throws Exception {
        Process kill = Runtime.getRuntime().exec("kill " + pid);
        kill.waitFor();
        if (kill.exitValue() != 0) {
            Assert.fail((String)("failed to send SIG_TERM to process " + pid));
        }
    }

    public static void waitForMarkerFiles(File basedir, String prefix, int num, long timeout) {
        long now = System.currentTimeMillis();
        long deadline = now + timeout;
        while (now < deadline) {
            boolean allFound = true;
            for (int i = 0; i < num; ++i) {
                File nextToCheck = new File(basedir, prefix + i);
                if (nextToCheck.exists()) continue;
                allFound = false;
                break;
            }
            if (allFound) {
                return;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            now = System.currentTimeMillis();
        }
        Assert.fail((String)("The tasks were not started within time (" + timeout + "msecs)"));
    }
}

